/*     */ package org.jboss.virtual;
/*     */ 
/*     */ public class VisitorAttributes
/*     */ {
/*  34 */   public static final AcceptAnyFilter RECURSE_ALL = new AcceptAnyFilter(null);
/*     */ 
/*  37 */   public static final VisitorAttributes DEFAULT = new ImmutableVisitorAttributes();
/*     */ 
/*  40 */   public static final VisitorAttributes LEAVES_ONLY = new ImmutableVisitorAttributes(true, null);
/*     */ 
/*  43 */   public static final VisitorAttributes RECURSE = new ImmutableVisitorAttributes(false, RECURSE_ALL);
/*     */ 
/*  46 */   public static final VisitorAttributes RECURSE_LEAVES_ONLY = new ImmutableVisitorAttributes(true, RECURSE_ALL);
/*     */   private boolean includeRoot;
/*     */   private boolean leavesOnly;
/*     */   private boolean ignoreErrors;
/*     */   private boolean includeHidden;
/*     */   private VirtualFileFilter recurseFilter;
/*     */ 
/*     */   public boolean isLeavesOnly()
/*     */   {
/*  72 */     return this.leavesOnly;
/*     */   }
/*     */ 
/*     */   public void setLeavesOnly(boolean leavesOnly)
/*     */   {
/*  83 */     this.leavesOnly = leavesOnly;
/*     */   }
/*     */ 
/*     */   public boolean isRecurse(VirtualFile file)
/*     */   {
/*  97 */     boolean recurse = false;
/*  98 */     if (this.recurseFilter != null)
/*  99 */       recurse = this.recurseFilter.accepts(file);
/* 100 */     return recurse;
/*     */   }
/*     */ 
/*     */   public VirtualFileFilter getRecurseFilter()
/*     */   {
/* 109 */     return this.recurseFilter;
/*     */   }
/*     */ 
/*     */   public void setRecurseFilter(VirtualFileFilter filter)
/*     */   {
/* 120 */     this.recurseFilter = filter;
/*     */   }
/*     */ 
/*     */   public boolean isIncludeRoot()
/*     */   {
/* 132 */     return this.includeRoot;
/*     */   }
/*     */ 
/*     */   public void setIncludeRoot(boolean includeRoot)
/*     */   {
/* 143 */     this.includeRoot = includeRoot;
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreErrors()
/*     */   {
/* 155 */     return this.ignoreErrors;
/*     */   }
/*     */ 
/*     */   public void setIgnoreErrors(boolean ignoreErrors)
/*     */   {
/* 166 */     this.ignoreErrors = ignoreErrors;
/*     */   }
/*     */ 
/*     */   public boolean isIncludeHidden()
/*     */   {
/* 178 */     return this.includeHidden;
/*     */   }
/*     */ 
/*     */   public void setIncludeHidden(boolean includeHidden)
/*     */   {
/* 189 */     this.includeHidden = includeHidden;
/*     */   }
/*     */ 
/*     */   private static class ImmutableVisitorAttributes extends VisitorAttributes
/*     */   {
/*     */     public ImmutableVisitorAttributes()
/*     */     {
/*     */     }
/*     */ 
/*     */     public ImmutableVisitorAttributes(boolean leavesOnly, VirtualFileFilter recurseFilter)
/*     */     {
/* 219 */       super.setLeavesOnly(leavesOnly);
/* 220 */       super.setRecurseFilter(recurseFilter);
/*     */     }
/*     */ 
/*     */     public void setLeavesOnly(boolean leavesOnly)
/*     */     {
/* 226 */       throw new IllegalStateException("The preconfigured attributes are immutable");
/*     */     }
/*     */ 
/*     */     public void setIncludeRoot(boolean includeRoot)
/*     */     {
/* 232 */       throw new IllegalStateException("The preconfigured attributes are immutable");
/*     */     }
/*     */ 
/*     */     public void setRecurseFilter(VirtualFileFilter filter)
/*     */     {
/* 238 */       throw new IllegalStateException("The preconfigured attributes are immutable");
/*     */     }
/*     */ 
/*     */     public void setIgnoreErrors(boolean ignoreErrors)
/*     */     {
/* 244 */       throw new IllegalStateException("The preconfigured attributes are immutable");
/*     */     }
/*     */ 
/*     */     public void setIncludeHidden(boolean includeHidden)
/*     */     {
/* 250 */       throw new IllegalStateException("The preconfigured attributes are immutable");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class AcceptAnyFilter
/*     */     implements VirtualFileFilter
/*     */   {
/*     */     public boolean accepts(VirtualFile file)
/*     */     {
/* 196 */       return true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.VisitorAttributes
 * JD-Core Version:    0.6.0
 */