/*     */ package org.jboss.virtual;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Serializable;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.atomic.AtomicBoolean;
/*     */ import org.jboss.util.collection.WeakSet;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.MatchAllVirtualFileFilter;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class VirtualFile
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private final VirtualFileHandler handler;
/*  57 */   private AtomicBoolean closed = new AtomicBoolean(false);
/*     */ 
/*  60 */   private final transient Set<InputStream> streams = Collections.synchronizedSet(new WeakSet());
/*     */ 
/*     */   public VirtualFile(VirtualFileHandler handler)
/*     */   {
/*  70 */     if (handler == null)
/*  71 */       throw new IllegalArgumentException("Null handler");
/*  72 */     this.handler = handler;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler getHandler()
/*     */   {
/*  83 */     if (this.closed.get())
/*  84 */       throw new IllegalStateException("The virtual file is closed");
/*  85 */     return this.handler;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  96 */     return getHandler().getName();
/*     */   }
/*     */ 
/*     */   public String getPathName()
/*     */   {
/* 107 */     return getHandler().getPathName();
/*     */   }
/*     */ 
/*     */   public URL toURL()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/* 120 */     return getHandler().toVfsUrl();
/*     */   }
/*     */ 
/*     */   public URI toURI()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/* 133 */     return VFSUtils.toURI(toURL());
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */     throws IOException
/*     */   {
/* 145 */     return getHandler().getLastModified();
/*     */   }
/*     */ 
/*     */   public boolean hasBeenModified()
/*     */     throws IOException
/*     */   {
/* 157 */     return getHandler().hasBeenModified();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */     throws IOException
/*     */   {
/* 169 */     return getHandler().getSize();
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */     throws IOException
/*     */   {
/* 179 */     return getHandler().exists();
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */     throws IOException
/*     */   {
/* 192 */     return getHandler().isLeaf();
/*     */   }
/*     */ 
/*     */   public boolean isHidden()
/*     */     throws IOException
/*     */   {
/* 204 */     return getHandler().isHidden();
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 216 */     InputStream result = getHandler().openStream();
/* 217 */     this.streams.add(result);
/* 218 */     return result;
/*     */   }
/*     */ 
/*     */   public void closeStreams()
/*     */   {
/* 227 */     for (InputStream stream : this.streams)
/*     */     {
/* 229 */       if (stream != null)
/*     */       {
/*     */         try
/*     */         {
/* 233 */           stream.close();
/*     */         }
/*     */         catch (IOException ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/* 240 */     this.streams.clear();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/* 248 */     if (!this.closed.getAndSet(true))
/*     */     {
/* 250 */       closeStreams();
/* 251 */       this.handler.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public VFS getVFS()
/*     */   {
/* 263 */     VFSContext context = getHandler().getVFSContext();
/* 264 */     return context.getVFS();
/*     */   }
/*     */ 
/*     */   public VirtualFile getParent()
/*     */     throws IOException
/*     */   {
/* 276 */     VirtualFileHandler parent = getHandler().getParent();
/* 277 */     if (parent != null)
/* 278 */       return parent.getVirtualFile();
/* 279 */     return null;
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildren()
/*     */     throws IOException
/*     */   {
/* 291 */     return getChildren(null);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildren(VirtualFileFilter filter)
/*     */     throws IOException
/*     */   {
/* 304 */     if (isLeaf()) {
/* 305 */       throw new IllegalStateException("File cannot contain children: " + this);
/*     */     }
/* 307 */     if (filter == null)
/* 308 */       filter = MatchAllVirtualFileFilter.INSTANCE;
/* 309 */     FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, null);
/* 310 */     visit(visitor);
/* 311 */     return visitor.getMatched();
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildrenRecursively()
/*     */     throws IOException
/*     */   {
/* 325 */     return getChildrenRecursively(null);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter)
/*     */     throws IOException
/*     */   {
/* 340 */     if (isLeaf()) {
/* 341 */       throw new IllegalStateException("File cannot contain children: " + this);
/*     */     }
/* 343 */     if (filter == null)
/* 344 */       filter = MatchAllVirtualFileFilter.INSTANCE;
/* 345 */     FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, VisitorAttributes.RECURSE);
/* 346 */     visit(visitor);
/* 347 */     return visitor.getMatched();
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFileVisitor visitor)
/*     */     throws IOException
/*     */   {
/* 360 */     if (isLeaf()) {
/* 361 */       throw new IllegalStateException("File cannot contain children: " + this);
/*     */     }
/* 363 */     getVFS().visit(this, visitor);
/*     */   }
/*     */ 
/*     */   public VirtualFile findChild(String path)
/*     */     throws IOException
/*     */   {
/* 377 */     VirtualFileHandler handler = getHandler();
/*     */ 
/* 379 */     if (handler.isLeaf()) {
/* 380 */       throw new IllegalStateException("File cannot contain children: " + this);
/*     */     }
/* 382 */     path = VFSUtils.fixName(path);
/* 383 */     VirtualFileHandler child = handler.findChild(path);
/* 384 */     return child.getVirtualFile();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 390 */     return this.handler.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 396 */     return this.handler.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 402 */     if (obj == this)
/* 403 */       return true;
/* 404 */     if ((obj == null) || (!(obj instanceof VirtualFile)))
/* 405 */       return false;
/* 406 */     VirtualFile other = (VirtualFile)obj;
/* 407 */     return this.handler.equals(other.handler);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.VirtualFile
 * JD-Core Version:    0.6.0
 */