/*     */ package org.jboss.virtual;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Attributes.Name;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.virtual.spi.LinkInfo;
/*     */ 
/*     */ public class VFSUtils
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(VFSUtils.class);
/*     */   public static final String VFS_LINK_PREFIX = ".vfslink";
/*     */   public static final String VFS_LINK_NAME = "vfs.link.name";
/*     */   public static final String VFS_LINK_TARGET = "vfs.link.target";
/*     */ 
/*     */   public static String getPathsString(Collection<VirtualFile> paths)
/*     */   {
/*  70 */     StringBuilder buffer = new StringBuilder();
/*  71 */     boolean first = true;
/*  72 */     for (VirtualFile path : paths)
/*     */     {
/*  74 */       if (path == null)
/*  75 */         throw new IllegalArgumentException("Null path in " + paths);
/*  76 */       if (!first)
/*  77 */         buffer.append(':');
/*     */       else
/*  79 */         first = false;
/*  80 */       buffer.append(path.getPathName());
/*     */     }
/*     */ 
/*  83 */     if (first == true) {
/*  84 */       buffer.append("<empty>");
/*     */     }
/*  86 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public static void addManifestLocations(VirtualFile file, List<VirtualFile> paths)
/*     */     throws IOException
/*     */   {
/* 101 */     if (file == null)
/* 102 */       throw new IllegalArgumentException("Null file");
/* 103 */     if (paths == null) {
/* 104 */       throw new IllegalArgumentException("Null paths");
/*     */     }
/* 106 */     Manifest manifest = getManifest(file);
/* 107 */     if (manifest == null) {
/* 108 */       return;
/*     */     }
/* 110 */     Attributes mainAttributes = manifest.getMainAttributes();
/* 111 */     String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
/*     */ 
/* 113 */     if (classPath == null)
/*     */     {
/* 115 */       if (log.isTraceEnabled())
/* 116 */         log.trace("Manifest has no Class-Path for " + file.getPathName());
/* 117 */       return;
/*     */     }
/*     */ 
/* 120 */     VirtualFile parent = file.getParent();
/* 121 */     if (parent == null) {
/* 122 */       throw new IllegalStateException(file + " has no parent.");
/*     */     }
/* 124 */     URL parentURL = null;
/* 125 */     URL vfsRootURL = null;
/* 126 */     int rootPathLength = 0;
/*     */     try
/*     */     {
/* 129 */       parentURL = parent.toURL();
/* 130 */       vfsRootURL = file.getVFS().getRoot().toURL();
/* 131 */       rootPathLength = vfsRootURL.getPath().length();
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 135 */       IOException ioe = new IOException("Failed to get parent URL");
/* 136 */       ioe.initCause(e);
/*     */     }
/*     */ 
/* 139 */     StringTokenizer tokenizer = new StringTokenizer(classPath);
/* 140 */     while (tokenizer.hasMoreTokens())
/*     */     {
/* 142 */       String path = tokenizer.nextToken();
/*     */       try
/*     */       {
/* 146 */         URL libURL = new URL(parentURL, path);
/* 147 */         String libPath = libURL.getPath();
/*     */ 
/* 149 */         if (rootPathLength > libPath.length())
/* 150 */           throw new IOException("Invalid rootPath: " + vfsRootURL + ", libPath: " + libPath);
/* 151 */         String vfsLibPath = libPath.substring(rootPathLength);
/* 152 */         VirtualFile vf = file.getVFS().findChild(vfsLibPath);
/* 153 */         paths.add(vf);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 157 */         log.debug("Manifest Class-Path entry " + path + " ignored for " + file.getPathName() + " reason=" + e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Manifest getManifest(VirtualFile archive)
/*     */     throws IOException
/*     */   {
/* 174 */     if (archive == null)
/* 175 */       throw new IllegalArgumentException("Null archive");
/*     */     VirtualFile manifest;
/*     */     try
/*     */     {
/* 180 */       manifest = archive.findChild("META-INF/MANIFEST.MF");
/*     */     }
/*     */     catch (IOException ignored)
/*     */     {
/* 184 */       log.debug("Can't find manifest for " + archive.getPathName());
/* 185 */       return null;
/*     */     }
/* 187 */     return readManifest(manifest);
/*     */   }
/*     */ 
/*     */   public static Manifest readManifest(VirtualFile manifest)
/*     */     throws IOException
/*     */   {
/* 199 */     InputStream stream = manifest.openStream();
/*     */     try
/*     */     {
/* 202 */       Manifest localManifest = new Manifest(stream);
/*     */       return localManifest;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 208 */         stream.close();
/*     */       } catch (IOException ignored) {
/*     */       }
/*     */     }
/* 212 */     throw localObject;
/*     */   }
/*     */ 
/*     */   public static Manifest getManifest(VFS archive)
/*     */     throws IOException
/*     */   {
/* 227 */     VirtualFile root = archive.getRoot();
/* 228 */     return getManifest(root);
/*     */   }
/*     */ 
/*     */   public static String fixName(String name)
/*     */   {
/* 240 */     if (name == null) {
/* 241 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 243 */     int length = name.length();
/* 244 */     if (length <= 1)
/* 245 */       return name;
/* 246 */     if (name.charAt(length - 1) == '/')
/* 247 */       return name.substring(0, length - 1);
/* 248 */     return name;
/*     */   }
/*     */ 
/*     */   public static String getName(URI uri)
/*     */   {
/* 258 */     String name = uri.getPath();
/* 259 */     if (name != null)
/*     */     {
/* 262 */       int lastSlash = name.lastIndexOf('/');
/* 263 */       if (lastSlash > 0)
/* 264 */         name = name.substring(lastSlash + 1);
/*     */     }
/* 266 */     return name;
/*     */   }
/*     */ 
/*     */   public static Map<String, String> parseURLQuery(String query)
/*     */   {
/* 277 */     HashMap pairsMap = new HashMap();
/* 278 */     if (query != null)
/*     */     {
/* 280 */       StringTokenizer tokenizer = new StringTokenizer(query, "=&");
/* 281 */       while (tokenizer.hasMoreTokens())
/*     */       {
/* 283 */         String name = tokenizer.nextToken();
/* 284 */         String value = tokenizer.nextToken();
/* 285 */         pairsMap.put(name, value);
/*     */       }
/*     */     }
/* 288 */     return pairsMap;
/*     */   }
/*     */ 
/*     */   public static boolean isLink(String name)
/*     */   {
/* 298 */     return name.indexOf(".vfslink") >= 0;
/*     */   }
/*     */ 
/*     */   public static List<LinkInfo> readLinkInfo(InputStream is, String name, Properties props)
/*     */     throws IOException, URISyntaxException
/*     */   {
/* 315 */     ArrayList info = new ArrayList();
/* 316 */     if (name.endsWith(".properties"))
/* 317 */       parseLinkProperties(is, info, props);
/*     */     else
/* 319 */       throw new UnsupportedEncodingException("Unknown link format: " + name);
/* 320 */     return info;
/*     */   }
/*     */ 
/*     */   public static void parseLinkProperties(InputStream is, List<LinkInfo> info, Properties props)
/*     */     throws IOException, URISyntaxException
/*     */   {
/* 335 */     props.load(is);
/*     */ 
/* 337 */     for (int n = 0; ; n++)
/*     */     {
/* 339 */       String nameKey = "vfs.link.name." + n;
/* 340 */       String name = props.getProperty(nameKey);
/* 341 */       String uriKey = "vfs.link.target." + n;
/* 342 */       String uri = props.getProperty(uriKey);
/*     */ 
/* 344 */       if (uri == null)
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/* 349 */       uri = StringPropertyReplacer.replaceProperties(uri);
/* 350 */       LinkInfo link = new LinkInfo(name, new URI(uri));
/* 351 */       info.add(link);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static URI toURI(URL url)
/*     */     throws URISyntaxException
/*     */   {
/* 364 */     String urispec = url.toExternalForm();
/*     */ 
/* 366 */     urispec = urispec.replaceAll(" ", "%20");
/* 367 */     return new URI(urispec);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.VFSUtils
 * JD-Core Version:    0.6.0
 */