/*     */ package org.jboss.virtual;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.util.file.ArchiveBrowser;
/*     */ import org.jboss.virtual.plugins.context.VfsArchiveBrowserFactory;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.WrappingVirtualFileHandlerVisitor;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VFSContextFactory;
/*     */ import org.jboss.virtual.spi.VFSContextFactoryLocator;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class VFS
/*     */ {
/*     */   private final VFSContext context;
/*     */ 
/*     */   public static void init()
/*     */   {
/*  56 */     String pkgs = System.getProperty("java.protocol.handler.pkgs");
/*  57 */     if ((pkgs == null) || (pkgs.trim().length() == 0))
/*     */     {
/*  59 */       pkgs = "org.jboss.virtual.protocol";
/*  60 */       System.setProperty("java.protocol.handler.pkgs", pkgs);
/*     */     }
/*  62 */     else if (!pkgs.contains("org.jboss.virtual.protocol"))
/*     */     {
/*  64 */       pkgs = pkgs + "|org.jboss.virtual.protocol";
/*  65 */       System.setProperty("java.protocol.handler.pkgs", pkgs);
/*     */     }
/*     */ 
/*  68 */     ArchiveBrowser.factoryFinder.put("vfsfile", new VfsArchiveBrowserFactory());
/*  69 */     ArchiveBrowser.factoryFinder.put("vfsjar", new VfsArchiveBrowserFactory());
/*  70 */     ArchiveBrowser.factoryFinder.put("vfs", new VfsArchiveBrowserFactory());
/*     */   }
/*     */ 
/*     */   public static VFS getVFS(URI rootURI)
/*     */     throws IOException
/*     */   {
/*  83 */     VFSContextFactory factory = VFSContextFactoryLocator.getFactory(rootURI);
/*  84 */     if (factory == null)
/*  85 */       throw new IOException("No context factory for " + rootURI);
/*  86 */     VFSContext context = factory.getVFS(rootURI);
/*  87 */     return context.getVFS();
/*     */   }
/*     */ 
/*     */   public static VirtualFile getRoot(URI rootURI)
/*     */     throws IOException
/*     */   {
/* 100 */     VFS vfs = getVFS(rootURI);
/* 101 */     return vfs.getRoot();
/*     */   }
/*     */ 
/*     */   public static VirtualFile getVirtualFile(URI rootURI, String name)
/*     */     throws IOException
/*     */   {
/* 115 */     VFS vfs = getVFS(rootURI);
/* 116 */     return vfs.findChild(name);
/*     */   }
/*     */ 
/*     */   public static VFS getVFS(URL rootURL)
/*     */     throws IOException
/*     */   {
/* 129 */     VFSContextFactory factory = VFSContextFactoryLocator.getFactory(rootURL);
/* 130 */     if (factory == null)
/* 131 */       throw new IOException("No context factory for " + rootURL);
/* 132 */     VFSContext context = factory.getVFS(rootURL);
/* 133 */     return context.getVFS();
/*     */   }
/*     */ 
/*     */   public static VirtualFile getRoot(URL rootURL)
/*     */     throws IOException
/*     */   {
/* 146 */     VFS vfs = getVFS(rootURL);
/* 147 */     return vfs.getRoot();
/*     */   }
/*     */ 
/*     */   public static VirtualFile getVirtualFile(URL rootURL, String name)
/*     */     throws IOException
/*     */   {
/* 161 */     VFS vfs = getVFS(rootURL);
/* 162 */     return vfs.findChild(name);
/*     */   }
/*     */ 
/*     */   public VFS(VFSContext context)
/*     */   {
/* 173 */     if (context == null)
/* 174 */       throw new IllegalArgumentException("Null name");
/* 175 */     this.context = context;
/*     */   }
/*     */ 
/*     */   public VirtualFile getRoot()
/*     */     throws IOException
/*     */   {
/* 186 */     VirtualFileHandler handler = this.context.getRoot();
/* 187 */     return handler.getVirtualFile();
/*     */   }
/*     */ 
/*     */   public VirtualFile findChild(String path)
/*     */     throws IOException
/*     */   {
/* 200 */     if (path == null) {
/* 201 */       throw new IllegalArgumentException("Null path");
/*     */     }
/* 203 */     VirtualFileHandler handler = this.context.getRoot();
/* 204 */     path = VFSUtils.fixName(path);
/* 205 */     VirtualFileHandler result = this.context.findChild(handler, path);
/* 206 */     return result.getVirtualFile();
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public VirtualFile findChildFromRoot(String path)
/*     */     throws IOException
/*     */   {
/* 221 */     return findChild(path);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildren()
/*     */     throws IOException
/*     */   {
/* 233 */     return getRoot().getChildren(null);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildren(VirtualFileFilter filter)
/*     */     throws IOException
/*     */   {
/* 246 */     return getRoot().getChildren(filter);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildrenRecursively()
/*     */     throws IOException
/*     */   {
/* 260 */     return getRoot().getChildrenRecursively(null);
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter)
/*     */     throws IOException
/*     */   {
/* 275 */     return getRoot().getChildrenRecursively(filter);
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFileVisitor visitor)
/*     */     throws IOException
/*     */   {
/* 288 */     VirtualFileHandler handler = this.context.getRoot();
/* 289 */     if (handler.isLeaf()) {
/* 290 */       throw new IllegalStateException("File cannot contain children: " + handler);
/*     */     }
/* 292 */     WrappingVirtualFileHandlerVisitor wrapper = new WrappingVirtualFileHandlerVisitor(visitor);
/* 293 */     this.context.visit(handler, wrapper);
/*     */   }
/*     */ 
/*     */   protected void visit(VirtualFile file, VirtualFileVisitor visitor)
/*     */     throws IOException
/*     */   {
/* 307 */     if (file == null) {
/* 308 */       throw new IllegalArgumentException("Null file");
/*     */     }
/* 310 */     VirtualFileHandler handler = file.getHandler();
/* 311 */     WrappingVirtualFileHandlerVisitor wrapper = new WrappingVirtualFileHandlerVisitor(visitor);
/* 312 */     VFSContext handlerContext = handler.getVFSContext();
/* 313 */     handlerContext.visit(handler, wrapper);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 319 */     return this.context.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 325 */     return this.context.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 331 */     if (obj == this)
/* 332 */       return true;
/* 333 */     if ((obj == null) || (!(obj instanceof VFS)))
/* 334 */       return false;
/* 335 */     VFS other = (VFS)obj;
/* 336 */     return this.context.equals(other.context);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  51 */     init();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.VFS
 * JD-Core Version:    0.6.0
 */