/*      */ package org.jboss.verifier.strategy;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.Arrays;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.BeanMetaData;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.metadata.MessageDrivenMetaData;
/*      */ import org.jboss.metadata.SessionMetaData;
/*      */ import org.jboss.verifier.Section;
/*      */ 
/*      */ public class EJBVerifier21 extends AbstractEJB2xVerifier
/*      */ {
/*   50 */   private static Logger log = Logger.getLogger(EJBVerifier21.class);
/*      */ 
/*      */   public EJBVerifier21(VerificationContext context)
/*      */   {
/*   57 */     super(context);
/*      */   }
/*      */ 
/*      */   public String getMessageBundle()
/*      */   {
/*   62 */     return "EJB21Messages.properties";
/*      */   }
/*      */ 
/*      */   public void checkSession(SessionMetaData session)
/*      */   {
/*   72 */     boolean localOrRemoteExists = false;
/*   73 */     boolean serviceEndpointExists = false;
/*   74 */     boolean verified = false;
/*      */ 
/*   76 */     if (!verifyBean(session)) {
/*   77 */       return;
/*      */     }
/*   79 */     verified = verifySessionBean(session);
/*      */ 
/*   81 */     if (hasRemoteInterfaces(session))
/*      */     {
/*   84 */       localOrRemoteExists = true;
/*   85 */       verified = (verified) && (verifySessionRemote(session));
/*   86 */       verified = (verified) && (verifySessionHome(session));
/*      */     }
/*      */ 
/*   89 */     if (hasLocalInterfaces(session))
/*      */     {
/*   92 */       localOrRemoteExists = true;
/*   93 */       verified = (verified) && (verifySessionLocal(session));
/*   94 */       verified = (verified) && (verifySessionLocalHome(session));
/*      */     }
/*      */ 
/*   97 */     if (hasServiceEndpointInterfaces(session))
/*      */     {
/*  100 */       serviceEndpointExists = true;
/*  101 */       verified = (verified) && (verifyServiceEndpoint(session));
/*      */     }
/*      */ 
/*  112 */     if ((!localOrRemoteExists) && (!serviceEndpointExists))
/*      */     {
/*  114 */       fireSpecViolationEvent(session, new Section("7.11.1"));
/*  115 */       verified = false;
/*      */     }
/*      */ 
/*  118 */     if (verified)
/*      */     {
/*  121 */       fireBeanVerifiedEvent(session);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void checkEntity(EntityMetaData entity)
/*      */   {
/*  127 */     if (entity.isCMP1x())
/*      */     {
/*  129 */       this.cmp1XVerifier.checkEntity(entity);
/*      */     }
/*      */     else
/*      */     {
/*  133 */       checkBmpOrCmp2Entity(entity);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void checkMessageBean(MessageDrivenMetaData mdb)
/*      */   {
/*  139 */     boolean beanVerified = false;
/*      */ 
/*  141 */     if (!verifyBean(mdb)) {
/*  142 */       return;
/*      */     }
/*  144 */     beanVerified = verifyMessageDrivenBean(mdb);
/*      */ 
/*  146 */     if (beanVerified)
/*      */     {
/*  149 */       fireBeanVerifiedEvent(mdb);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void checkBmpOrCmp2Entity(EntityMetaData entity)
/*      */   {
/*  155 */     boolean localOrRemoteExists = false;
/*  156 */     boolean verified = false;
/*      */ 
/*  158 */     if (!verifyBean(entity)) {
/*  159 */       return;
/*      */     }
/*  161 */     if (entity.isCMP())
/*      */     {
/*  163 */       verified = verifyCMPEntityBean(entity);
/*      */     }
/*  165 */     else if (entity.isBMP())
/*      */     {
/*  167 */       verified = verifyBMPEntityBean(entity);
/*      */     }
/*      */ 
/*  170 */     if (hasRemoteInterfaces(entity))
/*      */     {
/*  173 */       localOrRemoteExists = true;
/*  174 */       verified = (verified) && (verifyEntityRemote(entity));
/*  175 */       verified = (verified) && (verifyEntityHome(entity));
/*      */     }
/*      */ 
/*  178 */     if (hasLocalInterfaces(entity))
/*      */     {
/*  181 */       localOrRemoteExists = true;
/*  182 */       verified = (verified) && (verifyEntityLocal(entity));
/*  183 */       verified = (verified) && (verifyEntityLocalHome(entity));
/*      */     }
/*      */ 
/*  186 */     verified = (verified) && (verifyPrimaryKey(entity));
/*      */ 
/*  188 */     if (!localOrRemoteExists)
/*      */     {
/*  196 */       if (entity.isCMP())
/*      */       {
/*  198 */         fireSpecViolationEvent(entity, new Section("10.6.1"));
/*  199 */         verified = false;
/*      */       }
/*      */       else
/*      */       {
/*  203 */         fireSpecViolationEvent(entity, new Section("12.2.1"));
/*  204 */         verified = false;
/*      */       }
/*      */     }
/*      */ 
/*  208 */     if (verified)
/*      */     {
/*  210 */       fireBeanVerifiedEvent(entity);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean verifyBean(BeanMetaData theBean)
/*      */   {
/*  222 */     String beanName = theBean.getEjbClass();
/*      */ 
/*  224 */     if (beanName == null) {
/*  225 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  229 */       this.bean = this.classloader.loadClass(beanName);
/*  230 */       return true;
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  234 */       fireSpecViolationEvent(theBean, new Section("22.2.b", "Class not found on '" + beanName + "': " + cnfe.getMessage()));
/*      */     }
/*  236 */     return false;
/*      */   }
/*      */ 
/*      */   protected boolean hasRemoteInterfaces(BeanMetaData bean)
/*      */   {
/*  248 */     boolean status = true;
/*  249 */     String homeName = bean.getHome();
/*  250 */     String remoteName = bean.getRemote();
/*      */ 
/*  252 */     if ((homeName == null) || (remoteName == null)) {
/*  253 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  258 */       this.home = this.classloader.loadClass(homeName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  262 */       fireSpecViolationEvent(bean, new Section("22.2.c", "Class not found on '" + homeName + "': " + cnfe.getMessage()));
/*      */ 
/*  264 */       status = false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  270 */       this.remote = this.classloader.loadClass(remoteName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  274 */       fireSpecViolationEvent(bean, new Section("22.2.d", "Class not found on '" + remoteName + "': " + cnfe.getMessage()));
/*      */ 
/*  276 */       status = false;
/*      */     }
/*      */ 
/*  279 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean hasLocalInterfaces(BeanMetaData bean)
/*      */   {
/*  290 */     boolean status = true;
/*  291 */     String localHomeName = bean.getLocalHome();
/*  292 */     String localName = bean.getLocal();
/*      */ 
/*  294 */     if ((localHomeName == null) || (localName == null)) {
/*  295 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  300 */       this.localHome = this.classloader.loadClass(localHomeName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  304 */       fireSpecViolationEvent(bean, new Section("22.2.e", "Class not found on '" + localHomeName + "': " + cnfe.getMessage()));
/*      */ 
/*  307 */       status = false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  312 */       this.local = this.classloader.loadClass(localName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/*  316 */       fireSpecViolationEvent(bean, new Section("22.2.f", "Class not found on '" + localName + "': " + cnfe.getMessage()));
/*      */ 
/*  318 */       status = false;
/*      */     }
/*      */ 
/*  321 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionHome(SessionMetaData session)
/*      */   {
/*  332 */     boolean status = true;
/*      */ 
/*  344 */     if (session.isStateless())
/*      */     {
/*  346 */       if (!hasDefaultCreateMethod(this.home))
/*      */       {
/*  348 */         fireSpecViolationEvent(session, new Section("7.11.6.d2"));
/*  349 */         status = false;
/*      */       }
/*      */       else
/*      */       {
/*  353 */         Method create = getDefaultCreateMethod(this.home);
/*      */ 
/*  355 */         if (hasMoreThanOneCreateMethods(this.home))
/*      */         {
/*  357 */           fireSpecViolationEvent(session, new Section("7.11.6.d2"));
/*  358 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  368 */     if (!hasEJBHomeInterface(this.home))
/*      */     {
/*  370 */       fireSpecViolationEvent(session, new Section("7.11.6.a"));
/*  371 */       status = false;
/*      */     }
/*      */ 
/*  385 */     Iterator it = Arrays.asList(this.home.getMethods()).iterator();
/*  386 */     while (it.hasNext())
/*      */     {
/*  388 */       Method method = (Method)it.next();
/*      */ 
/*  390 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/*  392 */         fireSpecViolationEvent(session, method, new Section("7.11.6.b1"));
/*  393 */         status = false;
/*      */       }
/*      */ 
/*  396 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/*  398 */         fireSpecViolationEvent(session, method, new Section("7.11.6.b2"));
/*  399 */         status = false;
/*      */       }
/*      */ 
/*  402 */       if (!throwsRemoteException(method))
/*      */       {
/*  404 */         fireSpecViolationEvent(session, method, new Section("7.11.6.b3"));
/*  405 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  414 */     if (!hasCreateMethod(this.home))
/*      */     {
/*  416 */       fireSpecViolationEvent(session, new Section("7.11.6.d1"));
/*  417 */       status = false;
/*      */     }
/*      */ 
/*  440 */     Iterator createMethods = getCreateMethods(this.home);
/*  441 */     while (createMethods.hasNext())
/*      */     {
/*  443 */       Method create = (Method)createMethods.next();
/*      */ 
/*  445 */       if (!hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  447 */         fireSpecViolationEvent(session, create, new Section("7.11.6.e"));
/*  448 */         status = false;
/*      */       }
/*      */ 
/*  451 */       if (!hasRemoteReturnType(session, create))
/*      */       {
/*  453 */         fireSpecViolationEvent(session, create, new Section("7.11.6.f"));
/*  454 */         status = false;
/*      */       }
/*      */ 
/*  457 */       if (hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  459 */         Method ejbCreate = getMatchingEJBCreate(this.bean, create);
/*  460 */         if (!hasMatchingExceptions(ejbCreate, create))
/*      */         {
/*  462 */           fireSpecViolationEvent(session, create, new Section("7.11.6.g"));
/*      */ 
/*  464 */           status = false;
/*      */         }
/*      */       }
/*      */ 
/*  468 */       if (!throwsCreateException(create))
/*      */       {
/*  470 */         fireSpecViolationEvent(session, create, new Section("7.11.6.h"));
/*  471 */         status = false;
/*      */       }
/*      */     }
/*      */ 
/*  475 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionLocalHome(SessionMetaData session)
/*      */   {
/*  486 */     boolean status = true;
/*      */ 
/*  495 */     if (session.isStateless())
/*      */     {
/*  497 */       if (!hasDefaultCreateMethod(this.localHome))
/*      */       {
/*  499 */         fireSpecViolationEvent(session, new Section("7.11.8.d2"));
/*  500 */         status = false;
/*      */       }
/*      */       else
/*      */       {
/*  504 */         Method create = getDefaultCreateMethod(this.localHome);
/*      */ 
/*  506 */         if (hasMoreThanOneCreateMethods(this.localHome))
/*      */         {
/*  508 */           fireSpecViolationEvent(session, new Section("7.11.8.d2"));
/*  509 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  519 */     if (!hasEJBLocalHomeInterface(this.localHome))
/*      */     {
/*  521 */       fireSpecViolationEvent(session, new Section("7.11.8.a"));
/*  522 */       status = false;
/*      */     }
/*      */ 
/*  530 */     Iterator it = Arrays.asList(this.localHome.getMethods()).iterator();
/*  531 */     while (it.hasNext())
/*      */     {
/*  533 */       Method method = (Method)it.next();
/*      */ 
/*  535 */       if (throwsRemoteException(method))
/*      */       {
/*  537 */         fireSpecViolationEvent(session, method, new Section("7.11.8.b"));
/*  538 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  547 */     if (!hasCreateMethod(this.localHome))
/*      */     {
/*  549 */       fireSpecViolationEvent(session, new Section("7.11.8.d1"));
/*  550 */       status = false;
/*      */     }
/*      */ 
/*  573 */     Iterator createMethods = getCreateMethods(this.localHome);
/*  574 */     while (createMethods.hasNext())
/*      */     {
/*  576 */       Method create = (Method)createMethods.next();
/*      */ 
/*  578 */       if (!hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  580 */         fireSpecViolationEvent(session, create, new Section("7.11.8.e"));
/*      */ 
/*  582 */         status = false;
/*      */       }
/*      */ 
/*  585 */       if (!hasLocalReturnType(session, create))
/*      */       {
/*  587 */         fireSpecViolationEvent(session, create, new Section("7.11.8.f"));
/*      */ 
/*  589 */         status = false;
/*      */       }
/*      */ 
/*  592 */       if (hasMatchingEJBCreate(this.bean, create))
/*      */       {
/*  594 */         Method ejbCreate = getMatchingEJBCreate(this.bean, create);
/*  595 */         if (!hasMatchingExceptions(ejbCreate, create))
/*      */         {
/*  597 */           fireSpecViolationEvent(session, create, new Section("7.11.8.g"));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  602 */       if (!throwsCreateException(create))
/*      */       {
/*  604 */         fireSpecViolationEvent(session, create, new Section("7.11.8.h"));
/*      */ 
/*  606 */         status = false;
/*      */       }
/*      */     }
/*      */ 
/*  610 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionRemote(SessionMetaData session)
/*      */   {
/*  618 */     boolean status = true;
/*      */ 
/*  625 */     if (!hasEJBObjectInterface(this.remote))
/*      */     {
/*  627 */       fireSpecViolationEvent(session, new Section("7.11.5.a"));
/*  628 */       status = false;
/*      */     }
/*      */ 
/*  642 */     Iterator it = Arrays.asList(this.remote.getMethods()).iterator();
/*  643 */     while (it.hasNext())
/*      */     {
/*  645 */       Method method = (Method)it.next();
/*      */ 
/*  647 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/*  649 */         fireSpecViolationEvent(session, method, new Section("7.11.5.b1"));
/*  650 */         status = false;
/*      */       }
/*      */ 
/*  653 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/*  655 */         fireSpecViolationEvent(session, method, new Section("7.11.5.b2"));
/*  656 */         status = false;
/*      */       }
/*      */ 
/*  659 */       if (!throwsRemoteException(method))
/*      */       {
/*  661 */         fireSpecViolationEvent(session, method, new Section("7.11.5.b3"));
/*  662 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  679 */     it = Arrays.asList(this.remote.getDeclaredMethods()).iterator();
/*  680 */     while (it.hasNext())
/*      */     {
/*  682 */       Method remoteMethod = (Method)it.next();
/*      */ 
/*  684 */       if (!hasMatchingMethod(this.bean, remoteMethod))
/*      */       {
/*  686 */         fireSpecViolationEvent(session, remoteMethod, new Section("7.11.5.d1"));
/*      */ 
/*  689 */         status = false;
/*      */       }
/*      */ 
/*  692 */       if (hasMatchingMethod(this.bean, remoteMethod))
/*      */       {
/*      */         try
/*      */         {
/*  696 */           Method beanMethod = this.bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
/*      */ 
/*  699 */           if (!hasMatchingReturnType(remoteMethod, beanMethod))
/*      */           {
/*  701 */             fireSpecViolationEvent(session, remoteMethod, new Section("7.11.5.d2"));
/*      */ 
/*  703 */             status = false;
/*      */           }
/*      */ 
/*  706 */           if (!hasMatchingExceptions(beanMethod, remoteMethod))
/*      */           {
/*  708 */             fireSpecViolationEvent(session, remoteMethod, new Section("7.11.5.d3"));
/*      */ 
/*  710 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  719 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionLocal(SessionMetaData session)
/*      */   {
/*  727 */     boolean status = true;
/*      */ 
/*  734 */     if (!hasEJBLocalObjectInterface(this.local))
/*      */     {
/*  736 */       fireSpecViolationEvent(session, new Section("7.11.7.a"));
/*  737 */       status = false;
/*      */     }
/*      */ 
/*  745 */     Iterator it = Arrays.asList(this.local.getMethods()).iterator();
/*  746 */     while (it.hasNext())
/*      */     {
/*  748 */       Method method = (Method)it.next();
/*  749 */       if (throwsRemoteException(method))
/*      */       {
/*  751 */         fireSpecViolationEvent(session, method, new Section("7.11.7.b"));
/*  752 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  769 */     it = Arrays.asList(this.local.getDeclaredMethods()).iterator();
/*  770 */     while (it.hasNext())
/*      */     {
/*  772 */       Method localMethod = (Method)it.next();
/*      */ 
/*  774 */       if (!hasMatchingMethod(this.bean, localMethod))
/*      */       {
/*  776 */         fireSpecViolationEvent(session, localMethod, new Section("7.11.7.d1"));
/*      */ 
/*  778 */         status = false;
/*      */       }
/*      */ 
/*  781 */       if (hasMatchingMethod(this.bean, localMethod))
/*      */       {
/*      */         try
/*      */         {
/*  785 */           Method beanMethod = this.bean.getMethod(localMethod.getName(), localMethod.getParameterTypes());
/*      */ 
/*  788 */           if (!hasMatchingReturnType(localMethod, beanMethod))
/*      */           {
/*  790 */             fireSpecViolationEvent(session, localMethod, new Section("7.11.7.d2"));
/*      */ 
/*  792 */             status = false;
/*      */           }
/*      */ 
/*  795 */           if (!hasMatchingExceptions(beanMethod, localMethod))
/*      */           {
/*  797 */             fireSpecViolationEvent(session, localMethod, new Section("7.11.7.d3"));
/*      */ 
/*  799 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  808 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifySessionBean(SessionMetaData session)
/*      */   {
/*  816 */     boolean status = true;
/*      */ 
/*  823 */     if (!hasSessionBeanInterface(this.bean))
/*      */     {
/*  825 */       fireSpecViolationEvent(session, new Section("7.11.2.a"));
/*  826 */       status = false;
/*      */     }
/*      */ 
/*  838 */     if (hasSessionSynchronizationInterface(this.bean))
/*      */     {
/*  840 */       if (session.isStateless())
/*      */       {
/*  842 */         fireSpecViolationEvent(session, new Section("7.5.3.a"));
/*  843 */         status = false;
/*      */       }
/*      */ 
/*  846 */       if (session.isBeanManagedTx())
/*      */       {
/*  848 */         fireSpecViolationEvent(session, new Section("7.5.3.b"));
/*  849 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  858 */     if (!hasEJBCreateMethod(this.bean, true))
/*      */     {
/*  860 */       fireSpecViolationEvent(session, new Section("7.11.3"));
/*  861 */       status = false;
/*      */     }
/*      */ 
/*  869 */     if ((hasSessionSynchronizationInterface(this.bean)) && (session.isBeanManagedTx()))
/*      */     {
/*  872 */       fireSpecViolationEvent(session, new Section("7.6.1"));
/*  873 */       status = false;
/*      */     }
/*      */ 
/*  880 */     if (!isPublic(this.bean))
/*      */     {
/*  882 */       fireSpecViolationEvent(session, new Section("7.11.2.b1"));
/*  883 */       status = false;
/*      */     }
/*      */ 
/*  890 */     if (isFinal(this.bean))
/*      */     {
/*  892 */       fireSpecViolationEvent(session, new Section("7.11.2.b2"));
/*  893 */       status = false;
/*      */     }
/*      */ 
/*  900 */     if (isAbstract(this.bean))
/*      */     {
/*  902 */       fireSpecViolationEvent(session, new Section("7.11.2.b3"));
/*  903 */       status = false;
/*      */     }
/*      */ 
/*  911 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/*  913 */       fireSpecViolationEvent(session, new Section("7.11.2.c"));
/*  914 */       status = false;
/*      */     }
/*      */ 
/*  921 */     if (hasFinalizer(this.bean))
/*      */     {
/*  923 */       fireSpecViolationEvent(session, new Section("7.11.2.d"));
/*  924 */       status = false;
/*      */     }
/*      */ 
/*  939 */     if (hasEJBCreateMethod(this.bean, true))
/*      */     {
/*  941 */       Iterator it = getEJBCreateMethods(this.bean);
/*  942 */       while (it.hasNext())
/*      */       {
/*  944 */         Method ejbCreate = (Method)it.next();
/*      */ 
/*  946 */         if (!isPublic(ejbCreate))
/*      */         {
/*  948 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.11.3.b"));
/*      */ 
/*  950 */           status = false;
/*      */         }
/*      */ 
/*  953 */         if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */         {
/*  955 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.11.3.c"));
/*      */ 
/*  957 */           status = false;
/*      */         }
/*      */ 
/*  960 */         if (!hasVoidReturnType(ejbCreate))
/*      */         {
/*  962 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.11.3.d"));
/*      */ 
/*  964 */           status = false;
/*      */         }
/*      */ 
/*  967 */         if (!hasLegalRMIIIOPArguments(ejbCreate))
/*      */         {
/*  969 */           fireSpecViolationEvent(session, ejbCreate, new Section("7.11.3.e"));
/*      */ 
/*  971 */           status = false;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  976 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityHome(EntityMetaData entity)
/*      */   {
/*  984 */     boolean status = true;
/*      */ 
/*  991 */     if (!hasEJBHomeInterface(this.home))
/*      */     {
/*  993 */       fireSpecViolationEvent(entity, new Section("12.2.9.a"));
/*  994 */       status = false;
/*      */     }
/*      */ 
/* 1008 */     Iterator methods = Arrays.asList(this.home.getMethods()).iterator();
/* 1009 */     while (methods.hasNext())
/*      */     {
/* 1011 */       Method method = (Method)methods.next();
/*      */ 
/* 1013 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/* 1015 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.b1"));
/*      */ 
/* 1017 */         status = false;
/*      */       }
/*      */ 
/* 1020 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/* 1022 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.b2"));
/*      */ 
/* 1024 */         status = false;
/*      */       }
/*      */ 
/* 1027 */       if (!throwsRemoteException(method))
/*      */       {
/* 1029 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.b3"));
/*      */ 
/* 1031 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1044 */     methods = Arrays.asList(this.home.getMethods()).iterator();
/* 1045 */     while (methods.hasNext())
/*      */     {
/* 1047 */       Method method = (Method)methods.next();
/*      */ 
/* 1050 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBHome")) {
/*      */         continue;
/*      */       }
/* 1053 */       if (isCreateMethod(method))
/*      */       {
/* 1076 */         if (!hasMatchingEJBCreate(this.bean, method))
/*      */         {
/* 1078 */           fireSpecViolationEvent(entity, method, new Section("12.2.9.d"));
/* 1079 */           status = false;
/*      */         }
/*      */ 
/* 1082 */         if (!hasRemoteReturnType(entity, method))
/*      */         {
/* 1084 */           fireSpecViolationEvent(entity, method, new Section("12.2.9.e"));
/* 1085 */           status = false;
/*      */         }
/*      */ 
/* 1088 */         if ((hasMatchingEJBCreate(this.bean, method)) && (hasMatchingEJBPostCreate(this.bean, method)))
/*      */         {
/* 1091 */           Method ejbCreate = getMatchingEJBCreate(this.bean, method);
/* 1092 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, method);
/*      */ 
/* 1094 */           if ((!hasMatchingExceptions(ejbCreate, method)) || (!hasMatchingExceptions(ejbPostCreate, method)))
/*      */           {
/* 1097 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.f"));
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1102 */         if (!throwsCreateException(method))
/*      */         {
/* 1104 */           fireSpecViolationEvent(entity, method, new Section("12.2.9.g"));
/* 1105 */           status = false;
/*      */         }
/*      */       }
/* 1108 */       else if (isFinderMethod(method))
/*      */       {
/* 1131 */         if (entity.isBMP())
/*      */         {
/* 1133 */           if (!hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1135 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.h"));
/*      */ 
/* 1137 */             status = false;
/*      */           }
/*      */ 
/* 1140 */           if ((!hasRemoteReturnType(entity, method)) && (!isMultiObjectFinder(method)))
/*      */           {
/* 1143 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.j"));
/*      */ 
/* 1145 */             status = false;
/*      */           }
/*      */ 
/* 1148 */           if (hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1150 */             Method ejbFind = getMatchingEJBFind(this.bean, method);
/* 1151 */             if (!hasMatchingExceptions(ejbFind, method))
/*      */             {
/* 1153 */               fireSpecViolationEvent(entity, method, new Section("12.2.9.k"));
/*      */ 
/* 1155 */               status = false;
/*      */             }
/*      */           }
/*      */ 
/* 1159 */           if (!throwsFinderException(method))
/*      */           {
/* 1161 */             fireSpecViolationEvent(entity, method, new Section("12.2.9.l"));
/*      */ 
/* 1163 */             status = false;
/*      */           }
/*      */         }
/*      */ 
/* 1167 */         if (entity.isCMP())
/*      */         {
/* 1170 */           if ((!hasRemoteReturnType(entity, method)) && (!isMultiObjectFinder(method)))
/*      */           {
/* 1173 */             fireSpecViolationEvent(entity, method, new Section("10.6.10.a"));
/*      */ 
/* 1175 */             status = false;
/*      */           }
/*      */ 
/* 1178 */           if (!throwsFinderException(method))
/*      */           {
/* 1180 */             fireSpecViolationEvent(entity, method, new Section("10.6.10.b"));
/*      */ 
/* 1182 */             status = false;
/*      */           }
/*      */ 
/* 1191 */           if ((!method.getName().equals("findByPrimaryKey")) && (!method.getName().equals("findAll")) && (!hasMatchingQuery(method, entity)))
/*      */           {
/* 1195 */             fireSpecViolationEvent(entity, method, new Section("10.5.6"));
/*      */ 
/* 1197 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/* 1212 */       else if (!hasMatchingEJBHome(this.bean, method))
/*      */       {
/* 1214 */         fireSpecViolationEvent(entity, method, new Section("12.2.9.m"));
/*      */ 
/* 1216 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1222 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityLocalHome(EntityMetaData entity)
/*      */   {
/* 1230 */     boolean status = true;
/*      */ 
/* 1237 */     if (!hasEJBLocalHomeInterface(this.localHome))
/*      */     {
/* 1239 */       fireSpecViolationEvent(entity, new Section("12.2.11.a"));
/* 1240 */       status = false;
/*      */     }
/*      */ 
/* 1248 */     Iterator homeMethods = Arrays.asList(this.localHome.getMethods()).iterator();
/* 1249 */     while (homeMethods.hasNext())
/*      */     {
/* 1251 */       Method method = (Method)homeMethods.next();
/*      */ 
/* 1253 */       if (throwsRemoteException(method))
/*      */       {
/* 1255 */         fireSpecViolationEvent(entity, method, new Section("12.2.11.b"));
/* 1256 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1269 */     homeMethods = Arrays.asList(this.localHome.getMethods()).iterator();
/* 1270 */     while (homeMethods.hasNext())
/*      */     {
/* 1272 */       Method method = (Method)homeMethods.next();
/*      */ 
/* 1275 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome")) {
/*      */         continue;
/*      */       }
/* 1278 */       if (isCreateMethod(method))
/*      */       {
/* 1301 */         if (!hasMatchingEJBCreate(this.bean, method))
/*      */         {
/* 1303 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.e"));
/*      */ 
/* 1305 */           status = false;
/*      */         }
/*      */ 
/* 1308 */         if (!hasLocalReturnType(entity, method))
/*      */         {
/* 1310 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.f"));
/*      */ 
/* 1312 */           status = false;
/*      */         }
/*      */ 
/* 1315 */         if ((hasMatchingEJBCreate(this.bean, method)) && (hasMatchingEJBPostCreate(this.bean, method)))
/*      */         {
/* 1318 */           Method ejbCreate = getMatchingEJBCreate(this.bean, method);
/* 1319 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, method);
/*      */ 
/* 1321 */           if ((!hasMatchingExceptions(ejbCreate, method)) || (!hasMatchingExceptions(ejbPostCreate, method)))
/*      */           {
/* 1324 */             fireSpecViolationEvent(entity, method, new Section("12.2.11.g"));
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1329 */         if (!throwsCreateException(method))
/*      */         {
/* 1331 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.h"));
/*      */ 
/* 1333 */           status = false;
/*      */         }
/*      */       }
/* 1336 */       else if (isFinderMethod(method))
/*      */       {
/* 1358 */         if ((!hasLocalReturnType(entity, method)) && (!isMultiObjectFinder(method)))
/*      */         {
/* 1361 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.j"));
/*      */ 
/* 1363 */           status = false;
/*      */         }
/*      */ 
/* 1366 */         if (!throwsFinderException(method))
/*      */         {
/* 1368 */           fireSpecViolationEvent(entity, method, new Section("12.2.11.k"));
/*      */ 
/* 1370 */           status = false;
/*      */         }
/*      */ 
/* 1373 */         if (entity.isCMP())
/*      */         {
/* 1381 */           if (hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1383 */             fireSpecViolationEvent(entity, method, new Section("10.6.2.j"));
/*      */ 
/* 1385 */             status = false;
/*      */           }
/*      */ 
/* 1396 */           if ((!method.getName().equals("findByPrimaryKey")) && (!method.getName().equals("findAll")) && (!hasMatchingQuery(method, entity)))
/*      */           {
/* 1400 */             fireSpecViolationEvent(entity, method, new Section("10.5.6"));
/*      */ 
/* 1402 */             status = false;
/*      */           }
/*      */         }
/*      */ 
/* 1406 */         if (entity.isBMP())
/*      */         {
/* 1408 */           if (!hasMatchingEJBFind(this.bean, method))
/*      */           {
/* 1410 */             fireSpecViolationEvent(entity, method, new Section("12.2.11.i"));
/*      */ 
/* 1412 */             status = false;
/*      */           }
/*      */           else
/*      */           {
/* 1416 */             Method ejbFind = getMatchingEJBFind(this.bean, method);
/*      */ 
/* 1418 */             if (!hasMatchingExceptions(ejbFind, method))
/*      */             {
/* 1420 */               fireSpecViolationEvent(entity, method, new Section("12.2.11.l"));
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/* 1437 */       else if (!hasMatchingEJBHome(this.bean, method))
/*      */       {
/* 1439 */         fireSpecViolationEvent(entity, method, new Section("12.2.11.m"));
/*      */ 
/* 1441 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1446 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityLocal(EntityMetaData entity)
/*      */   {
/* 1454 */     boolean status = true;
/*      */ 
/* 1461 */     if (!hasEJBLocalObjectInterface(this.local))
/*      */     {
/* 1463 */       fireSpecViolationEvent(entity, new Section("12.2.10.a"));
/* 1464 */       status = false;
/*      */     }
/*      */ 
/* 1472 */     Iterator localMethods = Arrays.asList(this.local.getMethods()).iterator();
/* 1473 */     while (localMethods.hasNext())
/*      */     {
/* 1475 */       Method method = (Method)localMethods.next();
/*      */ 
/* 1477 */       if (throwsRemoteException(method))
/*      */       {
/* 1479 */         fireSpecViolationEvent(entity, method, new Section("12.2.10.b"));
/* 1480 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1498 */     localMethods = Arrays.asList(this.local.getMethods()).iterator();
/* 1499 */     while (localMethods.hasNext())
/*      */     {
/* 1501 */       Method method = (Method)localMethods.next();
/*      */ 
/* 1505 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) {
/*      */         continue;
/*      */       }
/* 1508 */       if (!hasMatchingMethod(this.bean, method))
/*      */       {
/* 1510 */         fireSpecViolationEvent(entity, method, new Section("12.2.10.c"));
/* 1511 */         status = false;
/*      */       }
/*      */ 
/* 1514 */       if (hasMatchingMethod(this.bean, method))
/*      */       {
/*      */         try
/*      */         {
/* 1518 */           Method beanMethod = this.bean.getMethod(method.getName(), method.getParameterTypes());
/*      */ 
/* 1521 */           if (!hasMatchingReturnType(beanMethod, method))
/*      */           {
/* 1523 */             fireSpecViolationEvent(entity, method, new Section("12.2.10.d"));
/*      */ 
/* 1525 */             status = false;
/*      */           }
/*      */ 
/* 1528 */           if (!hasMatchingExceptions(beanMethod, method))
/*      */           {
/* 1530 */             fireSpecViolationEvent(entity, method, new Section("12.2.10.e"));
/*      */ 
/* 1533 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1542 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyEntityRemote(EntityMetaData entity)
/*      */   {
/* 1550 */     boolean status = true;
/*      */ 
/* 1557 */     if (!hasEJBObjectInterface(this.remote))
/*      */     {
/* 1559 */       fireSpecViolationEvent(entity, new Section("9.2.7.a"));
/* 1560 */       status = false;
/*      */     }
/*      */ 
/* 1574 */     Iterator it = Arrays.asList(this.remote.getMethods()).iterator();
/* 1575 */     while (it.hasNext())
/*      */     {
/* 1577 */       Method method = (Method)it.next();
/*      */ 
/* 1579 */       if (!hasLegalRMIIIOPArguments(method))
/*      */       {
/* 1581 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.b"));
/* 1582 */         status = false;
/*      */       }
/*      */ 
/* 1585 */       if (!hasLegalRMIIIOPReturnType(method))
/*      */       {
/* 1587 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.c"));
/* 1588 */         status = false;
/*      */       }
/*      */ 
/* 1591 */       if (!hasLegalRMIIIOPExceptionTypes(method))
/*      */       {
/* 1593 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.h"));
/* 1594 */         status = false;
/*      */       }
/*      */ 
/* 1597 */       if (!throwsRemoteException(method))
/*      */       {
/* 1599 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.d"));
/* 1600 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1618 */     it = Arrays.asList(this.remote.getMethods()).iterator();
/* 1619 */     while (it.hasNext())
/*      */     {
/* 1621 */       Method method = (Method)it.next();
/*      */ 
/* 1624 */       if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
/*      */         continue;
/*      */       }
/* 1627 */       if (!hasMatchingMethod(this.bean, method))
/*      */       {
/* 1629 */         fireSpecViolationEvent(entity, method, new Section("9.2.7.e"));
/* 1630 */         status = false;
/*      */       }
/*      */ 
/* 1633 */       if (hasMatchingMethod(this.bean, method))
/*      */       {
/*      */         try
/*      */         {
/* 1637 */           Method beanMethod = this.bean.getMethod(method.getName(), method.getParameterTypes());
/*      */ 
/* 1640 */           if (!hasMatchingReturnType(beanMethod, method))
/*      */           {
/* 1642 */             fireSpecViolationEvent(entity, method, new Section("9.2.7.f"));
/*      */ 
/* 1644 */             status = false;
/*      */           }
/*      */ 
/* 1647 */           if (!hasMatchingExceptions(beanMethod, method))
/*      */           {
/* 1649 */             fireSpecViolationEvent(entity, method, new Section("9.2.7.g"));
/*      */ 
/* 1651 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1660 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyCMPEntityBean(EntityMetaData entity)
/*      */   {
/* 1668 */     boolean status = true;
/*      */ 
/* 1675 */     if (!hasEntityBeanInterface(this.bean))
/*      */     {
/* 1677 */       fireSpecViolationEvent(entity, new Section("10.6.2.a"));
/* 1678 */       status = false;
/*      */     }
/*      */ 
/* 1685 */     if ((!isPublic(this.bean)) || (!isAbstract(this.bean)))
/*      */     {
/* 1687 */       fireSpecViolationEvent(entity, new Section("10.6.2.b"));
/* 1688 */       status = false;
/*      */     }
/*      */ 
/* 1696 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/* 1698 */       fireSpecViolationEvent(entity, new Section("10.6.2.c"));
/* 1699 */       status = false;
/*      */     }
/*      */ 
/* 1706 */     if (hasFinalizer(this.bean))
/*      */     {
/* 1708 */       fireSpecViolationEvent(entity, new Section("10.6.2.d"));
/* 1709 */       status = false;
/*      */     }
/*      */ 
/* 1725 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 1727 */       Iterator it = getEJBCreateMethods(this.bean);
/* 1728 */       while (it.hasNext())
/*      */       {
/* 1730 */         Method ejbCreate = (Method)it.next();
/* 1731 */         if (!isPublic(ejbCreate))
/*      */         {
/* 1733 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.b"));
/*      */ 
/* 1735 */           status = false;
/*      */         }
/*      */ 
/* 1738 */         if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */         {
/* 1740 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.c"));
/*      */ 
/* 1742 */           status = false;
/*      */         }
/*      */ 
/* 1745 */         if (!hasPrimaryKeyReturnType(entity, ejbCreate))
/*      */         {
/* 1747 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.d"));
/*      */ 
/* 1749 */           status = false;
/*      */         }
/*      */ 
/* 1766 */         if (!throwsCreateException(ejbCreate))
/*      */         {
/* 1768 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.4.g"));
/*      */ 
/* 1770 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1788 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 1790 */       Iterator it = getEJBCreateMethods(this.bean);
/*      */ 
/* 1792 */       while (it.hasNext())
/*      */       {
/* 1794 */         Method ejbCreate = (Method)it.next();
/*      */ 
/* 1796 */         if (!hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 1798 */           fireSpecViolationEvent(entity, ejbCreate, new Section("10.6.5.a"));
/*      */ 
/* 1800 */           status = false;
/*      */         }
/*      */ 
/* 1803 */         if (hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 1805 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, ejbCreate);
/*      */ 
/* 1808 */           if (!isPublic(ejbPostCreate))
/*      */           {
/* 1810 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.b"));
/*      */ 
/* 1812 */             status = false;
/*      */           }
/*      */ 
/* 1815 */           if (isStatic(ejbPostCreate))
/*      */           {
/* 1817 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.c"));
/*      */ 
/* 1819 */             status = false;
/*      */           }
/*      */ 
/* 1822 */           if (isFinal(ejbPostCreate))
/*      */           {
/* 1824 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.d"));
/*      */ 
/* 1826 */             status = false;
/*      */           }
/*      */ 
/* 1829 */           if (!hasVoidReturnType(ejbPostCreate))
/*      */           {
/* 1831 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("10.6.5.e"));
/*      */ 
/* 1833 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1848 */     Iterator it = getEjbHomeMethods(this.bean);
/* 1849 */     while (it.hasNext())
/*      */     {
/* 1851 */       Method ejbHome = (Method)it.next();
/* 1852 */       if (!isPublic(ejbHome))
/*      */       {
/* 1854 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.a"));
/* 1855 */         status = false;
/*      */       }
/*      */ 
/* 1858 */       if (isStatic(ejbHome))
/*      */       {
/* 1860 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.b"));
/* 1861 */         status = false;
/*      */       }
/*      */ 
/* 1864 */       if (throwsRemoteException(ejbHome))
/*      */       {
/* 1866 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.c"));
/* 1867 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1876 */     it = entity.getCMPFields();
/* 1877 */     while (it.hasNext())
/*      */     {
/* 1879 */       String fieldName = (String)it.next();
/* 1880 */       String getName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
/*      */ 
/* 1882 */       Class fieldType = null;
/*      */       try
/*      */       {
/* 1886 */         Method m = this.bean.getMethod(getName, new Class[0]);
/* 1887 */         fieldType = m.getReturnType();
/*      */ 
/* 1891 */         if (fieldType == Void.TYPE)
/*      */         {
/* 1893 */           fireSpecViolationEvent(entity, new Section("jb.7.1.b", "Field: " + fieldName));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NoSuchMethodException nsme)
/*      */       {
/* 1899 */         fireSpecViolationEvent(entity, new Section("10.6.2.g", "Field: " + fieldName));
/*      */ 
/* 1901 */         status = false;
/*      */       }
/*      */ 
/* 1904 */       String setName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
/*      */ 
/* 1906 */       Class[] args = new Class[1];
/* 1907 */       args[0] = fieldType;
/*      */       try
/*      */       {
/* 1911 */         Method m = this.bean.getMethod(setName, args);
/* 1912 */         fieldType = m.getReturnType();
/*      */ 
/* 1916 */         if (fieldType != Void.TYPE)
/*      */         {
/* 1918 */           fireSpecViolationEvent(entity, new Section("jb.7.1.a", "Field: " + fieldName));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NoSuchMethodException nsme)
/*      */       {
/*      */         try
/*      */         {
/* 1930 */           args[0] = this.classloader.loadClass("java.util.Collection");
/* 1931 */           m = this.bean.getMethod(setName, args);
/*      */         }
/*      */         catch (NoSuchMethodException nsme2)
/*      */         {
/*      */           Method m;
/* 1935 */           fireSpecViolationEvent(entity, new Section("10.6.2.h", "Field: " + fieldName));
/*      */ 
/* 1937 */           status = false;
/*      */         }
/*      */         catch (ClassNotFoundException cnfe)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1955 */     it = getEjbSelectMethods(this.bean);
/* 1956 */     while (it.hasNext())
/*      */     {
/* 1958 */       Method ejbSelect = (Method)it.next();
/*      */ 
/* 1960 */       if (!isPublic(ejbSelect))
/*      */       {
/* 1962 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.6.7.a"));
/* 1963 */         status = false;
/*      */       }
/*      */ 
/* 1966 */       if (!isAbstract(ejbSelect))
/*      */       {
/* 1968 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.6.7.b"));
/* 1969 */         status = false;
/*      */       }
/*      */ 
/* 1972 */       if (!throwsFinderException(ejbSelect))
/*      */       {
/* 1974 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.6.7.c"));
/* 1975 */         status = false;
/*      */       }
/*      */ 
/* 1978 */       if (!hasMatchingQuery(ejbSelect, entity))
/*      */       {
/* 1980 */         fireSpecViolationEvent(entity, ejbSelect, new Section("10.5.7"));
/* 1981 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1989 */     if (hasFinderMethod(this.bean))
/*      */     {
/* 1991 */       fireSpecViolationEvent(entity, new Section("10.6.2.i"));
/* 1992 */       status = false;
/*      */     }
/*      */ 
/* 1995 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyBMPEntityBean(EntityMetaData entity)
/*      */   {
/* 2003 */     boolean status = true;
/*      */ 
/* 2010 */     if (!hasEntityBeanInterface(this.bean))
/*      */     {
/* 2012 */       fireSpecViolationEvent(entity, new Section("12.2.2.a"));
/* 2013 */       status = false;
/*      */     }
/*      */ 
/* 2020 */     if ((!isPublic(this.bean)) || (isAbstract(this.bean)))
/*      */     {
/* 2022 */       fireSpecViolationEvent(entity, new Section("12.2.2.b"));
/* 2023 */       status = false;
/*      */     }
/*      */ 
/* 2030 */     if (isFinal(this.bean))
/*      */     {
/* 2032 */       fireSpecViolationEvent(entity, new Section("12.2.2.c"));
/* 2033 */       status = false;
/*      */     }
/*      */ 
/* 2041 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/* 2043 */       fireSpecViolationEvent(entity, new Section("12.2.2.d"));
/* 2044 */       status = false;
/*      */     }
/*      */ 
/* 2051 */     if (hasFinalizer(this.bean))
/*      */     {
/* 2053 */       fireSpecViolationEvent(entity, new Section("12.2.2.e"));
/* 2054 */       status = false;
/*      */     }
/*      */ 
/* 2069 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 2071 */       Iterator it = getEJBCreateMethods(this.bean);
/* 2072 */       while (it.hasNext())
/*      */       {
/* 2074 */         Method ejbCreate = (Method)it.next();
/* 2075 */         if (!isPublic(ejbCreate))
/*      */         {
/* 2077 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.3.a"));
/*      */ 
/* 2079 */           status = false;
/*      */         }
/*      */ 
/* 2082 */         if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */         {
/* 2084 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.3.b"));
/*      */ 
/* 2086 */           status = false;
/*      */         }
/*      */ 
/* 2089 */         if (!hasPrimaryKeyReturnType(entity, ejbCreate))
/*      */         {
/* 2091 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.3.c"));
/*      */ 
/* 2093 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2124 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 2126 */       Iterator it = getEJBCreateMethods(this.bean);
/* 2127 */       while (it.hasNext())
/*      */       {
/* 2129 */         Method ejbCreate = (Method)it.next();
/*      */ 
/* 2131 */         if (!hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 2133 */           fireSpecViolationEvent(entity, ejbCreate, new Section("12.2.4.a"));
/*      */ 
/* 2135 */           status = false;
/*      */         }
/*      */ 
/* 2138 */         if (hasMatchingEJBPostCreate(this.bean, ejbCreate))
/*      */         {
/* 2140 */           Method ejbPostCreate = getMatchingEJBPostCreate(this.bean, ejbCreate);
/*      */ 
/* 2143 */           if (!isPublic(ejbPostCreate))
/*      */           {
/* 2145 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("12.2.4.b"));
/*      */ 
/* 2147 */             status = false;
/*      */           }
/*      */ 
/* 2150 */           if ((isStatic(ejbPostCreate)) || (isFinal(ejbPostCreate)))
/*      */           {
/* 2152 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("12.2.4.c"));
/*      */ 
/* 2154 */             status = false;
/*      */           }
/*      */ 
/* 2157 */           if (!hasVoidReturnType(ejbPostCreate))
/*      */           {
/* 2159 */             fireSpecViolationEvent(entity, ejbPostCreate, new Section("12.2.4.d"));
/*      */ 
/* 2161 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2176 */     if (!hasEJBFindByPrimaryKey(this.bean))
/*      */     {
/* 2178 */       fireSpecViolationEvent(entity, new Section("12.2.5.e"));
/* 2179 */       status = false;
/*      */     }
/*      */ 
/* 2182 */     if (hasEJBFindByPrimaryKey(this.bean))
/*      */     {
/* 2184 */       Method ejbFindByPrimaryKey = getEJBFindByPrimaryKey(this.bean);
/*      */ 
/* 2186 */       if (!hasPrimaryKeyReturnType(entity, ejbFindByPrimaryKey))
/*      */       {
/* 2188 */         fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("12.2.5.e1"));
/*      */ 
/* 2190 */         status = false;
/*      */       }
/*      */ 
/* 2193 */       if (!isSingleObjectFinder(entity, ejbFindByPrimaryKey))
/*      */       {
/* 2195 */         fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("12.2.5.e2"));
/*      */ 
/* 2197 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2216 */     if (hasFinderMethod(this.bean))
/*      */     {
/* 2218 */       Iterator it = getEJBFindMethods(this.bean);
/* 2219 */       while (it.hasNext())
/*      */       {
/* 2221 */         Method finder = (Method)it.next();
/*      */ 
/* 2223 */         if (!isPublic(finder))
/*      */         {
/* 2225 */           fireSpecViolationEvent(entity, finder, new Section("12.2.5.a"));
/* 2226 */           status = false;
/*      */         }
/*      */ 
/* 2229 */         if ((isFinal(finder)) || (isStatic(finder)))
/*      */         {
/* 2231 */           fireSpecViolationEvent(entity, finder, new Section("12.2.5.b"));
/* 2232 */           status = false;
/*      */         }
/*      */ 
/* 2244 */         if ((!isSingleObjectFinder(entity, finder)) && (!isMultiObjectFinder(finder)))
/*      */         {
/* 2247 */           fireSpecViolationEvent(entity, finder, new Section("12.2.5.d"));
/* 2248 */           status = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2262 */     Iterator it = getEjbHomeMethods(this.bean);
/* 2263 */     while (it.hasNext())
/*      */     {
/* 2265 */       Method ejbHome = (Method)it.next();
/*      */ 
/* 2267 */       if (!isPublic(ejbHome))
/*      */       {
/* 2269 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.a"));
/* 2270 */         status = false;
/*      */       }
/*      */ 
/* 2273 */       if (isStatic(ejbHome))
/*      */       {
/* 2275 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.b"));
/* 2276 */         status = false;
/*      */       }
/*      */ 
/* 2279 */       if (throwsRemoteException(ejbHome))
/*      */       {
/* 2281 */         fireSpecViolationEvent(entity, ejbHome, new Section("10.6.6.c"));
/* 2282 */         status = false;
/*      */       }
/*      */     }
/*      */ 
/* 2286 */     return status;
/*      */   }
/*      */ 
/*      */   private boolean verifyPrimaryKey(EntityMetaData entity)
/*      */   {
/* 2294 */     boolean status = true;
/* 2295 */     boolean cmp = entity.isCMP();
/*      */ 
/* 2297 */     if ((entity.getPrimaryKeyClass() == null) || (entity.getPrimaryKeyClass().length() == 0))
/*      */     {
/* 2300 */       if (cmp)
/* 2301 */         fireSpecViolationEvent(entity, new Section("10.6.1.a"));
/*      */       else {
/* 2303 */         fireSpecViolationEvent(entity, new Section("12.2.1.a"));
/*      */       }
/*      */ 
/* 2306 */       return false;
/*      */     }
/*      */ 
/* 2314 */     Class cls = null;
/*      */     try
/*      */     {
/* 2317 */       cls = this.classloader.loadClass(entity.getPrimaryKeyClass());
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/* 2321 */       if (cmp)
/* 2322 */         fireSpecViolationEvent(entity, new Section("10.6.13.a"));
/*      */       else {
/* 2324 */         fireSpecViolationEvent(entity, new Section("12.2.12.a"));
/*      */       }
/*      */ 
/* 2327 */       return false;
/*      */     }
/*      */ 
/* 2334 */     if (!isRMIIDLValueType(cls))
/*      */     {
/* 2336 */       if (cmp)
/* 2337 */         fireSpecViolationEvent(entity, new Section("10.6.13.b"));
/*      */       else
/* 2339 */         fireSpecViolationEvent(entity, new Section("12.2.12.b"));
/* 2340 */       status = false;
/*      */     }
/*      */ 
/* 2344 */     if ((entity.getPrimKeyField() == null) || (entity.getPrimKeyField().length() == 0))
/*      */     {
/* 2351 */       if (!cls.getName().equals("java.lang.Object"))
/*      */       {
/*      */         try
/*      */         {
/* 2357 */           Object one = cls.newInstance();
/* 2358 */           Object two = cls.newInstance();
/*      */           try
/*      */           {
/* 2361 */             if (!one.equals(two))
/*      */             {
/* 2363 */               if (cmp)
/*      */               {
/* 2366 */                 log.warn("Default instances of primary key: " + cls + " do not equate, check your equals method");
/*      */               }
/*      */               else
/*      */               {
/* 2372 */                 log.warn("Default instances of primary key: " + cls + " do not equate, check your equals method");
/*      */               }
/*      */ 
/* 2375 */               status = true;
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (NullPointerException e)
/*      */           {
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/* 2386 */             if (one.hashCode() != two.hashCode())
/*      */             {
/* 2388 */               if (cmp)
/*      */               {
/* 2391 */                 log.warn("Default instances of primary key: " + cls + " do not have the same hash, check your hashCode method");
/*      */               }
/*      */               else
/*      */               {
/* 2397 */                 log.warn("Default instances of primary key: " + cls + " do not have the same hash, check your hashCode method");
/*      */               }
/*      */ 
/* 2400 */               status = true;
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (NullPointerException e)
/*      */           {
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (IllegalAccessException e)
/*      */         {
/* 2413 */           if (cmp)
/*      */           {
/* 2415 */             fireSpecViolationEvent(entity, new Section("10.8.2.a"));
/* 2416 */             status = false;
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (InstantiationException e)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 2432 */       if (entity.isBMP())
/*      */       {
/* 2434 */         fireSpecViolationEvent(entity, new Section("dd.a"));
/* 2435 */         status = false;
/*      */       }
/*      */ 
/* 2443 */       boolean found = false;
/* 2444 */       Iterator it = entity.getCMPFields();
/* 2445 */       while (it.hasNext())
/*      */       {
/* 2447 */         String fieldName = (String)it.next();
/* 2448 */         if (fieldName.equals(entity.getPrimKeyField()))
/*      */         {
/* 2450 */           found = true;
/* 2451 */           break;
/*      */         }
/*      */       }
/*      */ 
/* 2455 */       if (!found)
/*      */       {
/* 2457 */         status = false;
/* 2458 */         fireSpecViolationEvent(entity, new Section("10.8.1.b"));
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 2470 */         String pkField = entity.getPrimKeyField();
/* 2471 */         String methodName = "get" + pkField.substring(0, 1).toUpperCase() + pkField.substring(1);
/*      */ 
/* 2474 */         Method method = this.bean.getMethod(methodName, new Class[0]);
/* 2475 */         if (!entity.getPrimaryKeyClass().equals(method.getReturnType().getName()))
/*      */         {
/* 2478 */           status = false;
/* 2479 */           fireSpecViolationEvent(entity, new Section("10.8.1.a"));
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/* 2490 */         status = false;
/* 2491 */         fireSpecViolationEvent(entity, new Section("10.8.1.b"));
/*      */       }
/*      */     }
/*      */ 
/* 2495 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifyMessageDrivenBean(MessageDrivenMetaData mdBean)
/*      */   {
/* 2503 */     boolean status = true;
/*      */ 
/* 2510 */     if (!hasMessageDrivenBeanInterface(this.bean))
/*      */     {
/* 2512 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.a"));
/* 2513 */       status = false;
/*      */     }
/*      */ 
/* 2521 */     if (!isAssignableFrom(mdBean.getMessagingType(), this.bean))
/*      */     {
/* 2523 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.b"));
/* 2524 */       status = false;
/*      */     }
/*      */ 
/* 2531 */     if (!isPublic(this.bean))
/*      */     {
/* 2533 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.c1"));
/* 2534 */       status = false;
/*      */     }
/*      */ 
/* 2541 */     if (isFinal(this.bean))
/*      */     {
/* 2543 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.c2"));
/* 2544 */       status = false;
/*      */     }
/*      */ 
/* 2551 */     if (isAbstract(this.bean))
/*      */     {
/* 2553 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.c3"));
/* 2554 */       status = false;
/*      */     }
/*      */ 
/* 2562 */     if (!hasDefaultConstructor(this.bean))
/*      */     {
/* 2564 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.d"));
/* 2565 */       status = false;
/*      */     }
/*      */ 
/* 2572 */     if (hasFinalizer(this.bean))
/*      */     {
/* 2574 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.e"));
/* 2575 */       status = false;
/*      */     }
/*      */ 
/* 2590 */     if (hasEJBCreateMethod(this.bean, false))
/*      */     {
/* 2592 */       Iterator it = getEJBCreateMethods(this.bean);
/* 2593 */       Method ejbCreate = (Method)it.next();
/*      */ 
/* 2595 */       if (!isPublic(ejbCreate))
/*      */       {
/* 2597 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.b"));
/* 2598 */         status = false;
/*      */       }
/*      */ 
/* 2601 */       if ((isFinal(ejbCreate)) || (isStatic(ejbCreate)))
/*      */       {
/* 2603 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.c"));
/* 2604 */         status = false;
/*      */       }
/*      */ 
/* 2607 */       if (!hasVoidReturnType(ejbCreate))
/*      */       {
/* 2609 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.d"));
/* 2610 */         status = false;
/*      */       }
/*      */ 
/* 2613 */       if (!hasNoArguments(ejbCreate))
/*      */       {
/* 2615 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.e"));
/* 2616 */         status = false;
/*      */       }
/*      */ 
/* 2619 */       if (!throwsNoException(ejbCreate))
/*      */       {
/* 2621 */         fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.f"));
/* 2622 */         status = false;
/*      */       }
/*      */ 
/* 2625 */       if (it.hasNext())
/*      */       {
/* 2627 */         fireSpecViolationEvent(mdBean, new Section("15.7.3.a"));
/* 2628 */         status = false;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 2633 */       fireSpecViolationEvent(mdBean, new Section("15.7.3.a"));
/* 2634 */       status = false;
/*      */     }
/*      */ 
/* 2646 */     Class messageListener = null;
/*      */     try
/*      */     {
/* 2649 */       messageListener = this.classloader.loadClass(mdBean.getMessagingType());
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/* 2653 */       fireSpecViolationEvent(mdBean, new Section("15.7.2.b", "Class not found on '" + mdBean.getMessagingType() + "': " + cnfe.getMessage()));
/*      */ 
/* 2656 */       status = false;
/*      */     }
/*      */ 
/* 2660 */     if (messageListener != null)
/*      */     {
/* 2662 */       Method[] methods = this.bean.getMethods();
/* 2663 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/* 2665 */         if (!methods[i].getDeclaringClass().equals(messageListener))
/*      */           continue;
/* 2667 */         if (!isPublic(methods[i]))
/*      */         {
/* 2669 */           fireSpecViolationEvent(mdBean, methods[i], new Section("15.7.4.b"));
/* 2670 */           status = false;
/*      */         }
/*      */ 
/* 2673 */         if ((!isFinal(methods[i])) && (!isStatic(methods[i])))
/*      */           continue;
/* 2675 */         fireSpecViolationEvent(mdBean, methods[i], new Section("15.7.4.c"));
/* 2676 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2694 */     if (hasEJBRemoveMethod(this.bean))
/*      */     {
/* 2696 */       Iterator it = getEJBRemoveMethods(this.bean);
/* 2697 */       Method ejbRemove = (Method)it.next();
/*      */ 
/* 2699 */       if (!isPublic(ejbRemove))
/*      */       {
/* 2701 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.b"));
/* 2702 */         status = false;
/*      */       }
/*      */ 
/* 2705 */       if ((isFinal(ejbRemove)) || (isStatic(ejbRemove)))
/*      */       {
/* 2707 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.c"));
/* 2708 */         status = false;
/*      */       }
/*      */ 
/* 2711 */       if (!hasVoidReturnType(ejbRemove))
/*      */       {
/* 2713 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.d"));
/* 2714 */         status = false;
/*      */       }
/*      */ 
/* 2717 */       if (!hasNoArguments(ejbRemove))
/*      */       {
/* 2719 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.e"));
/* 2720 */         status = false;
/*      */       }
/*      */ 
/* 2723 */       if (!throwsNoException(ejbRemove))
/*      */       {
/* 2725 */         fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.f"));
/* 2726 */         status = false;
/*      */       }
/*      */ 
/* 2729 */       if (it.hasNext())
/*      */       {
/* 2731 */         fireSpecViolationEvent(mdBean, new Section("15.7.5.a"));
/* 2732 */         status = false;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 2737 */       fireSpecViolationEvent(mdBean, new Section("15.7.5.a"));
/* 2738 */       status = false;
/*      */     }
/*      */ 
/* 2741 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean verifyServiceEndpoint(SessionMetaData session)
/*      */   {
/* 2751 */     boolean status = true;
/*      */ 
/* 2758 */     if (!hasRemoteInterface(this.serviceEndpointInterface))
/*      */     {
/* 2760 */       fireSpecViolationEvent(session, new Section("7.11.9.a"));
/* 2761 */       status = false;
/*      */     }
/*      */ 
/* 2775 */     Iterator it = Arrays.asList(this.serviceEndpointInterface.getMethods()).iterator();
/* 2776 */     while (it.hasNext())
/*      */     {
/* 2778 */       Method method = (Method)it.next();
/*      */ 
/* 2780 */       if (!hasLegalJAXRPCArguments(method))
/*      */       {
/* 2782 */         fireSpecViolationEvent(session, method, new Section("7.11.9.b1"));
/* 2783 */         status = false;
/*      */       }
/*      */ 
/* 2786 */       if (!hasLegalJAXRPCReturnType(method))
/*      */       {
/* 2788 */         fireSpecViolationEvent(session, method, new Section("7.11.9.b2"));
/* 2789 */         status = false;
/*      */       }
/*      */ 
/* 2792 */       if (!throwsRemoteException(method))
/*      */       {
/* 2794 */         fireSpecViolationEvent(session, method, new Section("7.11.9.b3"));
/* 2795 */         status = false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2812 */     it = Arrays.asList(this.serviceEndpointInterface.getDeclaredMethods()).iterator();
/* 2813 */     while (it.hasNext())
/*      */     {
/* 2815 */       Method seiMethod = (Method)it.next();
/*      */ 
/* 2817 */       if (!hasMatchingMethod(this.bean, seiMethod))
/*      */       {
/* 2819 */         fireSpecViolationEvent(session, seiMethod, new Section("7.11.9.c"));
/* 2820 */         status = false;
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/* 2826 */           Method beanMethod = this.bean.getMethod(seiMethod.getName(), seiMethod.getParameterTypes());
/* 2827 */           if (!hasMatchingReturnType(seiMethod, beanMethod))
/*      */           {
/* 2829 */             fireSpecViolationEvent(session, seiMethod, new Section("7.11.9.c1"));
/* 2830 */             status = false;
/*      */           }
/*      */ 
/* 2833 */           if (!hasMatchingExceptions(beanMethod, seiMethod))
/*      */           {
/* 2835 */             fireSpecViolationEvent(session, seiMethod, new Section("7.11.59.c2"));
/* 2836 */             status = false;
/*      */           }
/*      */         }
/*      */         catch (NoSuchMethodException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 2845 */     return status;
/*      */   }
/*      */ 
/*      */   protected boolean hasLegalJAXRPCReturnType(Method method)
/*      */   {
/* 2854 */     return isJAXRPCType(method.getReturnType());
/*      */   }
/*      */ 
/*      */   protected boolean isJAXRPCType(Class class1)
/*      */   {
/* 2864 */     return isRMIIDLValueType(class1);
/*      */   }
/*      */ 
/*      */   protected boolean hasLegalJAXRPCArguments(Method method)
/*      */   {
/* 2873 */     Class[] params = method.getParameterTypes();
/*      */ 
/* 2875 */     for (int i = 0; i < params.length; i++)
/*      */     {
/* 2877 */       if (!isJAXRPCType(params[i])) {
/* 2878 */         return false;
/*      */       }
/*      */     }
/* 2881 */     return true;
/*      */   }
/*      */ 
/*      */   protected boolean hasServiceEndpointInterfaces(SessionMetaData bean)
/*      */   {
/* 2892 */     boolean status = true;
/* 2893 */     String seiName = bean.getServiceEndpoint();
/*      */ 
/* 2895 */     if (seiName == null) {
/* 2896 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 2901 */       this.serviceEndpointInterface = this.classloader.loadClass(seiName);
/*      */     }
/*      */     catch (ClassNotFoundException cnfe)
/*      */     {
/* 2905 */       fireSpecViolationEvent(bean, new Section("23.2", "Class not found on '" + seiName + "': " + cnfe.getMessage()));
/*      */ 
/* 2907 */       status = false;
/*      */     }
/*      */ 
/* 2910 */     return status;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.strategy.EJBVerifier21
 * JD-Core Version:    0.6.0
 */