/*     */ package org.jboss.verifier.factory;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Map;
/*     */ import java.util.MissingResourceException;
/*     */ import java.util.Properties;
/*     */ import org.jboss.verifier.Section;
/*     */ import org.jboss.verifier.event.VerificationEvent;
/*     */ import org.jboss.verifier.event.VerificationEventGenerator;
/*     */ 
/*     */ public class DefaultEventFactory
/*     */   implements VerificationEventFactory
/*     */ {
/*     */   public static final String DEFAULT_MESSAGE_BUNDLE = "/org/jboss/verifier/DefaultMessages.properties";
/*  76 */   private Map msgTable = null;
/*     */   private String msgBundle;
/*     */ 
/*     */   /** @deprecated */
/*     */   public DefaultEventFactory()
/*     */   {
/*  88 */     this.msgBundle = "/org/jboss/verifier/DefaultMessages.properties";
/*  89 */     this.msgTable = loadErrorMessages();
/*     */   }
/*     */ 
/*     */   public DefaultEventFactory(String msgBundle)
/*     */   {
/*  98 */     this.msgBundle = ("/org/jboss/verifier/" + msgBundle);
/*  99 */     this.msgTable = loadErrorMessages();
/*     */   }
/*     */ 
/*     */   public VerificationEvent createSpecViolationEvent(VerificationEventGenerator source, Section section)
/*     */   {
/* 105 */     VerificationEvent event = new VerificationEvent(source);
/*     */ 
/* 107 */     event.setState("WARNING");
/* 108 */     event.setSection(section);
/* 109 */     event.setMessage((String)this.msgTable.get(section.getSection()));
/*     */ 
/* 111 */     return event;
/*     */   }
/*     */ 
/*     */   public VerificationEvent createBeanVerifiedEvent(VerificationEventGenerator source)
/*     */   {
/* 117 */     VerificationEvent event = new VerificationEvent(source);
/*     */ 
/* 119 */     event.setState("OK");
/* 120 */     event.setMessage("Verified.");
/*     */ 
/* 122 */     return event;
/*     */   }
/*     */ 
/*     */   public String getMessageBundle() {
/* 126 */     return this.msgBundle;
/*     */   }
/*     */ 
/*     */   private Map loadErrorMessages()
/*     */   {
/*     */     try
/*     */     {
/* 144 */       InputStream in = getClass().getResourceAsStream(this.msgBundle);
/* 145 */       Properties props = new Properties();
/* 146 */       props.load(in);
/*     */ 
/* 148 */       return props;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 152 */       throw new MissingResourceException("I/O failure: " + e.getMessage(), this.msgBundle, "");
/*     */     }
/*     */     catch (NullPointerException e)
/*     */     {
/*     */     }
/* 157 */     throw new MissingResourceException("Resource not found.", this.msgBundle, "");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.factory.DefaultEventFactory
 * JD-Core Version:    0.6.0
 */