/*     */ package org.jboss.verifier;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import org.jboss.metadata.XmlFileLoader;
/*     */ 
/*     */ public class Main
/*     */ {
/*     */   public static final int OK = 0;
/*     */   public static final int WARNING = 1;
/*  74 */   static int returnCode = 0;
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/*  85 */       if (args.length < 1)
/*     */       {
/*  87 */         throw new IllegalArgumentException("Usage: beanverifier mybeans.jar");
/*     */       }
/*     */ 
/*  91 */       URL url = new File(args[0]).toURL();
/*  92 */       URLClassLoader cl = new URLClassLoader(new URL[] { url }, Thread.currentThread().getContextClassLoader());
/*     */ 
/*  94 */       XmlFileLoader xfl = new XmlFileLoader();
/*  95 */       BeanVerifier verifier = new BeanVerifier();
/*     */ 
/*  97 */       xfl.setClassLoader(cl);
/*  98 */       verifier.addVerificationListener(new Listener());
/*     */ 
/* 100 */       verifier.verify(url, xfl.load(null));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 104 */       System.err.println("Problem starting the application:");
/* 105 */       System.err.println("Exception: " + e);
/* 106 */       System.err.println("Message:   " + e.getMessage());
/* 107 */       e.printStackTrace();
/*     */ 
/* 109 */       System.exit(-1);
/*     */     }
/*     */ 
/* 112 */     System.exit(returnCode);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.verifier.Main
 * JD-Core Version:    0.6.0
 */