/*     */ package org.jboss.util.xml.catalog.readers;
/*     */ 
/*     */ import java.util.Vector;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.jboss.util.xml.catalog.Catalog;
/*     */ import org.jboss.util.xml.catalog.CatalogEntry;
/*     */ import org.jboss.util.xml.catalog.CatalogException;
/*     */ import org.jboss.util.xml.catalog.CatalogManager;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ import org.jboss.util.xml.catalog.helpers.PublicId;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class XCatalogReader extends SAXCatalogReader
/*     */   implements SAXCatalogParser
/*     */ {
/*  84 */   protected Catalog catalog = null;
/*     */ 
/*     */   public void setCatalog(Catalog catalog)
/*     */   {
/*  88 */     this.catalog = catalog;
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/*  93 */     return this.catalog;
/*     */   }
/*     */ 
/*     */   public XCatalogReader(SAXParserFactory parserFactory)
/*     */   {
/*  98 */     super(parserFactory);
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 139 */     int entryType = -1;
/* 140 */     Vector entryArgs = new Vector();
/*     */ 
/* 142 */     if (localName.equals("Base")) {
/* 143 */       entryType = Catalog.BASE;
/* 144 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 146 */       this.catalog.getCatalogManager().debug.message(4, "Base", atts.getValue("HRef"));
/* 147 */     } else if (localName.equals("Delegate")) {
/* 148 */       entryType = Catalog.DELEGATE_PUBLIC;
/* 149 */       entryArgs.add(atts.getValue("PublicId"));
/* 150 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 152 */       this.catalog.getCatalogManager().debug.message(4, "Delegate", PublicId.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
/*     */     }
/* 155 */     else if (localName.equals("Extend")) {
/* 156 */       entryType = Catalog.CATALOG;
/* 157 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 159 */       this.catalog.getCatalogManager().debug.message(4, "Extend", atts.getValue("HRef"));
/* 160 */     } else if (localName.equals("Map")) {
/* 161 */       entryType = Catalog.PUBLIC;
/* 162 */       entryArgs.add(atts.getValue("PublicId"));
/* 163 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 165 */       this.catalog.getCatalogManager().debug.message(4, "Map", PublicId.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
/*     */     }
/* 168 */     else if (localName.equals("Remap")) {
/* 169 */       entryType = Catalog.SYSTEM;
/* 170 */       entryArgs.add(atts.getValue("SystemId"));
/* 171 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 173 */       this.catalog.getCatalogManager().debug.message(4, "Remap", atts.getValue("SystemId"), atts.getValue("HRef"));
/*     */     }
/* 176 */     else if (!localName.equals("XMLCatalog"))
/*     */     {
/* 180 */       this.catalog.getCatalogManager().debug.message(1, "Invalid catalog entry type", localName);
/*     */     }
/*     */ 
/* 183 */     if (entryType >= 0)
/*     */       try {
/* 185 */         CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 186 */         this.catalog.addEntry(ce);
/*     */       } catch (CatalogException cex) {
/* 188 */         if (cex.getExceptionType() == 3)
/* 189 */           this.catalog.getCatalogManager().debug.message(1, "Invalid catalog entry type", localName);
/* 190 */         else if (cex.getExceptionType() == 2)
/* 191 */           this.catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", localName);
/*     */       }
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.XCatalogReader
 * JD-Core Version:    0.6.0
 */