/*     */ package org.jboss.util.xml.catalog.readers;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.Stack;
/*     */ import java.util.Vector;
/*     */ import org.jboss.util.xml.catalog.Catalog;
/*     */ import org.jboss.util.xml.catalog.CatalogEntry;
/*     */ import org.jboss.util.xml.catalog.CatalogException;
/*     */ import org.jboss.util.xml.catalog.CatalogManager;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ 
/*     */ public class TextCatalogReader
/*     */   implements CatalogReader
/*     */ {
/*  86 */   protected InputStream catfile = null;
/*     */ 
/*  92 */   protected int[] stack = new int[3];
/*     */ 
/*  98 */   protected Stack tokenStack = new Stack();
/*     */ 
/* 101 */   protected int top = -1;
/*     */ 
/* 104 */   protected boolean caseSensitive = false;
/*     */ 
/*     */   public void setCaseSensitive(boolean isCaseSensitive)
/*     */   {
/* 112 */     this.caseSensitive = isCaseSensitive;
/*     */   }
/*     */ 
/*     */   public boolean getCaseSensitive() {
/* 116 */     return this.caseSensitive;
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, String fileUrl)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 131 */     URL catURL = null;
/*     */     try
/*     */     {
/* 134 */       catURL = new URL(fileUrl);
/*     */     } catch (MalformedURLException e) {
/* 136 */       catURL = new URL("file:///" + fileUrl);
/*     */     }
/*     */ 
/* 139 */     URLConnection urlCon = catURL.openConnection();
/*     */     try {
/* 141 */       readCatalog(catalog, urlCon.getInputStream());
/*     */     } catch (FileNotFoundException e) {
/* 143 */       catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", catURL.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, InputStream is)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 151 */     this.catfile = is;
/*     */ 
/* 153 */     if (this.catfile == null) {
/* 154 */       return;
/*     */     }
/*     */ 
/* 157 */     Vector unknownEntry = null;
/*     */     while (true)
/*     */     {
/* 160 */       String token = nextToken();
/*     */ 
/* 162 */       if (token == null) {
/* 163 */         if (unknownEntry != null) {
/* 164 */           catalog.unknownEntry(unknownEntry);
/* 165 */           unknownEntry = null;
/*     */         }
/* 167 */         this.catfile.close();
/* 168 */         this.catfile = null;
/* 169 */         return;
/*     */       }
/*     */ 
/* 172 */       String entryToken = null;
/* 173 */       if (this.caseSensitive)
/* 174 */         entryToken = token;
/*     */       else {
/* 176 */         entryToken = token.toUpperCase();
/*     */       }
/*     */       try
/*     */       {
/* 180 */         int type = CatalogEntry.getEntryType(entryToken);
/* 181 */         int numArgs = CatalogEntry.getEntryArgCount(type);
/* 182 */         Vector args = new Vector();
/*     */ 
/* 184 */         if (unknownEntry != null) {
/* 185 */           catalog.unknownEntry(unknownEntry);
/* 186 */           unknownEntry = null;
/*     */         }
/*     */ 
/* 189 */         for (int count = 0; count < numArgs; count++) {
/* 190 */           args.addElement(nextToken());
/*     */         }
/*     */ 
/* 193 */         catalog.addEntry(new CatalogEntry(entryToken, args));
/*     */       } catch (CatalogException cex) {
/* 195 */         if (cex.getExceptionType() == 3) {
/* 196 */           if (unknownEntry == null) {
/* 197 */             unknownEntry = new Vector();
/*     */           }
/* 199 */           unknownEntry.addElement(token);
/* 200 */         } else if (cex.getExceptionType() == 2) {
/* 201 */           catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", token);
/* 202 */           unknownEntry = null;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */   {
/* 214 */     if (this.catfile != null)
/*     */       try {
/* 216 */         this.catfile.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/* 221 */     this.catfile = null;
/*     */   }
/*     */ 
/*     */   protected String nextToken()
/*     */     throws IOException
/*     */   {
/* 233 */     String token = "";
/*     */ 
/* 236 */     if (!this.tokenStack.empty()) {
/* 237 */       return (String)this.tokenStack.pop();
/*     */     }
/*     */     int nextch;
/*     */     while (true)
/*     */     {
/* 243 */       ch = this.catfile.read();
/* 244 */       while (ch <= 32) {
/* 245 */         ch = this.catfile.read();
/* 246 */         if (ch < 0) {
/* 247 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 252 */       nextch = this.catfile.read();
/* 253 */       if (nextch < 0) {
/* 254 */         return null;
/*     */       }
/*     */ 
/* 257 */       if ((ch != 45) || (nextch != 45))
/*     */         break;
/* 259 */       ch = 32;
/* 260 */       nextch = nextChar();
/* 261 */       while ((ch != 45) || (nextch != 45)) {
/* 262 */         ch = nextch;
/* 263 */         nextch = nextChar();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 269 */     this.stack[(++this.top)] = nextch;
/* 270 */     this.stack[(++this.top)] = ch;
/*     */ 
/* 275 */     int ch = nextChar();
/* 276 */     if ((ch == 34) || (ch == 39)) {
/* 277 */       int quote = ch;
/* 278 */       while ((ch = nextChar()) != quote) {
/* 279 */         char[] chararr = new char[1];
/* 280 */         chararr[0] = (char)ch;
/* 281 */         String s = new String(chararr);
/* 282 */         token = token.concat(s);
/*     */       }
/* 284 */       return token;
/*     */     }
/*     */ 
/* 288 */     while (ch > 32) {
/* 289 */       nextch = nextChar();
/* 290 */       if ((ch == 45) && (nextch == 45)) {
/* 291 */         this.stack[(++this.top)] = ch;
/* 292 */         this.stack[(++this.top)] = nextch;
/* 293 */         return token;
/*     */       }
/* 295 */       char[] chararr = new char[1];
/* 296 */       chararr[0] = (char)ch;
/* 297 */       String s = new String(chararr);
/* 298 */       token = token.concat(s);
/* 299 */       ch = nextch;
/*     */     }
/*     */ 
/* 302 */     return token;
/*     */   }
/*     */ 
/*     */   protected int nextChar()
/*     */     throws IOException
/*     */   {
/* 315 */     if (this.top < 0) {
/* 316 */       return this.catfile.read();
/*     */     }
/* 318 */     return this.stack[(this.top--)];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.TextCatalogReader
 * JD-Core Version:    0.6.0
 */