package org.jboss.util.xml.catalog.readers;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Vector;
import org.jboss.util.xml.catalog.Catalog;
import org.jboss.util.xml.catalog.CatalogEntry;
import org.jboss.util.xml.catalog.CatalogException;
import org.jboss.util.xml.catalog.CatalogManager;
import org.jboss.util.xml.catalog.helpers.Debug;

public class TR9401CatalogReader extends TextCatalogReader
{
  public void readCatalog(Catalog catalog, InputStream is)
    throws MalformedURLException, IOException
  {
    this.catfile = is;

    if (this.catfile == null) {
      return;
    }

    Vector unknownEntry = null;
    while (true)
    {
      String token = nextToken();

      if (token == null) {
        if (unknownEntry != null) {
          catalog.unknownEntry(unknownEntry);
          unknownEntry = null;
        }
        this.catfile.close();
        this.catfile = null;
        return;
      }

      String entryToken = null;
      if (this.caseSensitive)
        entryToken = token;
      else {
        entryToken = token.toUpperCase();
      }

      if (entryToken.equals("DELEGATE")) {
        entryToken = "DELEGATE_PUBLIC";
      }
      try
      {
        int type = CatalogEntry.getEntryType(entryToken);
        int numArgs = CatalogEntry.getEntryArgCount(type);
        Vector args = new Vector();

        if (unknownEntry != null) {
          catalog.unknownEntry(unknownEntry);
          unknownEntry = null;
        }

        for (int count = 0; count < numArgs; count++) {
          args.addElement(nextToken());
        }

        catalog.addEntry(new CatalogEntry(entryToken, args));
      } catch (CatalogException cex) {
        if (cex.getExceptionType() == 3) {
          if (unknownEntry == null) {
            unknownEntry = new Vector();
          }
          unknownEntry.addElement(token);
        } else if (cex.getExceptionType() == 2) {
          catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", token);
          unknownEntry = null;
        }
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.TR9401CatalogReader
 * JD-Core Version:    0.6.0
 */