/*     */ package org.jboss.util.xml.catalog.readers;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Hashtable;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import javax.xml.parsers.SAXParser;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.jboss.util.xml.catalog.Catalog;
/*     */ import org.jboss.util.xml.catalog.CatalogException;
/*     */ import org.jboss.util.xml.catalog.CatalogManager;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ import org.xml.sax.AttributeList;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.DocumentHandler;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.Parser;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class SAXCatalogReader
/*     */   implements CatalogReader, ContentHandler, DocumentHandler
/*     */ {
/* 118 */   protected SAXParserFactory parserFactory = null;
/*     */ 
/* 121 */   protected String parserClass = null;
/*     */ 
/* 130 */   protected Hashtable namespaceMap = new Hashtable();
/*     */ 
/* 133 */   private SAXCatalogParser saxParser = null;
/*     */ 
/* 138 */   private boolean abandonHope = false;
/*     */   private Catalog catalog;
/* 174 */   protected Debug debug = CatalogManager.getStaticManager().debug;
/*     */ 
/*     */   public void setParserFactory(SAXParserFactory parserFactory)
/*     */   {
/* 146 */     this.parserFactory = parserFactory;
/*     */   }
/*     */ 
/*     */   public void setParserClass(String parserClass)
/*     */   {
/* 152 */     this.parserClass = parserClass;
/*     */   }
/*     */ 
/*     */   public SAXParserFactory getParserFactory()
/*     */   {
/* 157 */     return this.parserFactory;
/*     */   }
/*     */ 
/*     */   public String getParserClass()
/*     */   {
/* 162 */     return this.parserClass;
/*     */   }
/*     */ 
/*     */   public SAXCatalogReader()
/*     */   {
/* 178 */     this.parserFactory = null;
/* 179 */     this.parserClass = null;
/*     */   }
/*     */ 
/*     */   public SAXCatalogReader(SAXParserFactory parserFactory)
/*     */   {
/* 184 */     this.parserFactory = parserFactory;
/*     */   }
/*     */ 
/*     */   public SAXCatalogReader(String parserClass)
/*     */   {
/* 189 */     this.parserClass = parserClass;
/*     */   }
/*     */ 
/*     */   public void setCatalogParser(String namespaceURI, String rootElement, String parserClass)
/*     */   {
/* 198 */     if (namespaceURI == null)
/* 199 */       this.namespaceMap.put(rootElement, parserClass);
/*     */     else
/* 201 */       this.namespaceMap.put("{" + namespaceURI + "}" + rootElement, parserClass);
/*     */   }
/*     */ 
/*     */   public String getCatalogParser(String namespaceURI, String rootElement)
/*     */   {
/* 210 */     if (namespaceURI == null) {
/* 211 */       return (String)this.namespaceMap.get(rootElement);
/*     */     }
/* 213 */     return (String)this.namespaceMap.get("{" + namespaceURI + "}" + rootElement);
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, String fileUrl)
/*     */     throws MalformedURLException, IOException, CatalogException
/*     */   {
/* 230 */     URL url = null;
/*     */     try
/*     */     {
/* 233 */       url = new URL(fileUrl);
/*     */     } catch (MalformedURLException e) {
/* 235 */       url = new URL("file:///" + fileUrl);
/*     */     }
/*     */ 
/* 238 */     this.debug = catalog.getCatalogManager().debug;
/*     */     try
/*     */     {
/* 241 */       URLConnection urlCon = url.openConnection();
/* 242 */       readCatalog(catalog, urlCon.getInputStream());
/*     */     } catch (FileNotFoundException e) {
/* 244 */       catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", url.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void readCatalog(Catalog catalog, InputStream is)
/*     */     throws IOException, CatalogException
/*     */   {
/* 263 */     if ((this.parserFactory == null) && (this.parserClass == null)) {
/* 264 */       this.debug.message(1, "Cannot read SAX catalog without a parser");
/* 265 */       throw new CatalogException(6);
/*     */     }
/*     */ 
/* 268 */     this.debug = catalog.getCatalogManager().debug;
/* 269 */     EntityResolver bResolver = catalog.getCatalogManager().getBootstrapResolver();
/*     */ 
/* 271 */     this.catalog = catalog;
/*     */     try
/*     */     {
/* 274 */       if (this.parserFactory != null) {
/* 275 */         SAXParser parser = this.parserFactory.newSAXParser();
/* 276 */         SAXParserHandler spHandler = new SAXParserHandler();
/* 277 */         spHandler.setContentHandler(this);
/* 278 */         if (bResolver != null) {
/* 279 */           spHandler.setEntityResolver(bResolver);
/*     */         }
/* 281 */         parser.parse(new InputSource(is), spHandler);
/*     */       } else {
/* 283 */         Parser parser = (Parser)Class.forName(this.parserClass).newInstance();
/* 284 */         parser.setDocumentHandler(this);
/* 285 */         if (bResolver != null) {
/* 286 */           parser.setEntityResolver(bResolver);
/*     */         }
/* 288 */         parser.parse(new InputSource(is));
/*     */       }
/*     */     } catch (ClassNotFoundException cnfe) {
/* 291 */       throw new CatalogException(6);
/*     */     } catch (IllegalAccessException iae) {
/* 293 */       throw new CatalogException(6);
/*     */     } catch (InstantiationException ie) {
/* 295 */       throw new CatalogException(6);
/*     */     } catch (ParserConfigurationException pce) {
/* 297 */       throw new CatalogException(5);
/*     */     } catch (SAXException se) {
/* 299 */       Exception e = se.getException();
/*     */ 
/* 301 */       UnknownHostException uhe = new UnknownHostException();
/* 302 */       FileNotFoundException fnfe = new FileNotFoundException();
/* 303 */       if (e != null) {
/* 304 */         if (e.getClass() == uhe.getClass()) {
/* 305 */           throw new CatalogException(7, e.toString());
/*     */         }
/* 307 */         if (e.getClass() == fnfe.getClass()) {
/* 308 */           throw new CatalogException(7, e.toString());
/*     */         }
/*     */       }
/*     */ 
/* 312 */       throw new CatalogException(se);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/* 321 */     if (this.saxParser != null)
/* 322 */       this.saxParser.setDocumentLocator(locator);
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/* 328 */     this.saxParser = null;
/* 329 */     this.abandonHope = false;
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/* 335 */     if (this.saxParser != null)
/* 336 */       this.saxParser.endDocument();
/*     */   }
/*     */ 
/*     */   public void startElement(String name, AttributeList atts)
/*     */     throws SAXException
/*     */   {
/* 350 */     if (this.abandonHope) {
/* 351 */       return;
/*     */     }
/*     */ 
/* 354 */     if (this.saxParser == null) {
/* 355 */       String prefix = "";
/* 356 */       if (name.indexOf(':') > 0) {
/* 357 */         prefix = name.substring(0, name.indexOf(':'));
/*     */       }
/*     */ 
/* 360 */       String localName = name;
/* 361 */       if (localName.indexOf(':') > 0) {
/* 362 */         localName = localName.substring(localName.indexOf(':') + 1);
/*     */       }
/*     */ 
/* 365 */       String namespaceURI = null;
/* 366 */       if (prefix.equals(""))
/* 367 */         namespaceURI = atts.getValue("xmlns");
/*     */       else {
/* 369 */         namespaceURI = atts.getValue("xmlns:" + prefix);
/*     */       }
/*     */ 
/* 372 */       String saxParserClass = getCatalogParser(namespaceURI, localName);
/*     */ 
/* 375 */       if (saxParserClass == null) {
/* 376 */         this.abandonHope = true;
/* 377 */         if (namespaceURI == null)
/* 378 */           this.debug.message(2, "No Catalog parser for " + name);
/*     */         else {
/* 380 */           this.debug.message(2, "No Catalog parser for {" + namespaceURI + "}" + name);
/*     */         }
/*     */ 
/* 384 */         return;
/*     */       }
/*     */       try
/*     */       {
/* 388 */         this.saxParser = ((SAXCatalogParser)Class.forName(saxParserClass).newInstance());
/*     */ 
/* 391 */         this.saxParser.setCatalog(this.catalog);
/* 392 */         this.saxParser.startDocument();
/* 393 */         this.saxParser.startElement(name, atts);
/*     */       } catch (ClassNotFoundException cnfe) {
/* 395 */         this.saxParser = null;
/* 396 */         this.abandonHope = true;
/* 397 */         this.debug.message(2, cnfe.toString());
/*     */       } catch (InstantiationException ie) {
/* 399 */         this.saxParser = null;
/* 400 */         this.abandonHope = true;
/* 401 */         this.debug.message(2, ie.toString());
/*     */       } catch (IllegalAccessException iae) {
/* 403 */         this.saxParser = null;
/* 404 */         this.abandonHope = true;
/* 405 */         this.debug.message(2, iae.toString());
/*     */       } catch (ClassCastException cce) {
/* 407 */         this.saxParser = null;
/* 408 */         this.abandonHope = true;
/* 409 */         this.debug.message(2, cce.toString());
/*     */       }
/*     */     } else {
/* 412 */       this.saxParser.startElement(name, atts);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 428 */     if (this.abandonHope) {
/* 429 */       return;
/*     */     }
/*     */ 
/* 432 */     if (this.saxParser == null) {
/* 433 */       String saxParserClass = getCatalogParser(namespaceURI, localName);
/*     */ 
/* 436 */       if (saxParserClass == null) {
/* 437 */         this.abandonHope = true;
/* 438 */         if (namespaceURI == null)
/* 439 */           this.debug.message(2, "No Catalog parser for " + localName);
/*     */         else {
/* 441 */           this.debug.message(2, "No Catalog parser for {" + namespaceURI + "}" + localName);
/*     */         }
/*     */ 
/* 445 */         return;
/*     */       }
/*     */       try
/*     */       {
/* 449 */         this.saxParser = ((SAXCatalogParser)Class.forName(saxParserClass).newInstance());
/*     */ 
/* 452 */         this.saxParser.setCatalog(this.catalog);
/* 453 */         this.saxParser.startDocument();
/* 454 */         this.saxParser.startElement(namespaceURI, localName, qName, atts);
/*     */       } catch (ClassNotFoundException cnfe) {
/* 456 */         this.saxParser = null;
/* 457 */         this.abandonHope = true;
/* 458 */         this.debug.message(2, cnfe.toString());
/*     */       } catch (InstantiationException ie) {
/* 460 */         this.saxParser = null;
/* 461 */         this.abandonHope = true;
/* 462 */         this.debug.message(2, ie.toString());
/*     */       } catch (IllegalAccessException iae) {
/* 464 */         this.saxParser = null;
/* 465 */         this.abandonHope = true;
/* 466 */         this.debug.message(2, iae.toString());
/*     */       } catch (ClassCastException cce) {
/* 468 */         this.saxParser = null;
/* 469 */         this.abandonHope = true;
/* 470 */         this.debug.message(2, cce.toString());
/*     */       }
/*     */     } else {
/* 473 */       this.saxParser.startElement(namespaceURI, localName, qName, atts);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endElement(String name) throws SAXException
/*     */   {
/* 479 */     if (this.saxParser != null)
/* 480 */       this.saxParser.endElement(name);
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 488 */     if (this.saxParser != null)
/* 489 */       this.saxParser.endElement(namespaceURI, localName, qName);
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 496 */     if (this.saxParser != null)
/* 497 */       this.saxParser.characters(ch, start, length);
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 504 */     if (this.saxParser != null)
/* 505 */       this.saxParser.ignorableWhitespace(ch, start, length);
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/* 512 */     if (this.saxParser != null)
/* 513 */       this.saxParser.processingInstruction(target, data);
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/* 520 */     if (this.saxParser != null)
/* 521 */       this.saxParser.startPrefixMapping(prefix, uri);
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */     throws SAXException
/*     */   {
/* 528 */     if (this.saxParser != null)
/* 529 */       this.saxParser.endPrefixMapping(prefix);
/*     */   }
/*     */ 
/*     */   public void skippedEntity(String name)
/*     */     throws SAXException
/*     */   {
/* 536 */     if (this.saxParser != null)
/* 537 */       this.saxParser.skippedEntity(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.SAXCatalogReader
 * JD-Core Version:    0.6.0
 */