/*     */ package org.jboss.util.xml.catalog.readers;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import java.util.Stack;
/*     */ import java.util.Vector;
/*     */ import org.jboss.util.xml.catalog.Catalog;
/*     */ import org.jboss.util.xml.catalog.CatalogEntry;
/*     */ import org.jboss.util.xml.catalog.CatalogException;
/*     */ import org.jboss.util.xml.catalog.CatalogManager;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ import org.jboss.util.xml.catalog.helpers.PublicId;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class OASISXMLCatalogReader extends SAXCatalogReader
/*     */   implements SAXCatalogParser
/*     */ {
/*  85 */   protected Catalog catalog = null;
/*     */   public static final String namespaceName = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
/*     */   public static final String tr9401NamespaceName = "urn:oasis:names:tc:entity:xmlns:tr9401:catalog";
/*  93 */   protected Stack baseURIStack = new Stack();
/*  94 */   protected Stack overrideStack = new Stack();
/*  95 */   protected Stack namespaceStack = new Stack();
/*     */ 
/*     */   public void setCatalog(Catalog catalog)
/*     */   {
/*  99 */     this.catalog = catalog;
/* 100 */     this.debug = catalog.getCatalogManager().debug;
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/* 105 */     return this.catalog;
/*     */   }
/*     */ 
/*     */   protected boolean inExtensionNamespace()
/*     */   {
/* 115 */     boolean inExtension = false;
/*     */ 
/* 117 */     Enumeration elements = this.namespaceStack.elements();
/* 118 */     while ((!inExtension) && (elements.hasMoreElements())) {
/* 119 */       String ns = (String)elements.nextElement();
/* 120 */       if (ns == null)
/* 121 */         inExtension = true;
/*     */       else {
/* 123 */         inExtension = (!ns.equals("urn:oasis:names:tc:entity:xmlns:tr9401:catalog")) && (!ns.equals("urn:oasis:names:tc:entity:xmlns:xml:catalog"));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 128 */     return inExtension;
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/* 142 */     this.baseURIStack.push(this.catalog.getCurrentBase());
/* 143 */     this.overrideStack.push(this.catalog.getDefaultOverride());
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 171 */     int entryType = -1;
/* 172 */     Vector entryArgs = new Vector();
/*     */ 
/* 174 */     this.namespaceStack.push(namespaceURI);
/*     */ 
/* 176 */     boolean inExtension = inExtensionNamespace();
/*     */ 
/* 178 */     if ((namespaceURI != null) && ("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 182 */       if (atts.getValue("xml:base") != null) {
/* 183 */         String baseURI = atts.getValue("xml:base");
/* 184 */         entryType = Catalog.BASE;
/* 185 */         entryArgs.add(baseURI);
/* 186 */         this.baseURIStack.push(baseURI);
/*     */ 
/* 188 */         this.debug.message(4, "xml:base", baseURI);
/*     */         try
/*     */         {
/* 191 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 192 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 194 */           if (cex.getExceptionType() == 3)
/* 195 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 196 */           else if (cex.getExceptionType() == 2) {
/* 197 */             this.debug.message(1, "Invalid catalog entry (base)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 201 */         entryType = -1;
/* 202 */         entryArgs = new Vector();
/*     */       }
/*     */       else {
/* 205 */         this.baseURIStack.push(this.baseURIStack.peek());
/*     */       }
/*     */ 
/* 208 */       if (((localName.equals("catalog")) || (localName.equals("group"))) && (atts.getValue("prefer") != null))
/*     */       {
/* 210 */         String override = atts.getValue("prefer");
/*     */ 
/* 212 */         if (override.equals("public")) {
/* 213 */           override = "yes";
/* 214 */         } else if (override.equals("system")) {
/* 215 */           override = "no";
/*     */         } else {
/* 217 */           this.debug.message(1, "Invalid prefer: must be 'system' or 'public'", localName);
/*     */ 
/* 220 */           override = this.catalog.getDefaultOverride();
/*     */         }
/*     */ 
/* 223 */         entryType = Catalog.OVERRIDE;
/* 224 */         entryArgs.add(override);
/* 225 */         this.overrideStack.push(override);
/*     */ 
/* 227 */         this.debug.message(4, "override", override);
/*     */         try
/*     */         {
/* 230 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 231 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 233 */           if (cex.getExceptionType() == 3)
/* 234 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 235 */           else if (cex.getExceptionType() == 2) {
/* 236 */             this.debug.message(1, "Invalid catalog entry (override)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 240 */         entryType = -1;
/* 241 */         entryArgs = new Vector();
/*     */       }
/*     */       else {
/* 244 */         this.overrideStack.push(this.overrideStack.peek());
/*     */       }
/*     */ 
/* 247 */       if (localName.equals("delegatePublic")) {
/* 248 */         if (checkAttributes(atts, "publicIdStartString", "catalog")) {
/* 249 */           entryType = Catalog.DELEGATE_PUBLIC;
/* 250 */           entryArgs.add(atts.getValue("publicIdStartString"));
/* 251 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 253 */           this.debug.message(4, "delegatePublic", PublicId.normalize(atts.getValue("publicIdStartString")), atts.getValue("catalog"));
/*     */         }
/*     */ 
/*     */       }
/* 257 */       else if (localName.equals("delegateSystem")) {
/* 258 */         if (checkAttributes(atts, "systemIdStartString", "catalog")) {
/* 259 */           entryType = Catalog.DELEGATE_SYSTEM;
/* 260 */           entryArgs.add(atts.getValue("systemIdStartString"));
/* 261 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 263 */           this.debug.message(4, "delegateSystem", atts.getValue("systemIdStartString"), atts.getValue("catalog"));
/*     */         }
/*     */ 
/*     */       }
/* 267 */       else if (localName.equals("delegateURI")) {
/* 268 */         if (checkAttributes(atts, "uriStartString", "catalog")) {
/* 269 */           entryType = Catalog.DELEGATE_URI;
/* 270 */           entryArgs.add(atts.getValue("uriStartString"));
/* 271 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 273 */           this.debug.message(4, "delegateURI", atts.getValue("uriStartString"), atts.getValue("catalog"));
/*     */         }
/*     */ 
/*     */       }
/* 277 */       else if (localName.equals("rewriteSystem")) {
/* 278 */         if (checkAttributes(atts, "systemIdStartString", "rewritePrefix")) {
/* 279 */           entryType = Catalog.REWRITE_SYSTEM;
/* 280 */           entryArgs.add(atts.getValue("systemIdStartString"));
/* 281 */           entryArgs.add(atts.getValue("rewritePrefix"));
/*     */ 
/* 283 */           this.debug.message(4, "rewriteSystem", atts.getValue("systemIdStartString"), atts.getValue("rewritePrefix"));
/*     */         }
/*     */ 
/*     */       }
/* 287 */       else if (localName.equals("rewriteURI")) {
/* 288 */         if (checkAttributes(atts, "uriStartString", "rewritePrefix")) {
/* 289 */           entryType = Catalog.REWRITE_URI;
/* 290 */           entryArgs.add(atts.getValue("uriStartString"));
/* 291 */           entryArgs.add(atts.getValue("rewritePrefix"));
/*     */ 
/* 293 */           this.debug.message(4, "rewriteURI", atts.getValue("uriStartString"), atts.getValue("rewritePrefix"));
/*     */         }
/*     */ 
/*     */       }
/* 297 */       else if (localName.equals("nextCatalog")) {
/* 298 */         if (checkAttributes(atts, "catalog")) {
/* 299 */           entryType = Catalog.CATALOG;
/* 300 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 302 */           this.debug.message(4, "nextCatalog", atts.getValue("catalog"));
/*     */         }
/* 304 */       } else if (localName.equals("public")) {
/* 305 */         if (checkAttributes(atts, "publicId", "uri")) {
/* 306 */           entryType = Catalog.PUBLIC;
/* 307 */           entryArgs.add(atts.getValue("publicId"));
/* 308 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 310 */           this.debug.message(4, "public", PublicId.normalize(atts.getValue("publicId")), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 314 */       else if (localName.equals("system")) {
/* 315 */         if (checkAttributes(atts, "systemId", "uri")) {
/* 316 */           entryType = Catalog.SYSTEM;
/* 317 */           entryArgs.add(atts.getValue("systemId"));
/* 318 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 320 */           this.debug.message(4, "system", atts.getValue("systemId"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 324 */       else if (localName.equals("uri")) {
/* 325 */         if (checkAttributes(atts, "name", "uri")) {
/* 326 */           entryType = Catalog.URI;
/* 327 */           entryArgs.add(atts.getValue("name"));
/* 328 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 330 */           this.debug.message(4, "uri", atts.getValue("name"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 334 */       else if (!localName.equals("catalog"))
/*     */       {
/* 336 */         if (!localName.equals("group"))
/*     */         {
/* 340 */           this.debug.message(1, "Invalid catalog entry type", localName);
/*     */         }
/*     */       }
/* 343 */       if (entryType >= 0) {
/*     */         try {
/* 345 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 346 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 348 */           if (cex.getExceptionType() == 3)
/* 349 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 350 */           else if (cex.getExceptionType() == 2) {
/* 351 */             this.debug.message(1, "Invalid catalog entry", localName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 357 */     if ((namespaceURI != null) && ("urn:oasis:names:tc:entity:xmlns:tr9401:catalog".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 361 */       if (atts.getValue("xml:base") != null) {
/* 362 */         String baseURI = atts.getValue("xml:base");
/* 363 */         entryType = Catalog.BASE;
/* 364 */         entryArgs.add(baseURI);
/* 365 */         this.baseURIStack.push(baseURI);
/*     */ 
/* 367 */         this.debug.message(4, "xml:base", baseURI);
/*     */         try
/*     */         {
/* 370 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 371 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 373 */           if (cex.getExceptionType() == 3)
/* 374 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 375 */           else if (cex.getExceptionType() == 2) {
/* 376 */             this.debug.message(1, "Invalid catalog entry (base)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 380 */         entryType = -1;
/* 381 */         entryArgs = new Vector();
/*     */       }
/*     */       else {
/* 384 */         this.baseURIStack.push(this.baseURIStack.peek());
/*     */       }
/*     */ 
/* 387 */       if (localName.equals("doctype")) {
/* 388 */         entryType = Catalog.DOCTYPE;
/* 389 */         entryArgs.add(atts.getValue("name"));
/* 390 */         entryArgs.add(atts.getValue("uri"));
/* 391 */       } else if (localName.equals("document")) {
/* 392 */         entryType = Catalog.DOCUMENT;
/* 393 */         entryArgs.add(atts.getValue("uri"));
/* 394 */       } else if (localName.equals("dtddecl")) {
/* 395 */         entryType = Catalog.DTDDECL;
/* 396 */         entryArgs.add(atts.getValue("publicId"));
/* 397 */         entryArgs.add(atts.getValue("uri"));
/* 398 */       } else if (localName.equals("entity")) {
/* 399 */         entryType = Catalog.ENTITY;
/* 400 */         entryArgs.add(atts.getValue("name"));
/* 401 */         entryArgs.add(atts.getValue("uri"));
/* 402 */       } else if (localName.equals("linktype")) {
/* 403 */         entryType = Catalog.LINKTYPE;
/* 404 */         entryArgs.add(atts.getValue("name"));
/* 405 */         entryArgs.add(atts.getValue("uri"));
/* 406 */       } else if (localName.equals("notation")) {
/* 407 */         entryType = Catalog.NOTATION;
/* 408 */         entryArgs.add(atts.getValue("name"));
/* 409 */         entryArgs.add(atts.getValue("uri"));
/* 410 */       } else if (localName.equals("sgmldecl")) {
/* 411 */         entryType = Catalog.SGMLDECL;
/* 412 */         entryArgs.add(atts.getValue("uri"));
/*     */       }
/*     */       else {
/* 415 */         this.debug.message(1, "Invalid catalog entry type", localName);
/*     */       }
/*     */ 
/* 418 */       if (entryType >= 0)
/*     */         try {
/* 420 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 421 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 423 */           if (cex.getExceptionType() == 3)
/* 424 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 425 */           else if (cex.getExceptionType() == 2)
/* 426 */             this.debug.message(1, "Invalid catalog entry", localName);
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean checkAttributes(Attributes atts, String attName)
/*     */   {
/* 434 */     if (atts.getValue(attName) == null) {
/* 435 */       this.debug.message(1, "Error: required attribute " + attName + " missing.");
/* 436 */       return false;
/*     */     }
/* 438 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean checkAttributes(Attributes atts, String attName1, String attName2)
/*     */   {
/* 445 */     return (checkAttributes(atts, attName1)) && (checkAttributes(atts, attName2));
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 455 */     int entryType = -1;
/* 456 */     Vector entryArgs = new Vector();
/*     */ 
/* 458 */     boolean inExtension = inExtensionNamespace();
/*     */ 
/* 460 */     if ((namespaceURI != null) && (!inExtension) && (("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(namespaceURI)) || ("urn:oasis:names:tc:entity:xmlns:tr9401:catalog".equals(namespaceURI))))
/*     */     {
/* 465 */       String popURI = (String)this.baseURIStack.pop();
/* 466 */       String baseURI = (String)this.baseURIStack.peek();
/*     */ 
/* 468 */       if (!baseURI.equals(popURI)) {
/* 469 */         entryType = Catalog.BASE;
/* 470 */         entryArgs.add(baseURI);
/*     */ 
/* 472 */         this.debug.message(4, "(reset) xml:base", baseURI);
/*     */         try
/*     */         {
/* 475 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 476 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 478 */           if (cex.getExceptionType() == 3)
/* 479 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 480 */           else if (cex.getExceptionType() == 2) {
/* 481 */             this.debug.message(1, "Invalid catalog entry (rbase)", localName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 487 */     if ((namespaceURI != null) && ("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 489 */       if ((localName.equals("catalog")) || (localName.equals("group"))) {
/* 490 */         String popOverride = (String)this.overrideStack.pop();
/* 491 */         String override = (String)this.overrideStack.peek();
/*     */ 
/* 493 */         if (!override.equals(popOverride)) {
/* 494 */           entryType = Catalog.OVERRIDE;
/* 495 */           entryArgs.add(override);
/* 496 */           this.overrideStack.push(override);
/*     */ 
/* 498 */           this.debug.message(4, "(reset) override", override);
/*     */           try
/*     */           {
/* 501 */             CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 502 */             this.catalog.addEntry(ce);
/*     */           } catch (CatalogException cex) {
/* 504 */             if (cex.getExceptionType() == 3)
/* 505 */               this.debug.message(1, "Invalid catalog entry type", localName);
/* 506 */             else if (cex.getExceptionType() == 2) {
/* 507 */               this.debug.message(1, "Invalid catalog entry (roverride)", localName);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 514 */     this.namespaceStack.pop();
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void skippedEntity(String name)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.readers.OASISXMLCatalogReader
 * JD-Core Version:    0.6.0
 */