/*     */ package org.jboss.util.xml.catalog.helpers;
/*     */ 
/*     */ public abstract class PublicId
/*     */ {
/*     */   public static String normalize(String publicId)
/*     */   {
/*  95 */     String normal = publicId.replace('\t', ' ');
/*  96 */     normal = normal.replace('\r', ' ');
/*  97 */     normal = normal.replace('\n', ' ');
/*  98 */     normal = normal.trim();
/*     */     int pos;
/* 102 */     while ((pos = normal.indexOf("  ")) >= 0) {
/* 103 */       normal = normal.substring(0, pos) + normal.substring(pos + 1);
/*     */     }
/*     */ 
/* 106 */     return normal;
/*     */   }
/*     */ 
/*     */   public static String encodeURN(String publicId)
/*     */   {
/* 120 */     String urn = normalize(publicId);
/*     */ 
/* 122 */     urn = stringReplace(urn, "%", "%25");
/* 123 */     urn = stringReplace(urn, ";", "%3B");
/* 124 */     urn = stringReplace(urn, "'", "%27");
/* 125 */     urn = stringReplace(urn, "?", "%3F");
/* 126 */     urn = stringReplace(urn, "#", "%23");
/* 127 */     urn = stringReplace(urn, "+", "%2B");
/* 128 */     urn = stringReplace(urn, " ", "+");
/* 129 */     urn = stringReplace(urn, "::", ";");
/* 130 */     urn = stringReplace(urn, ":", "%3A");
/* 131 */     urn = stringReplace(urn, "//", ":");
/* 132 */     urn = stringReplace(urn, "/", "%2F");
/*     */ 
/* 134 */     return "urn:publicid:" + urn;
/*     */   }
/*     */ 
/*     */   public static String decodeURN(String urn)
/*     */   {
/* 148 */     String publicId = "";
/*     */ 
/* 150 */     if (urn.startsWith("urn:publicid:"))
/* 151 */       publicId = urn.substring(13);
/*     */     else {
/* 153 */       return urn;
/*     */     }
/*     */ 
/* 156 */     publicId = stringReplace(publicId, "%2F", "/");
/* 157 */     publicId = stringReplace(publicId, ":", "//");
/* 158 */     publicId = stringReplace(publicId, "%3A", ":");
/* 159 */     publicId = stringReplace(publicId, ";", "::");
/* 160 */     publicId = stringReplace(publicId, "+", " ");
/* 161 */     publicId = stringReplace(publicId, "%2B", "+");
/* 162 */     publicId = stringReplace(publicId, "%23", "#");
/* 163 */     publicId = stringReplace(publicId, "%3F", "?");
/* 164 */     publicId = stringReplace(publicId, "%27", "'");
/* 165 */     publicId = stringReplace(publicId, "%3B", ";");
/* 166 */     publicId = stringReplace(publicId, "%25", "%");
/*     */ 
/* 168 */     return publicId;
/*     */   }
/*     */ 
/*     */   private static String stringReplace(String str, String oldStr, String newStr)
/*     */   {
/* 179 */     String result = "";
/* 180 */     int pos = str.indexOf(oldStr);
/*     */ 
/* 184 */     while (pos >= 0)
/*     */     {
/* 186 */       result = result + str.substring(0, pos);
/* 187 */       result = result + newStr;
/* 188 */       str = str.substring(pos + 1);
/*     */ 
/* 190 */       pos = str.indexOf(oldStr);
/*     */     }
/*     */ 
/* 193 */     return result + str;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.helpers.PublicId
 * JD-Core Version:    0.6.0
 */