/*     */ package org.jboss.util.xml.catalog;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Vector;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.jboss.util.xml.catalog.helpers.Debug;
/*     */ import org.jboss.util.xml.catalog.readers.ExtendedXMLCatalogReader;
/*     */ import org.jboss.util.xml.catalog.readers.SAXCatalogReader;
/*     */ import org.jboss.util.xml.catalog.readers.TR9401CatalogReader;
/*     */ import org.jboss.util.xml.catalog.readers.XCatalogReader;
/*     */ 
/*     */ public class Resolver extends Catalog
/*     */ {
/*  93 */   public static final int URISUFFIX = CatalogEntry.addEntryType("URISUFFIX", 2);
/*     */ 
/* 101 */   public static final int SYSTEMSUFFIX = CatalogEntry.addEntryType("SYSTEMSUFFIX", 2);
/*     */ 
/* 108 */   public static final int RESOLVER = CatalogEntry.addEntryType("RESOLVER", 1);
/*     */ 
/* 118 */   public static final int SYSTEMREVERSE = CatalogEntry.addEntryType("SYSTEMREVERSE", 1);
/*     */ 
/*     */   public void setupReaders()
/*     */   {
/* 125 */     SAXParserFactory spf = SAXParserFactory.newInstance();
/* 126 */     spf.setNamespaceAware(true);
/* 127 */     spf.setValidating(false);
/*     */ 
/* 129 */     SAXCatalogReader saxReader = new SAXCatalogReader(spf);
/*     */ 
/* 131 */     saxReader.setCatalogParser(null, "XMLCatalog", XCatalogReader.class.getName());
/*     */ 
/* 134 */     saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", ExtendedXMLCatalogReader.class.getName());
/*     */ 
/* 138 */     addReader("application/xml", saxReader);
/*     */ 
/* 140 */     TR9401CatalogReader textReader = new TR9401CatalogReader();
/* 141 */     addReader("text/plain", textReader);
/*     */   }
/*     */ 
/*     */   public void addEntry(CatalogEntry entry)
/*     */   {
/* 155 */     int type = entry.getEntryType();
/*     */ 
/* 157 */     if (type == URISUFFIX) {
/* 158 */       String suffix = normalizeURI(entry.getEntryArg(0));
/* 159 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*     */ 
/* 161 */       entry.setEntryArg(1, fsi);
/*     */ 
/* 163 */       this.catalogManager.debug.message(4, "URISUFFIX", suffix, fsi);
/* 164 */     } else if (type == SYSTEMSUFFIX) {
/* 165 */       String suffix = normalizeURI(entry.getEntryArg(0));
/* 166 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*     */ 
/* 168 */       entry.setEntryArg(1, fsi);
/*     */ 
/* 170 */       this.catalogManager.debug.message(4, "SYSTEMSUFFIX", suffix, fsi);
/*     */     }
/*     */ 
/* 173 */     super.addEntry(entry);
/*     */   }
/*     */ 
/*     */   public String resolveURI(String uri)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 199 */     String resolved = super.resolveURI(uri);
/* 200 */     if (resolved != null) {
/* 201 */       return resolved;
/*     */     }
/*     */ 
/* 204 */     Enumeration enumt = this.catalogEntries.elements();
/* 205 */     while (enumt.hasMoreElements()) {
/* 206 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 207 */       if (e.getEntryType() == RESOLVER) {
/* 208 */         resolved = resolveExternalSystem(uri, e.getEntryArg(0));
/* 209 */         if (resolved != null)
/* 210 */           return resolved;
/*     */       }
/* 212 */       else if (e.getEntryType() == URISUFFIX) {
/* 213 */         String suffix = e.getEntryArg(0);
/* 214 */         String result = e.getEntryArg(1);
/*     */ 
/* 216 */         if ((suffix.length() <= uri.length()) && (uri.substring(uri.length() - suffix.length()).equals(suffix)))
/*     */         {
/* 218 */           return result;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 224 */     return resolveSubordinateCatalogs(Catalog.URI, null, null, uri);
/*     */   }
/*     */ 
/*     */   public String resolveSystem(String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 256 */     String resolved = super.resolveSystem(systemId);
/* 257 */     if (resolved != null) {
/* 258 */       return resolved;
/*     */     }
/*     */ 
/* 261 */     Enumeration enumt = this.catalogEntries.elements();
/* 262 */     while (enumt.hasMoreElements()) {
/* 263 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 264 */       if (e.getEntryType() == RESOLVER) {
/* 265 */         resolved = resolveExternalSystem(systemId, e.getEntryArg(0));
/* 266 */         if (resolved != null)
/* 267 */           return resolved;
/*     */       }
/* 269 */       else if (e.getEntryType() == SYSTEMSUFFIX) {
/* 270 */         String suffix = e.getEntryArg(0);
/* 271 */         String result = e.getEntryArg(1);
/*     */ 
/* 273 */         if ((suffix.length() <= systemId.length()) && (systemId.substring(systemId.length() - suffix.length()).equals(suffix)))
/*     */         {
/* 275 */           return result;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 280 */     return resolveSubordinateCatalogs(Catalog.SYSTEM, null, null, systemId);
/*     */   }
/*     */ 
/*     */   public String resolvePublic(String publicId, String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 318 */     String resolved = super.resolvePublic(publicId, systemId);
/* 319 */     if (resolved != null) {
/* 320 */       return resolved;
/*     */     }
/*     */ 
/* 323 */     Enumeration enumt = this.catalogEntries.elements();
/* 324 */     while (enumt.hasMoreElements()) {
/* 325 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 326 */       if (e.getEntryType() == RESOLVER) {
/* 327 */         if (systemId != null) {
/* 328 */           resolved = resolveExternalSystem(systemId, e.getEntryArg(0));
/*     */ 
/* 330 */           if (resolved != null) {
/* 331 */             return resolved;
/*     */           }
/*     */         }
/* 334 */         resolved = resolveExternalPublic(publicId, e.getEntryArg(0));
/* 335 */         if (resolved != null) {
/* 336 */           return resolved;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 341 */     return resolveSubordinateCatalogs(Catalog.PUBLIC, null, publicId, systemId);
/*     */   }
/*     */ 
/*     */   protected String resolveExternalSystem(String systemId, String resolver)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 357 */     Resolver r = queryResolver(resolver, "i2l", systemId, null);
/* 358 */     if (r != null) {
/* 359 */       return r.resolveSystem(systemId);
/*     */     }
/* 361 */     return null;
/*     */   }
/*     */ 
/*     */   protected String resolveExternalPublic(String publicId, String resolver)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 375 */     Resolver r = queryResolver(resolver, "fpi2l", publicId, null);
/* 376 */     if (r != null) {
/* 377 */       return r.resolvePublic(publicId, null);
/*     */     }
/* 379 */     return null;
/*     */   }
/*     */ 
/*     */   protected Resolver queryResolver(String resolver, String command, String arg1, String arg2)
/*     */   {
/* 397 */     InputStream iStream = null;
/* 398 */     String RFC2483 = resolver + "?command=" + command + "&format=tr9401&uri=" + arg1 + "&uri2=" + arg2;
/*     */ 
/* 401 */     String line = null;
/*     */     try
/*     */     {
/* 404 */       URL url = new URL(RFC2483);
/*     */ 
/* 406 */       URLConnection urlCon = url.openConnection();
/*     */ 
/* 408 */       urlCon.setUseCaches(false);
/*     */ 
/* 410 */       Resolver r = (Resolver)newCatalog();
/*     */ 
/* 412 */       String cType = urlCon.getContentType();
/*     */ 
/* 415 */       if (cType.indexOf(";") > 0) {
/* 416 */         cType = cType.substring(0, cType.indexOf(";"));
/*     */       }
/*     */ 
/* 419 */       r.parseCatalog(cType, urlCon.getInputStream());
/*     */ 
/* 421 */       return r;
/*     */     } catch (CatalogException cex) {
/* 423 */       if (cex.getExceptionType() == 6)
/* 424 */         this.catalogManager.debug.message(1, "Unparseable catalog: " + RFC2483);
/* 425 */       else if (cex.getExceptionType() == 5)
/*     */       {
/* 427 */         this.catalogManager.debug.message(1, "Unknown catalog format: " + RFC2483);
/*     */       }
/* 429 */       return null;
/*     */     } catch (MalformedURLException mue) {
/* 431 */       this.catalogManager.debug.message(1, "Malformed resolver URL: " + RFC2483);
/* 432 */       return null;
/*     */     } catch (IOException ie) {
/* 434 */       this.catalogManager.debug.message(1, "I/O Exception opening resolver: " + RFC2483);
/* 435 */     }return null;
/*     */   }
/*     */ 
/*     */   private Vector appendVector(Vector vec, Vector appvec)
/*     */   {
/* 447 */     if (appvec != null) {
/* 448 */       for (int count = 0; count < appvec.size(); count++) {
/* 449 */         vec.addElement(appvec.elementAt(count));
/*     */       }
/*     */     }
/* 452 */     return vec;
/*     */   }
/*     */ 
/*     */   public Vector resolveAllSystemReverse(String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 464 */     Vector resolved = new Vector();
/*     */ 
/* 467 */     if (systemId != null) {
/* 468 */       Vector localResolved = resolveLocalSystemReverse(systemId);
/* 469 */       resolved = appendVector(resolved, localResolved);
/*     */     }
/*     */ 
/* 473 */     Vector subResolved = resolveAllSubordinateCatalogs(SYSTEMREVERSE, null, null, systemId);
/*     */ 
/* 478 */     return appendVector(resolved, subResolved);
/*     */   }
/*     */ 
/*     */   public String resolveSystemReverse(String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 490 */     Vector resolved = resolveAllSystemReverse(systemId);
/* 491 */     if ((resolved != null) && (resolved.size() > 0)) {
/* 492 */       return (String)resolved.elementAt(0);
/*     */     }
/* 494 */     return null;
/*     */   }
/*     */ 
/*     */   public Vector resolveAllSystem(String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 527 */     Vector resolutions = new Vector();
/*     */ 
/* 530 */     if (systemId != null) {
/* 531 */       Vector localResolutions = resolveAllLocalSystem(systemId);
/* 532 */       resolutions = appendVector(resolutions, localResolutions);
/*     */     }
/*     */ 
/* 536 */     Vector subResolutions = resolveAllSubordinateCatalogs(SYSTEM, null, null, systemId);
/*     */ 
/* 540 */     resolutions = appendVector(resolutions, subResolutions);
/*     */ 
/* 542 */     if (resolutions.size() > 0) {
/* 543 */       return resolutions;
/*     */     }
/* 545 */     return null;
/*     */   }
/*     */ 
/*     */   private Vector resolveAllLocalSystem(String systemId)
/*     */   {
/* 561 */     Vector map = new Vector();
/* 562 */     String osname = System.getProperty("os.name");
/* 563 */     boolean windows = osname.indexOf("Windows") >= 0;
/* 564 */     Enumeration enumt = this.catalogEntries.elements();
/* 565 */     while (enumt.hasMoreElements()) {
/* 566 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 567 */       if ((e.getEntryType() == SYSTEM) && ((e.getEntryArg(0).equals(systemId)) || ((windows) && (e.getEntryArg(0).equalsIgnoreCase(systemId)))))
/*     */       {
/* 571 */         map.addElement(e.getEntryArg(1));
/*     */       }
/*     */     }
/* 574 */     if (map.size() == 0) {
/* 575 */       return null;
/*     */     }
/* 577 */     return map;
/*     */   }
/*     */ 
/*     */   private Vector resolveLocalSystemReverse(String systemId)
/*     */   {
/* 589 */     Vector map = new Vector();
/* 590 */     String osname = System.getProperty("os.name");
/* 591 */     boolean windows = osname.indexOf("Windows") >= 0;
/* 592 */     Enumeration enumt = this.catalogEntries.elements();
/* 593 */     while (enumt.hasMoreElements()) {
/* 594 */       CatalogEntry e = (CatalogEntry)enumt.nextElement();
/* 595 */       if ((e.getEntryType() == SYSTEM) && ((e.getEntryArg(1).equals(systemId)) || ((windows) && (e.getEntryArg(1).equalsIgnoreCase(systemId)))))
/*     */       {
/* 599 */         map.addElement(e.getEntryArg(0));
/*     */       }
/*     */     }
/* 602 */     if (map.size() == 0) {
/* 603 */       return null;
/*     */     }
/* 605 */     return map;
/*     */   }
/*     */ 
/*     */   private synchronized Vector resolveAllSubordinateCatalogs(int entityType, String entityName, String publicId, String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 643 */     Vector resolutions = new Vector();
/*     */ 
/* 645 */     for (int catPos = 0; catPos < this.catalogs.size(); catPos++) {
/* 646 */       Resolver c = null;
/*     */       try
/*     */       {
/* 649 */         c = (Resolver)this.catalogs.elementAt(catPos);
/*     */       } catch (ClassCastException e) {
/* 651 */         String catfile = (String)this.catalogs.elementAt(catPos);
/* 652 */         c = (Resolver)newCatalog();
/*     */         try
/*     */         {
/* 655 */           c.parseCatalog(catfile);
/*     */         } catch (MalformedURLException mue) {
/* 657 */           this.catalogManager.debug.message(1, "Malformed Catalog URL", catfile);
/*     */         } catch (FileNotFoundException fnfe) {
/* 659 */           this.catalogManager.debug.message(1, "Failed to load catalog, file not found", catfile);
/*     */         }
/*     */         catch (IOException ioe) {
/* 662 */           this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", catfile);
/*     */         }
/*     */ 
/* 665 */         this.catalogs.setElementAt(c, catPos);
/*     */       }
/*     */ 
/* 668 */       String resolved = null;
/*     */ 
/* 671 */       if (entityType == DOCTYPE) {
/* 672 */         resolved = c.resolveDoctype(entityName, publicId, systemId);
/*     */ 
/* 675 */         if (resolved == null)
/*     */           continue;
/* 677 */         resolutions.addElement(resolved);
/* 678 */         return resolutions;
/*     */       }
/* 680 */       if (entityType == DOCUMENT) {
/* 681 */         resolved = c.resolveDocument();
/* 682 */         if (resolved == null)
/*     */           continue;
/* 684 */         resolutions.addElement(resolved);
/* 685 */         return resolutions;
/*     */       }
/* 687 */       if (entityType == ENTITY) {
/* 688 */         resolved = c.resolveEntity(entityName, publicId, systemId);
/*     */ 
/* 691 */         if (resolved == null)
/*     */           continue;
/* 693 */         resolutions.addElement(resolved);
/* 694 */         return resolutions;
/*     */       }
/* 696 */       if (entityType == NOTATION) {
/* 697 */         resolved = c.resolveNotation(entityName, publicId, systemId);
/*     */ 
/* 700 */         if (resolved == null)
/*     */           continue;
/* 702 */         resolutions.addElement(resolved);
/* 703 */         return resolutions;
/*     */       }
/* 705 */       if (entityType == PUBLIC) {
/* 706 */         resolved = c.resolvePublic(publicId, systemId);
/* 707 */         if (resolved == null)
/*     */           continue;
/* 709 */         resolutions.addElement(resolved);
/* 710 */         return resolutions;
/*     */       }
/* 712 */       if (entityType == SYSTEM) {
/* 713 */         Vector localResolutions = c.resolveAllSystem(systemId);
/* 714 */         resolutions = appendVector(resolutions, localResolutions);
/* 715 */         break;
/* 716 */       }if (entityType == SYSTEMREVERSE) {
/* 717 */         Vector localResolutions = c.resolveAllSystemReverse(systemId);
/* 718 */         resolutions = appendVector(resolutions, localResolutions);
/*     */       }
/*     */     }
/*     */ 
/* 722 */     if (resolutions != null) {
/* 723 */       return resolutions;
/*     */     }
/* 725 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.catalog.Resolver
 * JD-Core Version:    0.6.0
 */