/*     */ package org.jboss.util.xml;
/*     */ 
/*     */ import javax.xml.transform.ErrorListener;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ import org.xml.sax.SAXParseException;
/*     */ 
/*     */ public class JBossErrorHandler
/*     */   implements ErrorHandler, ErrorListener
/*     */ {
/*  34 */   private static final Logger log = Logger.getLogger(JBossErrorHandler.class);
/*     */   private String fileName;
/*     */   private JBossEntityResolver resolver;
/*     */   private boolean error;
/*     */ 
/*     */   public JBossErrorHandler(String fileName, JBossEntityResolver resolver)
/*     */   {
/*  43 */     this.fileName = fileName;
/*  44 */     this.resolver = resolver;
/*  45 */     this.error = false;
/*     */   }
/*     */ 
/*     */   public void error(SAXParseException e)
/*     */   {
/*  50 */     if ((this.resolver == null) || (this.resolver.isEntityResolved()))
/*     */     {
/*  52 */       this.error = true;
/*  53 */       log.error(formatError("error", e));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void fatalError(SAXParseException e)
/*     */   {
/*  59 */     if ((this.resolver == null) || (this.resolver.isEntityResolved()))
/*     */     {
/*  61 */       this.error = true;
/*  62 */       log.error(formatError("fatal", e));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void warning(SAXParseException e)
/*     */   {
/*  68 */     if ((this.resolver == null) || (this.resolver.isEntityResolved()))
/*     */     {
/*  70 */       this.error = true;
/*  71 */       log.error(formatError("warning", e));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void error(TransformerException e)
/*     */   {
/*  77 */     if ((this.resolver == null) || (this.resolver.isEntityResolved()))
/*     */     {
/*  79 */       this.error = true;
/*  80 */       log.error(formatError("error", e));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void fatalError(TransformerException e)
/*     */   {
/*  86 */     if ((this.resolver == null) || (this.resolver.isEntityResolved()))
/*     */     {
/*  88 */       this.error = true;
/*  89 */       log.error(formatError("fatal", e));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void warning(TransformerException e)
/*     */   {
/*  95 */     if ((this.resolver == null) || (this.resolver.isEntityResolved()))
/*     */     {
/*  97 */       this.error = true;
/*  98 */       log.error(formatError("warning", e));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String formatError(String context, SAXParseException e)
/*     */   {
/* 104 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 105 */     buffer.append("File ").append(this.fileName);
/* 106 */     buffer.append(" process ").append(context);
/* 107 */     buffer.append(". Line: ").append(e.getLineNumber());
/* 108 */     buffer.append(". Error message: ").append(e.getMessage());
/* 109 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected String formatError(String context, TransformerException e)
/*     */   {
/* 114 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 115 */     buffer.append("File ").append(this.fileName);
/* 116 */     buffer.append(" process ").append(context);
/* 117 */     buffer.append(". Location: ").append(e.getLocationAsString());
/* 118 */     buffer.append(". Error message: ").append(e.getMessage());
/* 119 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public boolean hadError()
/*     */   {
/* 124 */     return this.error;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.JBossErrorHandler
 * JD-Core Version:    0.6.0
 */