/*     */ package org.jboss.util.xml;
/*     */ 
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.io.Writer;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class DOMWriter
/*     */ {
/*     */   private PrintWriter out;
/*     */   private boolean canonical;
/*     */   private boolean prettyprint;
/*     */   private boolean writeXMLDeclaration;
/*     */   private String charsetName;
/*     */   private int prettyIndent;
/*     */   private boolean wroteXMLDeclaration;
/*     */   private Node rootNode;
/* 102 */   private boolean completeNamespaces = true;
/*     */ 
/*     */   public DOMWriter(Writer w)
/*     */   {
/* 106 */     this.out = new PrintWriter(w);
/*     */   }
/*     */ 
/*     */   public DOMWriter(Writer w, String charsetName)
/*     */   {
/* 111 */     this.out = new PrintWriter(w);
/* 112 */     this.charsetName = charsetName;
/* 113 */     this.writeXMLDeclaration = true;
/*     */   }
/*     */ 
/*     */   public DOMWriter(OutputStream stream)
/*     */   {
/*     */     try
/*     */     {
/* 120 */       this.out = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public DOMWriter(OutputStream stream, String charsetName)
/*     */   {
/*     */     try
/*     */     {
/* 132 */       this.out = new PrintWriter(new OutputStreamWriter(stream, charsetName));
/* 133 */       this.charsetName = charsetName;
/* 134 */       this.writeXMLDeclaration = true;
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 138 */       throw new IllegalArgumentException("Unsupported encoding: " + charsetName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String printNode(Node node, boolean prettyprint)
/*     */   {
/* 149 */     StringWriter strw = new StringWriter();
/* 150 */     new DOMWriter(strw).setPrettyprint(prettyprint).print(node);
/* 151 */     return strw.toString();
/*     */   }
/*     */ 
/*     */   public boolean isCanonical()
/*     */   {
/* 156 */     return this.canonical;
/*     */   }
/*     */ 
/*     */   public DOMWriter setCanonical(boolean canonical)
/*     */   {
/* 165 */     this.canonical = canonical;
/* 166 */     return this;
/*     */   }
/*     */ 
/*     */   public DOMWriter setCompleteNamespaces(boolean complete)
/*     */   {
/* 176 */     this.completeNamespaces = complete;
/* 177 */     return this;
/*     */   }
/*     */ 
/*     */   public boolean isPrettyprint()
/*     */   {
/* 182 */     return this.prettyprint;
/*     */   }
/*     */ 
/*     */   public DOMWriter setPrettyprint(boolean prettyprint)
/*     */   {
/* 191 */     this.prettyprint = prettyprint;
/* 192 */     return this;
/*     */   }
/*     */ 
/*     */   public boolean isWriteXMLDeclaration()
/*     */   {
/* 197 */     return this.writeXMLDeclaration;
/*     */   }
/*     */ 
/*     */   public DOMWriter setWriteXMLDeclaration(boolean flag)
/*     */   {
/* 206 */     this.writeXMLDeclaration = flag;
/* 207 */     return this;
/*     */   }
/*     */ 
/*     */   public void print(Node node)
/*     */   {
/* 212 */     this.rootNode = node;
/* 213 */     printInternal(node, false);
/*     */   }
/*     */ 
/*     */   private void printInternal(Node node, boolean indentEndMarker)
/*     */   {
/* 219 */     if (node == null)
/*     */     {
/* 221 */       return;
/*     */     }
/*     */ 
/* 227 */     if ((!this.wroteXMLDeclaration) && (this.writeXMLDeclaration == true) && (!this.canonical))
/*     */     {
/* 229 */       this.out.print("<?xml version='1.0'");
/* 230 */       if (this.charsetName != null) {
/* 231 */         this.out.print(" encoding='" + this.charsetName + "'");
/*     */       }
/* 233 */       this.out.print("?>");
/* 234 */       if (this.prettyprint) {
/* 235 */         this.out.println();
/*     */       }
/* 237 */       this.wroteXMLDeclaration = true;
/*     */     }
/*     */ 
/* 240 */     int type = node.getNodeType();
/* 241 */     boolean hasChildNodes = node.getChildNodes().getLength() > 0;
/*     */ 
/* 243 */     String nodeName = node.getNodeName();
/* 244 */     switch (type)
/*     */     {
/*     */     case 9:
/* 249 */       NodeList children = node.getChildNodes();
/* 250 */       for (int iChild = 0; iChild < children.getLength(); iChild++)
/*     */       {
/* 252 */         printInternal(children.item(iChild), false);
/*     */       }
/* 254 */       this.out.flush();
/* 255 */       break;
/*     */     case 1:
/* 261 */       Element element = (Element)node;
/* 262 */       if (this.prettyprint)
/*     */       {
/* 264 */         for (int i = 0; i < this.prettyIndent; i++)
/*     */         {
/* 266 */           this.out.print(' ');
/*     */         }
/* 268 */         this.prettyIndent += 1;
/*     */       }
/*     */ 
/* 271 */       this.out.print('<');
/* 272 */       this.out.print(nodeName);
/*     */ 
/* 274 */       Map nsMap = new HashMap();
/* 275 */       String elPrefix = node.getPrefix();
/* 276 */       if (elPrefix != null)
/*     */       {
/* 278 */         String nsURI = getNamespaceURI(elPrefix, element, this.rootNode);
/* 279 */         nsMap.put(elPrefix, nsURI);
/*     */       }
/*     */ 
/* 282 */       Attr[] attrs = sortAttributes(node.getAttributes());
/* 283 */       for (int i = 0; i < attrs.length; i++)
/*     */       {
/* 285 */         Attr attr = attrs[i];
/* 286 */         String atPrefix = attr.getPrefix();
/* 287 */         String atName = attr.getNodeName();
/* 288 */         String atValue = normalize(attr.getNodeValue(), this.canonical);
/*     */ 
/* 290 */         if (atPrefix != null) if (((atPrefix.equals("xmlns")) || (atPrefix.equals("xml")) ? 1 : 0) == 0)
/*     */           {
/* 292 */             String nsURI = getNamespaceURI(atPrefix, element, this.rootNode);
/* 293 */             nsMap.put(atPrefix, nsURI);
/*     */           }
/*     */ 
/* 296 */         this.out.print(" " + atName + "='" + atValue + "'");
/*     */       }
/*     */ 
/* 300 */       if (this.completeNamespaces)
/*     */       {
/* 302 */         Iterator itPrefix = nsMap.keySet().iterator();
/* 303 */         while (itPrefix.hasNext())
/*     */         {
/* 305 */           String prefix = (String)itPrefix.next();
/* 306 */           String nsURI = (String)nsMap.get(prefix);
/* 307 */           if (nsURI == null)
/*     */           {
/* 309 */             nsURI = getNamespaceURI(prefix, element, null);
/* 310 */             this.out.print(" xmlns:" + prefix + "='" + nsURI + "'");
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 315 */       if (hasChildNodes)
/*     */       {
/* 317 */         this.out.print('>');
/*     */       }
/*     */ 
/* 321 */       indentEndMarker = isEndMarkerIndented(node);
/*     */ 
/* 323 */       if (indentEndMarker)
/*     */       {
/* 325 */         this.out.print('\n');
/*     */       }
/*     */ 
/* 328 */       NodeList childNodes = node.getChildNodes();
/* 329 */       int len = childNodes.getLength();
/* 330 */       for (int i = 0; i < len; i++)
/*     */       {
/* 332 */         Node childNode = childNodes.item(i);
/* 333 */         printInternal(childNode, false);
/*     */       }
/* 335 */       break;
/*     */     case 5:
/* 341 */       if (this.canonical)
/*     */       {
/* 343 */         NodeList children = node.getChildNodes();
/* 344 */         if (children != null)
/*     */         {
/* 346 */           int len = children.getLength();
/* 347 */           for (int i = 0; i < len; i++)
/*     */           {
/* 349 */             printInternal(children.item(i), false);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 355 */         this.out.print('&');
/* 356 */         this.out.print(nodeName);
/* 357 */         this.out.print(';');
/*     */       }
/* 359 */       break;
/*     */     case 4:
/* 365 */       if (this.canonical)
/*     */       {
/* 367 */         this.out.print(normalize(node.getNodeValue(), this.canonical));
/*     */       }
/*     */       else
/*     */       {
/* 371 */         this.out.print("<![CDATA[");
/* 372 */         this.out.print(node.getNodeValue());
/* 373 */         this.out.print("]]>");
/*     */       }
/* 375 */       break;
/*     */     case 3:
/* 381 */       String text = normalize(node.getNodeValue(), this.canonical);
/* 382 */       if ((this.prettyprint) && (text.trim().length() <= 0)) break;
/* 383 */       this.out.print(text); break;
/*     */     case 7:
/* 390 */       this.out.print("<?");
/* 391 */       this.out.print(nodeName);
/* 392 */       String data = node.getNodeValue();
/* 393 */       if ((data != null) && (data.length() > 0))
/*     */       {
/* 395 */         this.out.print(' ');
/* 396 */         this.out.print(data);
/*     */       }
/* 398 */       this.out.print("?>");
/* 399 */       break;
/*     */     case 8:
/* 405 */       for (int i = 0; i < this.prettyIndent; i++)
/*     */       {
/* 407 */         this.out.print(' ');
/*     */       }
/*     */ 
/* 410 */       this.out.print("<!--");
/* 411 */       String data = node.getNodeValue();
/* 412 */       if (data != null)
/*     */       {
/* 414 */         this.out.print(data);
/*     */       }
/* 416 */       this.out.print("-->");
/*     */ 
/* 418 */       if (!this.prettyprint)
/*     */         break;
/* 420 */       this.out.print('\n'); break;
/*     */     case 2:
/*     */     case 6:
/*     */     }
/*     */ 
/* 427 */     if (type == 1)
/*     */     {
/* 429 */       if (this.prettyprint) {
/* 430 */         this.prettyIndent -= 1;
/*     */       }
/* 432 */       if (!hasChildNodes)
/*     */       {
/* 434 */         this.out.print("/>");
/*     */       }
/*     */       else
/*     */       {
/* 438 */         if (indentEndMarker)
/*     */         {
/* 440 */           for (int i = 0; i < this.prettyIndent; i++)
/*     */           {
/* 442 */             this.out.print(' ');
/*     */           }
/*     */         }
/*     */ 
/* 446 */         this.out.print("</");
/* 447 */         this.out.print(nodeName);
/* 448 */         this.out.print('>');
/*     */       }
/*     */ 
/* 451 */       if (this.prettyIndent > 0)
/*     */       {
/* 453 */         this.out.print('\n');
/*     */       }
/*     */     }
/* 456 */     this.out.flush();
/*     */   }
/*     */ 
/*     */   private String getNamespaceURI(String prefix, Element element, Node stopNode)
/*     */   {
/* 461 */     Node parent = element.getParentNode();
/* 462 */     String nsURI = element.getAttribute("xmlns:" + prefix);
/* 463 */     if ((nsURI.length() == 0) && (element != stopNode) && ((parent instanceof Element))) {
/* 464 */       return getNamespaceURI(prefix, (Element)parent, stopNode);
/*     */     }
/* 466 */     return nsURI.length() > 0 ? nsURI : null;
/*     */   }
/*     */ 
/*     */   private boolean isEndMarkerIndented(Node node)
/*     */   {
/* 471 */     if (this.prettyprint)
/*     */     {
/* 473 */       NodeList childNodes = node.getChildNodes();
/* 474 */       int len = childNodes.getLength();
/* 475 */       for (int i = 0; i < len; i++)
/*     */       {
/* 477 */         Node children = childNodes.item(i);
/* 478 */         if (children.getNodeType() == 1)
/*     */         {
/* 480 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 484 */     return false;
/*     */   }
/*     */ 
/*     */   private Attr[] sortAttributes(NamedNodeMap attrs)
/*     */   {
/* 491 */     int len = attrs != null ? attrs.getLength() : 0;
/* 492 */     Attr[] array = new Attr[len];
/* 493 */     for (int i = 0; i < len; i++)
/*     */     {
/* 495 */       array[i] = ((Attr)attrs.item(i));
/*     */     }
/* 497 */     for (int i = 0; i < len - 1; i++)
/*     */     {
/* 499 */       String name = array[i].getNodeName();
/* 500 */       int index = i;
/* 501 */       for (int j = i + 1; j < len; j++)
/*     */       {
/* 503 */         String curName = array[j].getNodeName();
/* 504 */         if (curName.compareTo(name) >= 0)
/*     */           continue;
/* 506 */         name = curName;
/* 507 */         index = j;
/*     */       }
/*     */ 
/* 510 */       if (index == i)
/*     */         continue;
/* 512 */       Attr temp = array[i];
/* 513 */       array[i] = array[index];
/* 514 */       array[index] = temp;
/*     */     }
/*     */ 
/* 517 */     return array;
/*     */   }
/*     */ 
/*     */   public static String normalize(String s, boolean canonical)
/*     */   {
/* 523 */     StringBuffer str = new StringBuffer();
/*     */ 
/* 525 */     int len = s != null ? s.length() : 0;
/* 526 */     for (int i = 0; i < len; i++)
/*     */     {
/* 528 */       char ch = s.charAt(i);
/* 529 */       switch (ch)
/*     */       {
/*     */       case '<':
/* 533 */         str.append("&lt;");
/* 534 */         break;
/*     */       case '>':
/* 538 */         str.append("&gt;");
/* 539 */         break;
/*     */       case '&':
/* 543 */         str.append("&amp;");
/* 544 */         break;
/*     */       case '"':
/* 548 */         str.append("&quot;");
/* 549 */         break;
/*     */       case '\n':
/*     */       case '\r':
/* 554 */         if (!canonical)
/*     */           break;
/* 556 */         str.append("&#");
/* 557 */         str.append(Integer.toString(ch));
/* 558 */         str.append(';');
/* 559 */         break;
/*     */       }
/*     */ 
/* 565 */       str.append(ch);
/*     */     }
/*     */ 
/* 569 */     return str.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.DOMWriter
 * JD-Core Version:    0.6.0
 */