/*     */ package org.jboss.util.xml;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.xml.catalog.CatalogManager;
/*     */ import org.jboss.util.xml.catalog.Resolver;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class CatalogLocation
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(CatalogLocation.class);
/*     */ 
/*  55 */   private static final String[] catalogFilesNames = { "META-INF/jax-ws-catalog.xml", "WEB-INF/jax-ws-catalog.xml", "jax-ws-catalog.xml" };
/*     */   private final Resolver catologResolver;
/*     */   private final URL location;
/*  62 */   private boolean isLastEntityResolved = false;
/*     */ 
/*     */   public CatalogLocation(URL url)
/*     */     throws IOException
/*     */   {
/*  83 */     this.catologResolver = new Resolver();
/*  84 */     this.catologResolver.setCatalogManager(CatalogManager.getStaticManager());
/*  85 */     this.catologResolver.setupReaders();
/*  86 */     this.catologResolver.parseCatalog(url);
/*  87 */     this.location = url;
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId)
/*     */     throws MalformedURLException, IOException
/*     */   {
/* 101 */     String resolvedURI = this.catologResolver.resolveSystem(systemId);
/*     */ 
/* 103 */     if (resolvedURI == null)
/*     */     {
/* 105 */       resolvedURI = this.catologResolver.resolvePublic(publicId, systemId);
/*     */     }
/*     */ 
/* 108 */     if (resolvedURI != null)
/*     */     {
/* 110 */       InputSource is = new InputSource();
/* 111 */       is.setPublicId(publicId);
/* 112 */       is.setSystemId(systemId);
/* 113 */       is.setByteStream(loadResource(resolvedURI));
/* 114 */       this.isLastEntityResolved = true;
/* 115 */       return is;
/*     */     }
/*     */ 
/* 120 */     this.isLastEntityResolved = false;
/* 121 */     return null;
/*     */   }
/*     */ 
/*     */   public static URL lookupCatalogFiles()
/*     */     throws IOException
/*     */   {
/* 135 */     URL url = null;
/*     */ 
/* 138 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 140 */     for (int i = 0; i < catalogFilesNames.length; i++)
/*     */     {
/* 142 */       url = loader.getResource(catalogFilesNames[i]);
/*     */ 
/* 144 */       if (url != null)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 150 */     return url;
/*     */   }
/*     */ 
/*     */   public boolean isEntityResolved()
/*     */   {
/* 161 */     return this.isLastEntityResolved;
/*     */   }
/*     */ 
/*     */   private InputStream loadResource(String resolvedURI)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 176 */       URI toLoad = new URI(resolvedURI);
/* 177 */       InputStream inputStream = null;
/* 178 */       if (toLoad != null)
/*     */       {
/*     */         try
/*     */         {
/* 182 */           inputStream = new FileInputStream(new File(toLoad));
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 186 */           log.error("Failed to open url stream", e);
/* 187 */           throw e;
/*     */         }
/*     */       }
/* 190 */       return inputStream;
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 194 */       log.error("The URI (" + resolvedURI + ") is malfomed");
/* 195 */     }throw new IOException("The URI (" + resolvedURI + ") is malfomed");
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 206 */     boolean back = false;
/* 207 */     if ((other != null) && ((other instanceof CatalogLocation))) {
/* 208 */       CatalogLocation otherC = (CatalogLocation)other;
/* 209 */       back = this.location.equals(otherC.location);
/*     */     }
/*     */ 
/* 212 */     return back;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 221 */     return this.location.hashCode();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  68 */     System.setProperty("xml.catalog.allowPI", "true");
/*     */ 
/*  70 */     System.setProperty("xml.catalog.prefer", "public");
/*     */ 
/*  73 */     System.setProperty("xml.catalog.verbosity", "0");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.xml.CatalogLocation
 * JD-Core Version:    0.6.0
 */