/*     */ package org.jboss.util.threadpool;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class RunnableTaskWrapper
/*     */   implements TaskWrapper
/*     */ {
/*  37 */   private static final Logger log = Logger.getLogger(RunnableTaskWrapper.class);
/*     */   private Runnable runnable;
/*     */   private boolean started;
/*     */   private Thread runThread;
/*     */   private long startTimeout;
/*     */   private long completionTimeout;
/*     */ 
/*     */   public RunnableTaskWrapper(Runnable runnable)
/*     */   {
/*  62 */     this(runnable, 0L, 0L);
/*     */   }
/*     */ 
/*     */   public RunnableTaskWrapper(Runnable runnable, long startTimeout, long completeTimeout) {
/*  66 */     if (runnable == null)
/*  67 */       throw new IllegalArgumentException("Null runnable");
/*  68 */     this.runnable = runnable;
/*  69 */     this.startTimeout = startTimeout;
/*  70 */     this.completionTimeout = completeTimeout;
/*     */   }
/*     */ 
/*     */   public int getTaskWaitType()
/*     */   {
/*  79 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getTaskPriority()
/*     */   {
/*  84 */     return 5;
/*     */   }
/*     */ 
/*     */   public long getTaskStartTimeout()
/*     */   {
/*  89 */     return this.startTimeout;
/*     */   }
/*     */ 
/*     */   public long getTaskCompletionTimeout()
/*     */   {
/*  94 */     return this.completionTimeout;
/*     */   }
/*     */ 
/*     */   public void acceptTask()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void rejectTask(RuntimeException t)
/*     */   {
/* 104 */     throw t;
/*     */   }
/*     */ 
/*     */   public void stopTask()
/*     */   {
/* 109 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 111 */     if ((this.runThread != null) && (!this.runThread.isInterrupted()))
/*     */     {
/* 113 */       this.runThread.interrupt();
/* 114 */       if (trace)
/* 115 */         log.trace("stopTask, interrupted thread=" + this.runThread);
/*     */     }
/* 117 */     else if (this.runThread != null)
/*     */     {
/* 122 */       this.runThread.stop();
/* 123 */       if (trace)
/* 124 */         log.trace("stopTask, stopped thread=" + this.runThread);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void waitForTask()
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isComplete()
/*     */   {
/* 135 */     return (this.started == true) && (this.runThread == null);
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 141 */     boolean trace = log.isTraceEnabled();
/*     */     try
/*     */     {
/* 144 */       if (trace)
/* 145 */         log.trace("Begin run, wrapper=" + this);
/* 146 */       this.runThread = Thread.currentThread();
/* 147 */       this.started = true;
/* 148 */       this.runnable.run();
/* 149 */       this.runThread = null;
/* 150 */       if (trace)
/* 151 */         log.trace("End run, wrapper=" + this);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 155 */       log.warn("Unhandled throwable for runnable: " + this.runnable, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.threadpool.RunnableTaskWrapper
 * JD-Core Version:    0.6.0
 */