/*     */ package org.jboss.util.threadpool;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BasicTaskWrapper
/*     */   implements TaskWrapper
/*     */ {
/*  35 */   private static final Logger log = Logger.getLogger(BasicTaskWrapper.class);
/*     */   public static final int TASK_NOT_ACCEPTED = 0;
/*     */   public static final int TASK_ACCEPTED = 1;
/*     */   public static final int TASK_STARTED = 2;
/*     */   public static final int TASK_COMPLETED = 3;
/*     */   public static final int TASK_REJECTED = -1;
/*     */   public static final int TASK_STOPPED = -2;
/*  56 */   private int state = 0;
/*     */ 
/*  59 */   private Object stateLock = new Object();
/*     */   private Task task;
/*     */   private String taskString;
/*     */   private long startTime;
/*     */   private long startTimeout;
/*     */   private long completionTimeout;
/*     */   private int priority;
/*     */   private int waitType;
/*     */   private Thread runThread;
/*     */ 
/*     */   protected BasicTaskWrapper()
/*     */   {
/*     */   }
/*     */ 
/*     */   public BasicTaskWrapper(Task task)
/*     */   {
/* 100 */     setTask(task);
/*     */   }
/*     */ 
/*     */   public int getTaskWaitType()
/*     */   {
/* 105 */     return this.waitType;
/*     */   }
/*     */ 
/*     */   public int getTaskPriority()
/*     */   {
/* 110 */     return this.priority;
/*     */   }
/*     */ 
/*     */   public long getTaskStartTimeout()
/*     */   {
/* 115 */     return this.startTimeout;
/*     */   }
/*     */ 
/*     */   public long getTaskCompletionTimeout()
/*     */   {
/* 120 */     return this.completionTimeout;
/*     */   }
/*     */ 
/*     */   public void acceptTask()
/*     */   {
/* 125 */     synchronized (this.stateLock)
/*     */     {
/* 128 */       if (this.state != 0) {
/* 129 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 133 */     if (taskAccepted())
/* 134 */       this.state = 1;
/*     */     else {
/* 136 */       this.state = -1;
/*     */     }
/*     */ 
/* 139 */     synchronized (this.stateLock)
/*     */     {
/* 141 */       this.stateLock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rejectTask(RuntimeException e)
/*     */   {
/* 147 */     synchronized (this.stateLock)
/*     */     {
/* 149 */       this.state = -1;
/* 150 */       this.stateLock.notifyAll();
/*     */     }
/* 152 */     taskRejected(e);
/*     */   }
/*     */ 
/*     */   public boolean isComplete()
/*     */   {
/* 157 */     return this.state == 3;
/*     */   }
/*     */ 
/*     */   public void stopTask()
/*     */   {
/*     */     boolean started;
/* 163 */     synchronized (this.stateLock)
/*     */     {
/* 165 */       started = this.state == 2;
/* 166 */       this.state = -2;
/*     */     }
/* 168 */     if (started)
/*     */     {
/* 171 */       if (this.runThread != null)
/*     */       {
/* 173 */         this.runThread.interrupt();
/*     */       }
/* 175 */       taskStop();
/*     */     }
/* 177 */     else if ((this.runThread != null) && (this.runThread.isInterrupted()))
/*     */     {
/* 182 */       this.runThread.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void waitForTask()
/*     */   {
/* 188 */     switch (this.waitType)
/*     */     {
/*     */     case 1:
/* 192 */       boolean interrupted = false;
/* 193 */       synchronized (this.stateLock)
/*     */       {
/* 195 */         while ((this.state == 0) || (this.state == 1))
/*     */         {
/*     */           try
/*     */           {
/* 199 */             this.stateLock.wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 203 */             interrupted = true;
/*     */           }
/*     */         }
/* 206 */         if (interrupted)
/* 207 */           Thread.currentThread().interrupt();
/* 208 */         return;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 224 */     this.runThread = Thread.currentThread();
/*     */ 
/* 227 */     long runTime = getElapsedTime();
/* 228 */     if ((this.startTimeout > 0L) && (runTime >= this.startTimeout))
/*     */     {
/* 230 */       taskRejected(new StartTimeoutException("Start Timeout exceeded for task " + this.taskString));
/* 231 */       return;
/*     */     }
/*     */ 
/* 235 */     boolean stopped = false;
/* 236 */     synchronized (this.stateLock)
/*     */     {
/* 238 */       if (this.state == -2)
/*     */       {
/* 240 */         stopped = true;
/*     */       }
/*     */       else
/*     */       {
/* 244 */         this.state = 2;
/* 245 */         taskStarted();
/* 246 */         if (this.waitType == 1)
/* 247 */           this.stateLock.notifyAll();
/*     */       }
/*     */     }
/* 250 */     if (stopped)
/*     */     {
/* 252 */       taskRejected(new TaskStoppedException("Task stopped for task " + this.taskString));
/* 253 */       return;
/*     */     }
/*     */ 
/* 257 */     Throwable throwable = null;
/*     */     try
/*     */     {
/* 260 */       this.task.execute();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 264 */       throwable = t;
/*     */     }
/*     */ 
/* 268 */     taskCompleted(throwable);
/*     */ 
/* 271 */     synchronized (this.stateLock)
/*     */     {
/* 273 */       this.state = 3;
/* 274 */       if (this.waitType == 2)
/* 275 */         this.stateLock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setTask(Task task)
/*     */   {
/* 286 */     if (task == null)
/* 287 */       throw new IllegalArgumentException("Null task");
/* 288 */     this.task = task;
/* 289 */     this.taskString = task.toString();
/* 290 */     this.startTime = System.currentTimeMillis();
/* 291 */     this.waitType = task.getWaitType();
/* 292 */     this.priority = task.getPriority();
/* 293 */     this.startTimeout = task.getStartTimeout();
/* 294 */     this.completionTimeout = task.getCompletionTimeout();
/*     */   }
/*     */ 
/*     */   protected boolean taskAccepted()
/*     */   {
/*     */     try
/*     */     {
/* 306 */       this.task.accepted(getElapsedTime());
/* 307 */       return true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 311 */       log.warn("Unexpected error during 'accepted' for task: " + this.taskString, t);
/* 312 */     }return false;
/*     */   }
/*     */ 
/*     */   protected boolean taskRejected(RuntimeException e)
/*     */   {
/*     */     try
/*     */     {
/* 326 */       this.task.rejected(getElapsedTime(), e);
/* 327 */       return true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 331 */       log.warn("Unexpected error during 'rejected' for task: " + this.taskString, t);
/* 332 */       if (e != null)
/* 333 */         log.warn("Original reason for rejection of task: " + this.taskString, e); 
/*     */     }
/* 334 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean taskStarted()
/*     */   {
/*     */     try
/*     */     {
/* 347 */       this.task.started(getElapsedTime());
/* 348 */       return true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 352 */       log.warn("Unexpected error during 'started' for task: " + this.taskString, t);
/* 353 */     }return false;
/*     */   }
/*     */ 
/*     */   protected boolean taskCompleted(Throwable throwable)
/*     */   {
/*     */     try
/*     */     {
/* 367 */       this.task.completed(getElapsedTime(), throwable);
/* 368 */       return true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 372 */       log.warn("Unexpected error during 'completed' for task: " + this.taskString, t);
/* 373 */       if (throwable != null)
/* 374 */         log.warn("Original error during 'run' for task: " + this.taskString, throwable); 
/*     */     }
/* 375 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean taskStop()
/*     */   {
/*     */     try
/*     */     {
/* 388 */       this.task.stop();
/* 389 */       return true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 393 */       log.warn("Unexpected error during 'stop' for task: " + this.taskString, t);
/* 394 */     }return false;
/*     */   }
/*     */ 
/*     */   protected long getElapsedTime()
/*     */   {
/* 405 */     return System.currentTimeMillis() - this.startTime;
/*     */   }
/*     */ 
/*     */   protected String getStateString()
/*     */   {
/* 415 */     switch (this.state)
/*     */     {
/*     */     case 0:
/* 418 */       return "NOT_ACCEPTED";
/*     */     case -1:
/* 420 */       return "REJECTED";
/*     */     case 1:
/* 422 */       return "ACCEPTED";
/*     */     case 2:
/* 424 */       return "STARTED";
/*     */     case -2:
/* 426 */       return "STOPPED";
/*     */     case 3:
/* 428 */       return "COMPLETED";
/*     */     }
/* 430 */     return "???";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.threadpool.BasicTaskWrapper
 * JD-Core Version:    0.6.0
 */