/*    */ package org.jboss.util.stream;
/*    */ 
/*    */ import java.io.BufferedOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.OutputStream;
/*    */ 
/*    */ public class NotifyingBufferedOutputStream extends BufferedOutputStream
/*    */ {
/*    */   int chunkSize;
/* 45 */   int chunk = 0;
/*    */   StreamListener listener;
/*    */ 
/*    */   public NotifyingBufferedOutputStream(OutputStream os, int size, int chunkSize, StreamListener listener)
/*    */   {
/* 63 */     super(os, size);
/* 64 */     if (chunkSize <= size)
/* 65 */       throw new IllegalArgumentException("chunkSize must be bigger than the buffer");
/* 66 */     this.chunkSize = chunkSize;
/* 67 */     this.listener = listener;
/*    */   }
/*    */ 
/*    */   public void setStreamListener(StreamListener listener)
/*    */   {
/* 72 */     this.listener = listener;
/*    */   }
/*    */ 
/*    */   public void write(int b)
/*    */     throws IOException
/*    */   {
/* 78 */     super.write(b);
/* 79 */     checkNotification(1);
/*    */   }
/*    */ 
/*    */   public void write(byte[] b, int off, int len)
/*    */     throws IOException
/*    */   {
/* 85 */     super.write(b, off, len);
/* 86 */     checkNotification(len);
/*    */   }
/*    */ 
/*    */   public void checkNotification(int result)
/*    */   {
/* 98 */     this.chunk += result;
/* 99 */     if (this.chunk >= this.chunkSize)
/*    */     {
/* 101 */       if (this.listener != null) {
/* 102 */         this.listener.onStreamNotification(this, this.chunk);
/*    */       }
/*    */ 
/* 105 */       this.chunk = 0;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.stream.NotifyingBufferedOutputStream
 * JD-Core Version:    0.6.0
 */