/*     */ package org.jboss.util.stream;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ 
/*     */ public class NotifyingBufferedInputStream extends BufferedInputStream
/*     */ {
/*     */   int chunkSize;
/*  45 */   int chunk = 0;
/*     */   StreamListener listener;
/*     */ 
/*     */   public NotifyingBufferedInputStream(InputStream is, int size, int chunkSize, StreamListener listener)
/*     */   {
/*  64 */     super(is, size);
/*  65 */     if (chunkSize <= size)
/*  66 */       throw new IllegalArgumentException("chunkSize must be bigger than the buffer");
/*  67 */     this.chunkSize = chunkSize;
/*  68 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public void setStreamListener(StreamListener listener)
/*     */   {
/*  73 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException
/*     */   {
/*  79 */     int result = super.read();
/*  80 */     if (result == -1)
/*  81 */       return result;
/*  82 */     checkNotification(result);
/*  83 */     return result;
/*     */   }
/*     */ 
/*     */   public int read(byte[] b, int off, int len)
/*     */     throws IOException
/*     */   {
/*  89 */     int result = super.read(b, off, len);
/*  90 */     if (result == -1)
/*  91 */       return result;
/*  92 */     checkNotification(result);
/*  93 */     return result;
/*     */   }
/*     */ 
/*     */   public void checkNotification(int result)
/*     */   {
/* 105 */     this.chunk += result;
/* 106 */     if (this.chunk >= this.chunkSize)
/*     */     {
/* 108 */       if (this.listener != null) {
/* 109 */         this.listener.onStreamNotification(this, this.chunk);
/*     */       }
/*     */ 
/* 112 */       this.chunk = 0;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.stream.NotifyingBufferedInputStream
 * JD-Core Version:    0.6.0
 */