/*     */ package org.jboss.util.state.xml;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.state.State;
/*     */ import org.jboss.util.state.StateMachine;
/*     */ import org.jboss.util.state.Transition;
/*     */ import org.jboss.util.xml.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class StateMachineParser
/*     */ {
/*  76 */   private static Logger log = Logger.getLogger(StateMachineParser.class);
/*     */ 
/*     */   public StateMachine parse(URL source)
/*     */     throws Exception
/*     */   {
/*  84 */     InputStream in = source.openConnection().getInputStream();
/*  85 */     Element root = DOMUtils.parse(in);
/*     */ 
/*  87 */     String description = root.getAttribute("description");
/*  88 */     HashMap nameToStateMap = new HashMap();
/*  89 */     HashMap nameToTransitionsMap = new HashMap();
/*  90 */     HashSet states = new HashSet();
/*  91 */     State startState = null;
/*     */ 
/*  94 */     NodeList stateList = root.getChildNodes();
/*  95 */     for (int i = 0; i < stateList.getLength(); i++)
/*     */     {
/*  97 */       Node stateNode = stateList.item(i);
/*  98 */       if (!stateNode.getNodeName().equals("state"))
/*     */         continue;
/* 100 */       Element stateElement = (Element)stateNode;
/* 101 */       String stateName = stateElement.getAttribute("name");
/* 102 */       State s = new State(stateName);
/* 103 */       states.add(s);
/* 104 */       nameToStateMap.put(stateName, s);
/* 105 */       HashMap transitions = new HashMap();
/*     */ 
/* 108 */       NodeList transitionList = stateElement.getChildNodes();
/* 109 */       for (int j = 0; j < transitionList.getLength(); j++)
/*     */       {
/* 111 */         Node transitionNode = transitionList.item(j);
/* 112 */         if (!transitionNode.getNodeName().equals("transition"))
/*     */           continue;
/* 114 */         Element transitionElement = (Element)transitionNode;
/* 115 */         String name = transitionElement.getAttribute("name");
/* 116 */         String targetName = transitionElement.getAttribute("target");
/* 117 */         transitions.put(name, targetName);
/*     */       }
/*     */ 
/* 120 */       nameToTransitionsMap.put(stateName, transitions);
/* 121 */       if (Boolean.valueOf(stateElement.getAttribute("isStartState")) == Boolean.TRUE) {
/* 122 */         startState = s;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 127 */     Iterator transitions = nameToTransitionsMap.keySet().iterator();
/* 128 */     StringBuffer resolveFailed = new StringBuffer();
/* 129 */     while (transitions.hasNext())
/*     */     {
/* 131 */       String stateName = (String)transitions.next();
/* 132 */       State s = (State)nameToStateMap.get(stateName);
/* 133 */       HashMap stateTransitions = (HashMap)nameToTransitionsMap.get(stateName);
/* 134 */       Iterator it = stateTransitions.keySet().iterator();
/* 135 */       while (it.hasNext())
/*     */       {
/* 137 */         String name = (String)it.next();
/* 138 */         String targetName = (String)stateTransitions.get(name);
/* 139 */         State target = (State)nameToStateMap.get(targetName);
/* 140 */         if (target == null)
/*     */         {
/* 142 */           String msg = "Failed to resolve target state: " + targetName + " for transition: " + name;
/* 143 */           resolveFailed.append(msg);
/* 144 */           log.debug(msg);
/*     */         }
/* 146 */         Transition t = new Transition(name, target);
/* 147 */         s.addTransition(t);
/*     */       }
/*     */     }
/*     */ 
/* 151 */     if (resolveFailed.length() > 0) {
/* 152 */       throw new Exception("Failed to resolve transition targets: " + resolveFailed);
/*     */     }
/* 154 */     StateMachine sm = new StateMachine(states, startState, description);
/* 155 */     return sm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.state.xml.StateMachineParser
 * JD-Core Version:    0.6.0
 */