/*     */ package org.jboss.util.state;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class StateMachine
/*     */   implements Cloneable
/*     */ {
/*  36 */   private static Logger log = Logger.getLogger(StateMachine.class);
/*     */   private String description;
/*     */   private HashSet states;
/*     */   private State startState;
/*     */   private State currentState;
/*     */ 
/*     */   public StateMachine(Set states, State startState)
/*     */   {
/*  53 */     this(states, startState, null);
/*     */   }
/*     */ 
/*     */   public StateMachine(Set states, State startState, String description)
/*     */   {
/*  63 */     this.states = new HashSet(states);
/*  64 */     this.startState = startState;
/*  65 */     this.currentState = startState;
/*  66 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*  75 */     StateMachine clone = new StateMachine(this.states, this.startState, this.description);
/*  76 */     clone.currentState = this.currentState;
/*  77 */     return clone;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/*  85 */     return this.description;
/*     */   }
/*     */ 
/*     */   public State getCurrentState()
/*     */   {
/*  93 */     return this.currentState;
/*     */   }
/*     */ 
/*     */   public State getStartState()
/*     */   {
/* 101 */     return this.startState;
/*     */   }
/*     */ 
/*     */   public Set getStates()
/*     */   {
/* 109 */     return this.states;
/*     */   }
/*     */ 
/*     */   public State nextState(String actionName)
/*     */     throws IllegalTransitionException
/*     */   {
/* 121 */     Transition t = this.currentState.getTransition(actionName);
/* 122 */     if (t == null)
/*     */     {
/* 124 */       String msg = "No transition for action: '" + actionName + "' from state: '" + this.currentState.getName() + "'";
/*     */ 
/* 126 */       throw new IllegalTransitionException(msg);
/*     */     }
/* 128 */     State nextState = t.getTarget();
/* 129 */     log.trace("nextState(" + actionName + ") = " + nextState);
/* 130 */     this.currentState = nextState;
/* 131 */     return this.currentState;
/*     */   }
/*     */ 
/*     */   public State reset()
/*     */   {
/* 140 */     this.currentState = this.startState;
/* 141 */     return this.currentState;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 146 */     StringBuffer tmp = new StringBuffer("StateMachine[:\n");
/* 147 */     tmp.append("\tCurrentState: " + this.currentState.getName());
/* 148 */     Iterator i = this.states.iterator();
/* 149 */     while (i.hasNext())
/*     */     {
/* 151 */       tmp.append('\n').append(i.next());
/*     */     }
/* 153 */     tmp.append(']');
/* 154 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.state.StateMachine
 * JD-Core Version:    0.6.0
 */