/*     */ package org.jboss.util.state;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class State
/*     */ {
/*     */   private String name;
/*  38 */   private HashMap allowedTransitions = new HashMap();
/*     */   private Object data;
/*     */ 
/*     */   public State(String name)
/*     */   {
/*  44 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public State(String name, Map transitions) {
/*  48 */     this.name = name;
/*  49 */     if (transitions != null)
/*     */     {
/*  51 */       this.allowedTransitions.putAll(transitions);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  60 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Object getData()
/*     */   {
/*  65 */     return this.data;
/*     */   }
/*     */ 
/*     */   public void setData(Object data) {
/*  69 */     this.data = data;
/*     */   }
/*     */ 
/*     */   public boolean isAcceptState()
/*     */   {
/*  77 */     return this.allowedTransitions.size() == 0;
/*     */   }
/*     */ 
/*     */   public State addTransition(Transition transition)
/*     */   {
/*  87 */     this.allowedTransitions.put(transition.getName(), transition);
/*  88 */     return this;
/*     */   }
/*     */ 
/*     */   public Transition getTransition(String name)
/*     */   {
/*  98 */     Transition t = (Transition)this.allowedTransitions.get(name);
/*  99 */     return t;
/*     */   }
/*     */ 
/*     */   public Map getTransitions()
/*     */   {
/* 107 */     return this.allowedTransitions;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 112 */     StringBuffer tmp = new StringBuffer("State(name=");
/* 113 */     tmp.append(this.name);
/* 114 */     Iterator i = this.allowedTransitions.entrySet().iterator();
/* 115 */     while (i.hasNext())
/*     */     {
/* 117 */       Map.Entry e = (Map.Entry)i.next();
/* 118 */       tmp.append("\n\t on: ");
/* 119 */       tmp.append(e.getKey());
/* 120 */       Transition t = (Transition)e.getValue();
/* 121 */       tmp.append(" go to: ");
/* 122 */       tmp.append(t.getTarget().getName());
/*     */     }
/* 124 */     tmp.append(')');
/* 125 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.state.State
 * JD-Core Version:    0.6.0
 */