/*    */ package org.jboss.util.propertyeditor;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.IOException;
/*    */ import java.util.Iterator;
/*    */ import java.util.Properties;
/*    */ import java.util.Set;
/*    */ import org.jboss.util.NestedRuntimeException;
/*    */ import org.jboss.util.StringPropertyReplacer;
/*    */ 
/*    */ public class PropertiesEditor extends TextPropertyEditorSupport
/*    */ {
/*    */   public Object getValue()
/*    */   {
/*    */     try
/*    */     {
/* 55 */       String propsText = getAsText();
/* 56 */       Properties rawProps = new Properties(System.getProperties());
/* 57 */       ByteArrayInputStream bais = new ByteArrayInputStream(propsText.getBytes());
/* 58 */       rawProps.load(bais);
/*    */ 
/* 60 */       Properties props = new Properties();
/* 61 */       Iterator keys = rawProps.keySet().iterator();
/* 62 */       while (keys.hasNext())
/*    */       {
/* 64 */         String key = (String)keys.next();
/* 65 */         String value = rawProps.getProperty(key);
/* 66 */         String value2 = StringPropertyReplacer.replaceProperties(value, rawProps);
/* 67 */         props.setProperty(key, value2);
/*    */       }
/* 69 */       rawProps.clear();
/*    */ 
/* 71 */       return props;
/*    */     }
/*    */     catch (IOException e) {
/*    */     }
/* 75 */     throw new NestedRuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.propertyeditor.PropertiesEditor
 * JD-Core Version:    0.6.0
 */