/*    */ package org.jboss.util.propertyeditor;
/*    */ 
/*    */ import java.beans.PropertyEditorSupport;
/*    */ import java.io.IOException;
/*    */ import java.io.StringReader;
/*    */ import javax.xml.parsers.DocumentBuilder;
/*    */ import javax.xml.parsers.DocumentBuilderFactory;
/*    */ import javax.xml.parsers.ParserConfigurationException;
/*    */ import org.jboss.util.NestedRuntimeException;
/*    */ import org.jboss.util.xml.DOMWriter;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Node;
/*    */ import org.xml.sax.InputSource;
/*    */ import org.xml.sax.SAXException;
/*    */ 
/*    */ public class DocumentEditor extends PropertyEditorSupport
/*    */ {
/*    */   public String getAsText()
/*    */   {
/* 54 */     return DOMWriter.printNode((Node)getValue(), false);
/*    */   }
/*    */ 
/*    */   public void setAsText(String text)
/*    */   {
/* 64 */     setValue(getAsDocument(text));
/*    */   }
/*    */ 
/*    */   protected Document getAsDocument(String text)
/*    */   {
/*    */     try
/*    */     {
/* 71 */       DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
/* 72 */       DocumentBuilder db = dbf.newDocumentBuilder();
/* 73 */       StringReader sr = new StringReader(text);
/* 74 */       InputSource is = new InputSource(sr);
/* 75 */       Document d = db.parse(is);
/* 76 */       return d;
/*    */     }
/*    */     catch (ParserConfigurationException e)
/*    */     {
/* 80 */       throw new NestedRuntimeException(e);
/*    */     }
/*    */     catch (SAXException e)
/*    */     {
/* 84 */       throw new NestedRuntimeException(e);
/*    */     }
/*    */     catch (IOException e) {
/*    */     }
/* 88 */     throw new NestedRuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.propertyeditor.DocumentEditor
 * JD-Core Version:    0.6.0
 */