/*     */ package org.jboss.util.propertyeditor;
/*     */ 
/*     */ import java.beans.PropertyEditorSupport;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.text.DateFormat;
/*     */ import java.text.ParseException;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class DateEditor extends PropertyEditorSupport
/*     */ {
/*     */   private static DateFormat[] formats;
/*     */   private String text;
/*     */ 
/*     */   public static void initialize()
/*     */   {
/*  60 */     PrivilegedAction action = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  64 */         String defaultFormat = System.getProperty("org.jboss.util.propertyeditor.DateEditor.format", "MMM d, yyyy");
/*     */ 
/*  66 */         DateEditor.access$002(new DateFormat[] { new SimpleDateFormat(defaultFormat), new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z") });
/*     */ 
/*  74 */         return null;
/*     */       }
/*     */     };
/*  77 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   public void setValue(Object value)
/*     */   {
/*  90 */     if (((value instanceof Date)) || (value == null))
/*     */     {
/*  92 */       this.text = null;
/*  93 */       super.setValue(value);
/*     */     }
/*     */     else
/*     */     {
/*  97 */       throw new IllegalArgumentException("setValue() expected java.util.Date value, got " + value.getClass().getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAsText(String text)
/*     */   {
/* 110 */     ParseException pe = null;
/*     */ 
/* 112 */     for (int i = 0; i < formats.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 117 */         DateFormat df = formats[i];
/* 118 */         Date date = df.parse(text);
/*     */ 
/* 121 */         this.text = text;
/* 122 */         super.setValue(date);
/*     */ 
/* 125 */         return;
/*     */       }
/*     */       catch (ParseException e)
/*     */       {
/* 130 */         pe = e;
/*     */       }
/*     */     }
/*     */ 
/* 134 */     throw new NestedRuntimeException(pe);
/*     */   }
/*     */ 
/*     */   public String getAsText()
/*     */   {
/* 146 */     if (this.text == null)
/*     */     {
/* 148 */       DateFormat df = formats[(formats.length - 1)];
/* 149 */       Date date = (Date)getValue();
/* 150 */       this.text = df.format(date);
/*     */     }
/* 152 */     return this.text;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  50 */     initialize();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.propertyeditor.DateEditor
 * JD-Core Version:    0.6.0
 */