/*    */ package org.jboss.util.propertyeditor;
/*    */ 
/*    */ import java.beans.PropertyEditorSupport;
/*    */ import java.util.ArrayList;
/*    */ import java.util.StringTokenizer;
/*    */ 
/*    */ public class ClassArrayEditor extends PropertyEditorSupport
/*    */ {
/*    */   public void setAsText(String text)
/*    */     throws IllegalArgumentException
/*    */   {
/* 40 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 41 */     StringTokenizer tokenizer = new StringTokenizer(text, ", \t\r\n");
/* 42 */     ArrayList classes = new ArrayList();
/* 43 */     while (tokenizer.hasMoreTokens() == true)
/*    */     {
/* 45 */       String name = tokenizer.nextToken();
/*    */       try
/*    */       {
/* 48 */         Class c = loader.loadClass(name);
/* 49 */         classes.add(c);
/*    */       }
/*    */       catch (ClassNotFoundException e)
/*    */       {
/* 53 */         throw new IllegalArgumentException("Failed to find class: " + name);
/*    */       }
/*    */     }
/*    */ 
/* 57 */     Class[] theValue = new Class[classes.size()];
/* 58 */     classes.toArray(theValue);
/* 59 */     setValue(theValue);
/*    */   }
/*    */ 
/*    */   public String getAsText()
/*    */   {
/* 67 */     Class[] theValue = (Class[])(Class[])getValue();
/* 68 */     StringBuffer text = new StringBuffer();
/* 69 */     int length = theValue == null ? 0 : theValue.length;
/* 70 */     for (int n = 0; n < length; n++)
/*    */     {
/* 72 */       text.append(theValue[n].getName());
/* 73 */       text.append(',');
/*    */     }
/*    */ 
/* 76 */     text.setLength(text.length() - 1);
/* 77 */     return text.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.propertyeditor.ClassArrayEditor
 * JD-Core Version:    0.6.0
 */