/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.util.ThrowableHandler;
/*     */ 
/*     */ public final class PropertyManager
/*     */ {
/*     */   public static final String READER_PROPERTY_NAME = "org.jboss.util.property.reader";
/*     */   public static final String DEFAULT_PROPERTY_READER_TOKEN = "DEFAULT";
/*  50 */   private static final String[] DEFAULT_PROPERTY_READERS = { "DEFAULT" };
/*     */ 
/*  68 */   private static PropertyMap props = new PropertyMap();
/*     */ 
/*     */   public static PropertyMap getDefaultPropertyMap()
/*     */   {
/* 113 */     SecurityManager sm = System.getSecurityManager();
/* 114 */     if (sm != null)
/* 115 */       sm.checkPropertiesAccess();
/* 116 */     return props;
/*     */   }
/*     */ 
/*     */   public static void addPropertyListener(PropertyListener listener)
/*     */   {
/* 126 */     SecurityManager sm = System.getSecurityManager();
/* 127 */     if (sm != null)
/* 128 */       sm.checkPropertiesAccess();
/* 129 */     props.addPropertyListener(listener);
/*     */   }
/*     */ 
/*     */   public static void addPropertyListeners(PropertyListener[] listeners)
/*     */   {
/* 139 */     SecurityManager sm = System.getSecurityManager();
/* 140 */     if (sm != null)
/* 141 */       sm.checkPropertiesAccess();
/* 142 */     props.addPropertyListeners(listeners);
/*     */   }
/*     */ 
/*     */   public static boolean removePropertyListener(PropertyListener listener)
/*     */   {
/* 153 */     return props.removePropertyListener(listener);
/*     */   }
/*     */ 
/*     */   public static void load(String prefix, Map map)
/*     */     throws PropertyException
/*     */   {
/* 164 */     SecurityManager sm = System.getSecurityManager();
/* 165 */     if (sm != null)
/* 166 */       sm.checkPropertiesAccess();
/* 167 */     props.load(prefix, map);
/*     */   }
/*     */ 
/*     */   public static void load(Map map)
/*     */     throws PropertyException, IOException
/*     */   {
/* 177 */     SecurityManager sm = System.getSecurityManager();
/* 178 */     if (sm != null)
/* 179 */       sm.checkPropertiesAccess();
/* 180 */     props.load(map);
/*     */   }
/*     */ 
/*     */   public static void load(PropertyReader reader)
/*     */     throws PropertyException, IOException
/*     */   {
/* 190 */     SecurityManager sm = System.getSecurityManager();
/* 191 */     if (sm != null)
/* 192 */       sm.checkPropertiesAccess();
/* 193 */     props.load(reader);
/*     */   }
/*     */ 
/*     */   public static void load(String classname)
/*     */     throws PropertyException, IOException
/*     */   {
/* 205 */     SecurityManager sm = System.getSecurityManager();
/* 206 */     if (sm != null)
/* 207 */       sm.checkPropertiesAccess();
/* 208 */     props.load(classname);
/*     */   }
/*     */ 
/*     */   public static String setProperty(String name, String value)
/*     */   {
/* 220 */     SecurityManager sm = System.getSecurityManager();
/* 221 */     if (sm != null)
/* 222 */       sm.checkPropertyAccess(name);
/* 223 */     return (String)props.setProperty(name, value);
/*     */   }
/*     */ 
/*     */   public static String removeProperty(String name)
/*     */   {
/* 234 */     SecurityManager sm = System.getSecurityManager();
/* 235 */     if (sm != null)
/* 236 */       sm.checkPropertyAccess(name);
/* 237 */     return props.removeProperty(name);
/*     */   }
/*     */ 
/*     */   public static String getProperty(String name, String defaultValue)
/*     */   {
/* 249 */     SecurityManager sm = System.getSecurityManager();
/* 250 */     if (sm != null)
/* 251 */       sm.checkPropertyAccess(name);
/* 252 */     return props.getProperty(name, defaultValue);
/*     */   }
/*     */ 
/*     */   public static String getProperty(String name)
/*     */   {
/* 263 */     SecurityManager sm = System.getSecurityManager();
/* 264 */     if (sm != null)
/* 265 */       sm.checkPropertyAccess(name);
/* 266 */     return props.getProperty(name);
/*     */   }
/*     */ 
/*     */   public static String[] getArrayProperty(String base, String[] defaultValues)
/*     */   {
/* 278 */     SecurityManager sm = System.getSecurityManager();
/* 279 */     if (sm != null)
/* 280 */       sm.checkPropertiesAccess();
/* 281 */     return props.getArrayProperty(base, defaultValues);
/*     */   }
/*     */ 
/*     */   public static String[] getArrayProperty(String name)
/*     */   {
/* 292 */     SecurityManager sm = System.getSecurityManager();
/* 293 */     if (sm != null)
/* 294 */       sm.checkPropertyAccess(name);
/* 295 */     return props.getArrayProperty(name);
/*     */   }
/*     */ 
/*     */   public static Iterator names()
/*     */   {
/* 305 */     SecurityManager sm = System.getSecurityManager();
/* 306 */     if (sm != null)
/* 307 */       sm.checkPropertiesAccess();
/* 308 */     return props.names();
/*     */   }
/*     */ 
/*     */   public static boolean containsProperty(String name)
/*     */   {
/* 319 */     SecurityManager sm = System.getSecurityManager();
/* 320 */     if (sm != null)
/* 321 */       sm.checkPropertyAccess(name);
/* 322 */     return props.containsProperty(name);
/*     */   }
/*     */ 
/*     */   public static PropertyGroup getPropertyGroup(String basename)
/*     */   {
/* 333 */     SecurityManager sm = System.getSecurityManager();
/* 334 */     if (sm != null)
/* 335 */       sm.checkPropertiesAccess();
/* 336 */     return props.getPropertyGroup(basename);
/*     */   }
/*     */ 
/*     */   public static PropertyGroup getPropertyGroup(String basename, int index)
/*     */   {
/* 348 */     SecurityManager sm = System.getSecurityManager();
/* 349 */     if (sm != null)
/* 350 */       sm.checkPropertiesAccess();
/* 351 */     return props.getPropertyGroup(basename, index);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  69 */     PrivilegedAction action = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  73 */         PropertyManager.props.putAll(System.getProperties());
/*     */ 
/*  76 */         System.setProperties(PropertyManager.props);
/*     */ 
/*  79 */         String[] readerNames = PropertyManager.getArrayProperty("org.jboss.util.property.reader", PropertyManager.DEFAULT_PROPERTY_READERS);
/*     */ 
/*  82 */         for (int i = 0; i < readerNames.length; i++)
/*     */         {
/*     */           try
/*     */           {
/*  86 */             if (readerNames[i].equals("DEFAULT"))
/*     */             {
/*  88 */               PropertyManager.load(new DefaultPropertyReader());
/*     */             }
/*     */             else
/*     */             {
/*  92 */               PropertyManager.load(readerNames[i]);
/*     */             }
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/*  97 */             ThrowableHandler.add(e);
/*     */           }
/*     */         }
/* 100 */         return null;
/*     */       }
/*     */     };
/* 103 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.PropertyManager
 * JD-Core Version:    0.6.0
 */