/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.util.AbstractSet;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.NoSuchElementException;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class PropertyGroup extends PropertyMap
/*     */ {
/*     */   private static final long serialVersionUID = -2557641199743063159L;
/*     */   protected final String basename;
/*     */ 
/*     */   public PropertyGroup(String basename, Properties container)
/*     */   {
/*  62 */     super(container);
/*     */ 
/*  64 */     if (basename == null) {
/*  65 */       throw new NullArgumentException("basename");
/*     */     }
/*  67 */     this.basename = basename;
/*     */   }
/*     */ 
/*     */   public final String getBaseName()
/*     */   {
/*  77 */     return this.basename;
/*     */   }
/*     */ 
/*     */   private String makePropertyName(String suffix)
/*     */   {
/*  87 */     return this.basename + "." + suffix;
/*     */   }
/*     */ 
/*     */   private String makePropertyName(Object suffix)
/*     */   {
/*  97 */     return makePropertyName(String.valueOf(suffix));
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object name)
/*     */   {
/* 108 */     if (name == null) {
/* 109 */       throw new NullArgumentException("name");
/*     */     }
/* 111 */     return super.containsKey(makePropertyName(name));
/*     */   }
/*     */ 
/*     */   public Object put(Object name, Object value)
/*     */   {
/* 123 */     if (name == null) {
/* 124 */       throw new NullArgumentException("name");
/*     */     }
/* 126 */     return super.put(makePropertyName(name), value);
/*     */   }
/*     */ 
/*     */   public Object get(Object name)
/*     */   {
/* 137 */     if (name == null) {
/* 138 */       throw new NullArgumentException("name");
/*     */     }
/* 140 */     return super.get(makePropertyName(name));
/*     */   }
/*     */ 
/*     */   public Object remove(Object name)
/*     */   {
/* 151 */     if (name == null) {
/* 152 */       throw new NullArgumentException("name");
/*     */     }
/* 154 */     return super.remove(makePropertyName(name));
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 166 */     Set superSet = super.entrySet(true);
/*     */ 
/* 168 */     return new AbstractSet(superSet)
/*     */     {
/*     */       private boolean isInGroup(Map.Entry entry)
/*     */       {
/* 172 */         String key = (String)entry.getKey();
/* 173 */         return key.startsWith(PropertyGroup.this.basename);
/*     */       }
/*     */ 
/*     */       public int size()
/*     */       {
/* 178 */         Iterator iter = this.val$superSet.iterator();
/* 179 */         int count = 0;
/* 180 */         while (iter.hasNext())
/*     */         {
/* 182 */           Map.Entry entry = (Map.Entry)iter.next();
/* 183 */           if (isInGroup(entry))
/*     */           {
/* 185 */             count++;
/*     */           }
/*     */         }
/*     */ 
/* 189 */         return count;
/*     */       }
/*     */ 
/*     */       public Iterator iterator()
/*     */       {
/* 194 */         return new Iterator()
/*     */         {
/* 196 */           private Iterator iter = PropertyGroup.1.this.val$superSet.iterator();
/*     */           private Object next;
/*     */ 
/*     */           public boolean hasNext() {
/* 202 */             if (this.next != null) {
/* 203 */               return true;
/*     */             }
/* 205 */             while (this.next == null)
/*     */             {
/* 207 */               if (!this.iter.hasNext())
/*     */                 break;
/* 209 */               Map.Entry entry = (Map.Entry)this.iter.next();
/* 210 */               if (PropertyGroup.1.this.isInGroup(entry))
/*     */               {
/* 212 */                 this.next = entry;
/* 213 */                 return true;
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/* 222 */             return false;
/*     */           }
/*     */ 
/*     */           public Object next()
/*     */           {
/* 227 */             if (this.next == null) {
/* 228 */               throw new NoSuchElementException();
/*     */             }
/* 230 */             Object obj = this.next;
/* 231 */             this.next = null;
/*     */ 
/* 233 */             return obj;
/*     */           }
/*     */ 
/*     */           public void remove()
/*     */           {
/* 238 */             this.iter.remove();
/*     */           }
/*     */         };
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   protected void addPropertyListener(BoundPropertyListener listener)
/*     */   {
/* 256 */     String name = makePropertyName(listener.getPropertyName());
/*     */ 
/* 259 */     List list = (List)this.boundListeners.get(name);
/*     */ 
/* 262 */     if (list == null)
/*     */     {
/* 264 */       list = new ArrayList();
/* 265 */       this.boundListeners.put(name, list);
/*     */     }
/*     */ 
/* 269 */     if (!list.contains(listener))
/*     */     {
/* 271 */       list.add(listener);
/*     */ 
/* 273 */       listener.propertyBound(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean removePropertyListener(BoundPropertyListener listener)
/*     */   {
/* 289 */     String name = makePropertyName(listener.getPropertyName());
/*     */ 
/* 292 */     List list = (List)this.boundListeners.get(name);
/* 293 */     boolean removed = false;
/* 294 */     if (list != null)
/*     */     {
/* 296 */       removed = list.remove(listener);
/*     */ 
/* 299 */       if (removed) {
/* 300 */         listener.propertyUnbound(this);
/*     */       }
/*     */     }
/* 303 */     return removed;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.PropertyGroup
 * JD-Core Version:    0.6.0
 */