/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.util.EventObject;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public class PropertyEvent extends EventObject
/*     */ {
/*     */   protected final String name;
/*     */   protected final String value;
/*     */ 
/*     */   public PropertyEvent(Object source, String name, String value)
/*     */   {
/*  56 */     super(source);
/*     */ 
/*  58 */     if (name == null) {
/*  59 */       throw new NullArgumentException("name");
/*     */     }
/*     */ 
/*  62 */     this.name = name;
/*  63 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public PropertyEvent(Object source, String name)
/*     */   {
/*  75 */     this(source, name, null);
/*     */   }
/*     */ 
/*     */   public final String getPropertyName()
/*     */   {
/*  84 */     return this.name;
/*     */   }
/*     */ 
/*     */   public final String getPropertyValue()
/*     */   {
/*  93 */     return this.value;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 102 */     return super.toString() + "{ name=" + this.name + ", value=" + this.value + " }";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.PropertyEvent
 * JD-Core Version:    0.6.0
 */