/*     */ package org.jboss.util.property;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.lang.reflect.Field;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.FieldInstance;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ import org.jboss.util.ThrowableHandler;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class FieldBoundPropertyListener extends BoundPropertyAdapter
/*     */ {
/*     */   protected final String propertyName;
/*     */   protected final FieldInstance fieldInstance;
/*     */ 
/*     */   public FieldBoundPropertyListener(Object instance, String fieldName, String propertyName)
/*     */   {
/*  60 */     if (propertyName == null) {
/*  61 */       throw new NullArgumentException("propertyName");
/*     */     }
/*     */ 
/*  64 */     this.propertyName = propertyName;
/*     */     try
/*     */     {
/*  68 */       this.fieldInstance = new FieldInstance(instance, fieldName);
/*     */       try {
/*  70 */         this.fieldInstance.getField().setAccessible(true);
/*     */       }
/*     */       catch (SecurityException e) {
/*  73 */         ThrowableHandler.add(e);
/*     */       }
/*     */ 
/*  78 */       Classes.forceLoad(this.fieldInstance.getField().getType());
/*     */     }
/*     */     catch (NoSuchFieldException e) {
/*  81 */       throw new PropertyException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public FieldBoundPropertyListener(Object instance, String fieldName)
/*     */   {
/*  96 */     this(instance, fieldName, fieldName);
/*     */   }
/*     */ 
/*     */   public final String getPropertyName()
/*     */   {
/* 105 */     return this.propertyName;
/*     */   }
/*     */ 
/*     */   public String filterValue(String value)
/*     */   {
/* 117 */     return value;
/*     */   }
/*     */ 
/*     */   protected void setFieldValue(String value)
/*     */   {
/*     */     try
/*     */     {
/* 130 */       value = filterValue(value);
/*     */ 
/* 133 */       Class type = this.fieldInstance.getField().getType();
/* 134 */       PropertyEditor editor = PropertyEditors.findEditor(type);
/* 135 */       editor.setAsText(value);
/* 136 */       Object coerced = editor.getValue();
/*     */ 
/* 139 */       this.fieldInstance.set(coerced);
/*     */     }
/*     */     catch (IllegalAccessException e) {
/* 142 */       throw new PropertyException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void propertyAdded(PropertyEvent event)
/*     */   {
/* 152 */     setFieldValue(event.getPropertyValue());
/*     */   }
/*     */ 
/*     */   public void propertyChanged(PropertyEvent event)
/*     */   {
/* 161 */     setFieldValue(event.getPropertyValue());
/*     */   }
/*     */ 
/*     */   public void propertyBound(PropertyMap map)
/*     */   {
/* 171 */     if (map.containsProperty(this.propertyName))
/* 172 */       setFieldValue(map.getProperty(this.propertyName));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.property.FieldBoundPropertyListener
 * JD-Core Version:    0.6.0
 */