/*     */ package org.jboss.util.naming;
/*     */ 
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.LinkRef;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Util
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(Util.class);
/*     */ 
/*     */   public static Context createSubcontext(Context ctx, String name)
/*     */     throws NamingException
/*     */   {
/*  51 */     Name n = ctx.getNameParser("").parse(name);
/*  52 */     return createSubcontext(ctx, n);
/*     */   }
/*     */ 
/*     */   public static Context createSubcontext(Context ctx, Name name)
/*     */     throws NamingException
/*     */   {
/*  63 */     Context subctx = ctx;
/*  64 */     for (int pos = 0; pos < name.size(); pos++)
/*     */     {
/*  66 */       String ctxName = name.get(pos);
/*     */       try
/*     */       {
/*  69 */         subctx = (Context)ctx.lookup(ctxName);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/*  73 */         subctx = ctx.createSubcontext(ctxName);
/*     */       }
/*     */ 
/*  76 */       ctx = subctx;
/*     */     }
/*  78 */     return subctx;
/*     */   }
/*     */ 
/*     */   public static void bind(Context ctx, String name, Object value)
/*     */     throws NamingException
/*     */   {
/*  88 */     Name n = ctx.getNameParser("").parse(name);
/*  89 */     bind(ctx, n, value);
/*     */   }
/*     */ 
/*     */   public static void bind(Context ctx, Name name, Object value)
/*     */     throws NamingException
/*     */   {
/*  99 */     int size = name.size();
/* 100 */     String atom = name.get(size - 1);
/* 101 */     Context parentCtx = createSubcontext(ctx, name.getPrefix(size - 1));
/* 102 */     parentCtx.bind(atom, value);
/*     */   }
/*     */ 
/*     */   public static void rebind(Context ctx, String name, Object value)
/*     */     throws NamingException
/*     */   {
/* 112 */     Name n = ctx.getNameParser("").parse(name);
/* 113 */     rebind(ctx, n, value);
/*     */   }
/*     */ 
/*     */   public static void rebind(Context ctx, Name name, Object value)
/*     */     throws NamingException
/*     */   {
/* 123 */     int size = name.size();
/* 124 */     String atom = name.get(size - 1);
/* 125 */     Context parentCtx = createSubcontext(ctx, name.getPrefix(size - 1));
/* 126 */     parentCtx.rebind(atom, value);
/*     */   }
/*     */ 
/*     */   public static void unbind(Context ctx, String name)
/*     */     throws NamingException
/*     */   {
/* 135 */     unbind(ctx, ctx.getNameParser("").parse(name));
/*     */   }
/*     */ 
/*     */   public static void unbind(Context ctx, Name name)
/*     */     throws NamingException
/*     */   {
/* 144 */     ctx.unbind(name);
/* 145 */     int sz = name.size();
/*     */     while (true) {
/* 147 */       sz--; if (sz <= 0)
/*     */         break;
/* 149 */       Name pname = name.getPrefix(sz);
/*     */       try
/*     */       {
/* 152 */         ctx.destroySubcontext(pname);
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 156 */         log.trace("Unable to remove context " + pname, e);
/* 157 */         break;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object lookup(String name, Class clazz)
/*     */     throws Exception
/*     */   {
/* 172 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 175 */       Object localObject1 = lookup(ctx, name, clazz);
/*     */       return localObject1; } finally { ctx.close(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public static Object lookup(Name name, Class clazz)
/*     */     throws Exception
/*     */   {
/* 193 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 196 */       Object localObject1 = lookup(ctx, name, clazz);
/*     */       return localObject1; } finally { ctx.close(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public static Object lookup(Context context, String name, Class clazz)
/*     */     throws Exception
/*     */   {
/* 215 */     Object result = context.lookup(name);
/* 216 */     checkObject(context, name, result, clazz);
/* 217 */     return result;
/*     */   }
/*     */ 
/*     */   public static Object lookup(Context context, Name name, Class clazz)
/*     */     throws Exception
/*     */   {
/* 231 */     Object result = context.lookup(name);
/* 232 */     checkObject(context, name.toString(), result, clazz);
/* 233 */     return result;
/*     */   }
/*     */ 
/*     */   public static void createLinkRef(String fromName, String toName)
/*     */     throws NamingException
/*     */   {
/* 245 */     InitialContext ctx = new InitialContext();
/* 246 */     createLinkRef(ctx, fromName, toName);
/*     */   }
/*     */ 
/*     */   public static void createLinkRef(Context ctx, String fromName, String toName)
/*     */     throws NamingException
/*     */   {
/* 259 */     LinkRef link = new LinkRef(toName);
/* 260 */     Context fromCtx = ctx;
/* 261 */     Name name = ctx.getNameParser("").parse(fromName);
/* 262 */     String atom = name.get(name.size() - 1);
/* 263 */     for (int n = 0; n < name.size() - 1; n++)
/*     */     {
/* 265 */       String comp = name.get(n);
/*     */       try
/*     */       {
/* 268 */         fromCtx = (Context)fromCtx.lookup(comp);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 272 */         fromCtx = fromCtx.createSubcontext(comp);
/*     */       }
/*     */     }
/*     */ 
/* 276 */     log.debug("atom: " + atom);
/* 277 */     log.debug("link: " + link);
/*     */ 
/* 279 */     fromCtx.rebind(atom, link);
/*     */ 
/* 281 */     log.debug("Bound link " + fromName + " to " + toName);
/*     */   }
/*     */ 
/*     */   public static void removeLinkRef(String name)
/*     */     throws NamingException
/*     */   {
/* 292 */     InitialContext ctx = new InitialContext();
/* 293 */     removeLinkRef(ctx, name);
/*     */   }
/*     */ 
/*     */   public static void removeLinkRef(Context ctx, String name)
/*     */     throws NamingException
/*     */   {
/* 305 */     log.debug("Unbinding link " + name);
/* 306 */     ctx.unbind(name);
/*     */   }
/*     */ 
/*     */   protected static void checkObject(Context context, String name, Object object, Class clazz)
/*     */     throws Exception
/*     */   {
/* 320 */     Class objectClass = object.getClass();
/* 321 */     if (!clazz.isAssignableFrom(objectClass))
/*     */     {
/* 323 */       StringBuffer buffer = new StringBuffer(100);
/* 324 */       buffer.append("Object at '").append(name);
/* 325 */       buffer.append("' in context ").append(context.getEnvironment());
/* 326 */       buffer.append(" is not an instance of ");
/* 327 */       appendClassInfo(buffer, clazz);
/* 328 */       buffer.append(" object class is ");
/* 329 */       appendClassInfo(buffer, object.getClass());
/* 330 */       throw new ClassCastException(buffer.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static void appendClassInfo(StringBuffer buffer, Class clazz)
/*     */   {
/* 342 */     buffer.append("[class=").append(clazz.getName());
/* 343 */     buffer.append(" classloader=").append(clazz.getClassLoader());
/* 344 */     buffer.append(" interfaces={");
/* 345 */     Class[] interfaces = clazz.getInterfaces();
/* 346 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 348 */       if (i > 0)
/* 349 */         buffer.append(", ");
/* 350 */       buffer.append("interface=").append(interfaces[i].getName());
/* 351 */       buffer.append(" classloader=").append(interfaces[i].getClassLoader());
/*     */     }
/* 353 */     buffer.append("}]");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.naming.Util
 * JD-Core Version:    0.6.0
 */