/*    */ package org.jboss.util.naming;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.LinkRef;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.RefAddr;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ENCThreadLocalKey
/*    */   implements ObjectFactory
/*    */ {
/* 43 */   private static final Logger log = Logger.getLogger(ENCThreadLocalKey.class);
/*    */ 
/* 48 */   private static final ThreadLocal key = new ThreadLocal();
/*    */ 
/*    */   public static void setKey(String tlkey)
/*    */   {
/* 52 */     key.set(tlkey);
/*    */   }
/*    */ 
/*    */   public static String getKey()
/*    */   {
/* 57 */     return (String)key.get();
/*    */   }
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*    */     throws Exception
/*    */   {
/* 66 */     Reference ref = (Reference)obj;
/* 67 */     String reftype = (String)key.get();
/* 68 */     boolean trace = log.isTraceEnabled();
/*    */ 
/* 70 */     if (reftype == null)
/*    */     {
/* 72 */       if (trace)
/* 73 */         log.trace("using default in ENC");
/* 74 */       reftype = "default";
/*    */     }
/*    */ 
/* 77 */     RefAddr addr = ref.get(reftype);
/* 78 */     if (addr == null)
/*    */     {
/* 80 */       if (trace)
/* 81 */         log.trace("using default in ENC");
/* 82 */       addr = ref.get("default");
/*    */     }
/* 84 */     if (addr != null)
/*    */     {
/* 86 */       String target = (String)addr.getContent();
/* 87 */       if (trace)
/* 88 */         log.trace("found Reference " + reftype + " with content " + target);
/* 89 */       return new LinkRef(target);
/*    */     }
/* 91 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.naming.ENCThreadLocalKey
 * JD-Core Version:    0.6.0
 */