/*     */ package org.jboss.util.loading;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.net.URLStreamHandlerFactory;
/*     */ 
/*     */ public class DelegatingClassLoader extends URLClassLoader
/*     */ {
/*  43 */   public static final URL[] EMPTY_URL_ARRAY = new URL[0];
/*     */ 
/*  46 */   protected boolean standard = false;
/*     */ 
/*     */   public DelegatingClassLoader(ClassLoader parent)
/*     */   {
/*  55 */     super(EMPTY_URL_ARRAY, parent);
/*  56 */     if (parent == null)
/*  57 */       throw new IllegalArgumentException("No parent");
/*     */   }
/*     */ 
/*     */   public DelegatingClassLoader(ClassLoader parent, URLStreamHandlerFactory factory)
/*     */   {
/*  68 */     super(EMPTY_URL_ARRAY, parent, factory);
/*  69 */     if (parent == null)
/*  70 */       throw new IllegalArgumentException("No parent");
/*     */   }
/*     */ 
/*     */   protected Class loadClass(String className, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/*  85 */     if (this.standard) {
/*  86 */       return super.loadClass(className, resolve);
/*     */     }
/*     */ 
/*  89 */     Class clazz = null;
/*     */     try
/*     */     {
/*  92 */       clazz = getParent().loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  98 */       clazz = findLoadedClass(className);
/*  99 */       if (clazz == null) {
/* 100 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/* 104 */     if (resolve) {
/* 105 */       resolveClass(clazz);
/*     */     }
/* 107 */     return clazz;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.loading.DelegatingClassLoader
 * JD-Core Version:    0.6.0
 */