/*    */ package org.jboss.util.loading;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ public class ContextClassLoader
/*    */ {
/* 42 */   public static final RuntimePermission GETCLASSLOADER = new RuntimePermission("getClassLoader");
/*    */ 
/* 47 */   public static final NewInstance INSTANTIATOR = new NewInstance(null);
/*    */ 
/*    */   ContextClassLoader()
/*    */   {
/* 56 */     SecurityManager manager = System.getSecurityManager();
/* 57 */     if (manager != null)
/*    */     {
/* 59 */       manager.checkPermission(GETCLASSLOADER);
/*    */     }
/*    */   }
/*    */ 
/*    */   public ClassLoader getContextClassLoader()
/*    */   {
/* 70 */     return getContextClassLoader(Thread.currentThread());
/*    */   }
/*    */ 
/*    */   public ClassLoader getContextClassLoader(Thread thread)
/*    */   {
/* 81 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*    */     {
/*    */       public Object run()
/*    */       {
/* 85 */         return this.val$thread.getContextClassLoader();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   private static class NewInstance implements PrivilegedAction
/*    */   {
/*    */     public Object run()
/*    */     {
/* 95 */       return new ContextClassLoader();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.loading.ContextClassLoader
 * JD-Core Version:    0.6.0
 */