/*     */ package org.jboss.util.id;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.util.HashCode;
/*     */ import org.jboss.util.platform.PID;
/*     */ 
/*     */ public class VMID
/*     */   implements ID
/*     */ {
/*     */   protected final byte[] address;
/*     */   protected final PID pid;
/*     */   protected final UID uid;
/*     */   protected final int hashCode;
/* 212 */   private static VMID instance = null;
/*     */ 
/* 231 */   public static final byte[] UNKNOWN_HOST = { 0, 0, 0, 0 };
/*     */ 
/*     */   protected VMID(byte[] address, PID pid, UID uid)
/*     */   {
/*  82 */     this.address = address;
/*  83 */     this.pid = pid;
/*  84 */     this.uid = uid;
/*     */ 
/*  87 */     int code = pid.hashCode();
/*  88 */     code ^= uid.hashCode();
/*  89 */     code ^= HashCode.generate(address);
/*  90 */     this.hashCode = code;
/*     */   }
/*     */ 
/*     */   protected VMID(VMID vmid)
/*     */   {
/*  99 */     this.address = vmid.address;
/* 100 */     this.pid = vmid.pid;
/* 101 */     this.uid = vmid.uid;
/* 102 */     this.hashCode = vmid.hashCode;
/*     */   }
/*     */ 
/*     */   public final byte[] getAddress()
/*     */   {
/* 111 */     return this.address;
/*     */   }
/*     */ 
/*     */   public final PID getProcessID()
/*     */   {
/* 120 */     return this.pid;
/*     */   }
/*     */ 
/*     */   public final UID getUID()
/*     */   {
/* 129 */     return this.uid;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 138 */     StringBuffer buff = new StringBuffer();
/*     */ 
/* 140 */     for (int i = 0; i < this.address.length; i++) {
/* 141 */       int n = this.address[i] & 0xFF;
/* 142 */       buff.append(Integer.toString(n, 36));
/*     */     }
/*     */ 
/* 145 */     buff.append("-").append(this.pid.toString(36));
/* 146 */     buff.append("-").append(this.uid);
/*     */ 
/* 148 */     return buff.toString();
/*     */   }
/*     */ 
/*     */   public final int hashCode()
/*     */   {
/* 157 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 170 */     if (obj == this) return true;
/*     */ 
/* 172 */     if ((obj != null) && (obj.getClass() == getClass())) {
/* 173 */       VMID vmid = (VMID)obj;
/* 174 */       return (Arrays.equals(vmid.address, this.address)) && (vmid.pid.equals(this.pid)) && (vmid.uid.equals(this.uid));
/*     */     }
/*     */ 
/* 180 */     return false;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 190 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 193 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static String asString()
/*     */   {
/* 203 */     return getInstance().toString();
/*     */   }
/*     */ 
/*     */   public static synchronized VMID getInstance()
/*     */   {
/* 221 */     if (instance == null) {
/* 222 */       instance = create();
/*     */     }
/* 224 */     return instance;
/*     */   }
/*     */ 
/*     */   private static byte[] getHostAddress()
/*     */   {
/* 237 */     return (byte[])(byte[])AccessController.doPrivileged(new PrivilegedAction() {
/*     */       public Object run() {
/*     */         try {
/* 240 */           return InetAddress.getLocalHost().getAddress();
/*     */         } catch (Exception e) {
/*     */         }
/* 243 */         return VMID.UNKNOWN_HOST;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private static VMID create()
/*     */   {
/* 256 */     byte[] address = getHostAddress();
/*     */ 
/* 258 */     return new VMID(address, PID.getInstance(), new UID());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.id.VMID
 * JD-Core Version:    0.6.0
 */