/*     */ package org.jboss.util.id;
/*     */ 
/*     */ import java.util.concurrent.atomic.AtomicLong;
/*     */ 
/*     */ public class UID
/*     */   implements ID
/*     */ {
/*     */   private static final long serialVersionUID = -8093336932569424512L;
/*  56 */   protected static final AtomicLong COUNTER = new AtomicLong(0L);
/*     */   protected final long time;
/*     */   protected final long id;
/*     */ 
/*     */   public UID()
/*     */   {
/*  68 */     this.time = System.currentTimeMillis();
/*  69 */     this.id = COUNTER.incrementAndGet();
/*     */   }
/*     */ 
/*     */   protected UID(UID uid)
/*     */   {
/*  76 */     this.time = uid.time;
/*  77 */     this.id = uid.id;
/*     */   }
/*     */ 
/*     */   public final long getTime()
/*     */   {
/*  86 */     return this.time;
/*     */   }
/*     */ 
/*     */   public final long getID()
/*     */   {
/*  95 */     return this.id;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 104 */     return Long.toString(this.time, 36) + "-" + Long.toString(this.id, 36);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 116 */     return (int)this.id;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 126 */     if (obj == this) return true;
/*     */ 
/* 128 */     if ((obj != null) && (obj.getClass() == getClass())) {
/* 129 */       UID uid = (UID)obj;
/*     */ 
/* 131 */       return (uid.time == this.time) && (uid.id == this.id);
/*     */     }
/*     */ 
/* 136 */     return false;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 146 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 149 */     throw new InternalError();
/*     */   }
/*     */ 
/*     */   public static String asString()
/*     */   {
/* 159 */     return new UID().toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.id.UID
 * JD-Core Version:    0.6.0
 */