/*     */ package org.jboss.util.graph;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ 
/*     */ public class Vertex<T>
/*     */ {
/*     */   private List<Edge<T>> incomingEdges;
/*     */   private List<Edge<T>> outgoingEdges;
/*     */   private String name;
/*     */   private boolean mark;
/*     */   private int markState;
/*     */   private T data;
/*     */ 
/*     */   public Vertex()
/*     */   {
/*  47 */     this(null, null);
/*     */   }
/*     */ 
/*     */   public Vertex(String n)
/*     */   {
/*  55 */     this(n, null);
/*     */   }
/*     */ 
/*     */   public Vertex(String n, T data)
/*     */   {
/*  64 */     this.incomingEdges = new ArrayList();
/*  65 */     this.outgoingEdges = new ArrayList();
/*  66 */     this.name = n;
/*  67 */     this.mark = false;
/*  68 */     this.data = data;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  76 */     return this.name;
/*     */   }
/*     */ 
/*     */   public T getData()
/*     */   {
/*  84 */     return this.data;
/*     */   }
/*     */ 
/*     */   public void setData(T data)
/*     */   {
/*  92 */     this.data = data;
/*     */   }
/*     */ 
/*     */   public boolean addEdge(Edge<T> e)
/*     */   {
/* 106 */     if (e.getFrom() == this)
/* 107 */       this.outgoingEdges.add(e);
/* 108 */     else if (e.getTo() == this)
/* 109 */       this.incomingEdges.add(e);
/*     */     else
/* 111 */       return false;
/* 112 */     return true;
/*     */   }
/*     */ 
/*     */   public void addOutgoingEdge(Vertex<T> to, int cost)
/*     */   {
/* 123 */     Edge out = new Edge(this, to, cost);
/* 124 */     this.outgoingEdges.add(out);
/*     */   }
/*     */ 
/*     */   public void addIncomingEdge(Vertex<T> from, int cost)
/*     */   {
/* 135 */     Edge out = new Edge(this, from, cost);
/* 136 */     this.incomingEdges.add(out);
/*     */   }
/*     */ 
/*     */   public boolean hasEdge(Edge<T> e)
/*     */   {
/* 148 */     if (e.getFrom() == this)
/* 149 */       return this.incomingEdges.contains(e);
/* 150 */     if (e.getTo() == this) {
/* 151 */       return this.outgoingEdges.contains(e);
/*     */     }
/* 153 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean remove(Edge<T> e)
/*     */   {
/* 165 */     if (e.getFrom() == this)
/* 166 */       this.incomingEdges.remove(e);
/* 167 */     else if (e.getTo() == this)
/* 168 */       this.outgoingEdges.remove(e);
/*     */     else
/* 170 */       return false;
/* 171 */     return true;
/*     */   }
/*     */ 
/*     */   public int getIncomingEdgeCount()
/*     */   {
/* 180 */     return this.incomingEdges.size();
/*     */   }
/*     */ 
/*     */   public Edge<T> getIncomingEdge(int i)
/*     */   {
/* 190 */     return (Edge)this.incomingEdges.get(i);
/*     */   }
/*     */ 
/*     */   public List getIncomingEdges()
/*     */   {
/* 199 */     return this.incomingEdges;
/*     */   }
/*     */ 
/*     */   public int getOutgoingEdgeCount()
/*     */   {
/* 208 */     return this.outgoingEdges.size();
/*     */   }
/*     */ 
/*     */   public Edge<T> getOutgoingEdge(int i)
/*     */   {
/* 218 */     return (Edge)this.outgoingEdges.get(i);
/*     */   }
/*     */ 
/*     */   public List getOutgoingEdges()
/*     */   {
/* 227 */     return this.outgoingEdges;
/*     */   }
/*     */ 
/*     */   public Edge<T> findEdge(Vertex<T> dest)
/*     */   {
/* 239 */     for (Edge e : this.outgoingEdges)
/*     */     {
/* 241 */       if (e.getTo() == dest)
/* 242 */         return e;
/*     */     }
/* 244 */     return null;
/*     */   }
/*     */ 
/*     */   public Edge<T> findEdge(Edge<T> e)
/*     */   {
/* 256 */     if (this.outgoingEdges.contains(e)) {
/* 257 */       return e;
/*     */     }
/* 259 */     return null;
/*     */   }
/*     */ 
/*     */   public int cost(Vertex<T> dest)
/*     */   {
/* 272 */     if (dest == this) {
/* 273 */       return 0;
/*     */     }
/* 275 */     Edge e = findEdge(dest);
/* 276 */     int cost = 2147483647;
/* 277 */     if (e != null)
/* 278 */       cost = e.getCost();
/* 279 */     return cost;
/*     */   }
/*     */ 
/*     */   public boolean hasEdge(Vertex<T> dest)
/*     */   {
/* 291 */     return findEdge(dest) != null;
/*     */   }
/*     */ 
/*     */   public boolean visited()
/*     */   {
/* 300 */     return this.mark;
/*     */   }
/*     */ 
/*     */   public void mark()
/*     */   {
/* 309 */     this.mark = true;
/*     */   }
/*     */ 
/*     */   public void setMarkState(int state)
/*     */   {
/* 319 */     this.markState = state;
/*     */   }
/*     */ 
/*     */   public int getMarkState()
/*     */   {
/* 328 */     return this.markState;
/*     */   }
/*     */ 
/*     */   public void visit()
/*     */   {
/* 337 */     mark();
/*     */   }
/*     */ 
/*     */   public void clearMark()
/*     */   {
/* 346 */     this.mark = false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 355 */     StringBuffer tmp = new StringBuffer("Vertex(");
/* 356 */     tmp.append(this.name);
/* 357 */     tmp.append(", data=");
/* 358 */     tmp.append(this.data);
/* 359 */     tmp.append("), in:[");
/* 360 */     for (int i = 0; i < this.incomingEdges.size(); i++)
/*     */     {
/* 362 */       Edge e = (Edge)this.incomingEdges.get(i);
/* 363 */       if (i > 0)
/* 364 */         tmp.append(',');
/* 365 */       tmp.append('{');
/* 366 */       tmp.append(e.getFrom().name);
/* 367 */       tmp.append(',');
/* 368 */       tmp.append(e.getCost());
/* 369 */       tmp.append('}');
/*     */     }
/* 371 */     tmp.append("], out:[");
/* 372 */     for (int i = 0; i < this.outgoingEdges.size(); i++)
/*     */     {
/* 374 */       Edge e = (Edge)this.outgoingEdges.get(i);
/* 375 */       if (i > 0)
/* 376 */         tmp.append(',');
/* 377 */       tmp.append('{');
/* 378 */       tmp.append(e.getTo().name);
/* 379 */       tmp.append(',');
/* 380 */       tmp.append(e.getCost());
/* 381 */       tmp.append('}');
/*     */     }
/* 383 */     tmp.append(']');
/* 384 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.graph.Vertex
 * JD-Core Version:    0.6.0
 */