/*     */ package org.jboss.util.graph;
/*     */ 
/*     */ public class Edge<T>
/*     */ {
/*     */   private Vertex<T> from;
/*     */   private Vertex<T> to;
/*     */   private int cost;
/*     */   private boolean mark;
/*     */ 
/*     */   public Edge(Vertex<T> from, Vertex<T> to)
/*     */   {
/*  44 */     this(from, to, 0);
/*     */   }
/*     */ 
/*     */   public Edge(Vertex<T> from, Vertex<T> to, int cost)
/*     */   {
/*  56 */     this.from = from;
/*  57 */     this.to = to;
/*  58 */     this.cost = cost;
/*  59 */     this.mark = false;
/*     */   }
/*     */ 
/*     */   public Vertex<T> getTo()
/*     */   {
/*  68 */     return this.to;
/*     */   }
/*     */ 
/*     */   public Vertex<T> getFrom()
/*     */   {
/*  77 */     return this.from;
/*     */   }
/*     */ 
/*     */   public int getCost()
/*     */   {
/*  86 */     return this.cost;
/*     */   }
/*     */ 
/*     */   public void mark()
/*     */   {
/*  95 */     this.mark = true;
/*     */   }
/*     */ 
/*     */   public void clearMark()
/*     */   {
/* 104 */     this.mark = false;
/*     */   }
/*     */ 
/*     */   public boolean isMarked()
/*     */   {
/* 113 */     return this.mark;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 122 */     StringBuffer tmp = new StringBuffer("Edge[from: ");
/* 123 */     tmp.append(this.from.getName());
/* 124 */     tmp.append(",to: ");
/* 125 */     tmp.append(this.to.getName());
/* 126 */     tmp.append(", cost: ");
/* 127 */     tmp.append(this.cost);
/* 128 */     tmp.append("]");
/* 129 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.graph.Edge
 * JD-Core Version:    0.6.0
 */