/*     */ package org.jboss.util.file;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.JarURLConnection;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.jar.JarInputStream;
/*     */ import java.util.jar.JarOutputStream;
/*     */ import java.util.jar.Manifest;
/*     */ import java.util.zip.ZipEntry;
/*     */ 
/*     */ public final class JarUtils
/*     */ {
/*     */   public static void jar(OutputStream out, File src)
/*     */     throws IOException
/*     */   {
/*  71 */     jar(out, new File[] { src }, null, null, null);
/*     */   }
/*     */ 
/*     */   public static void jar(OutputStream out, File[] src)
/*     */     throws IOException
/*     */   {
/*  89 */     jar(out, src, null, null, null);
/*     */   }
/*     */ 
/*     */   public static void jar(OutputStream out, File[] src, FileFilter filter)
/*     */     throws IOException
/*     */   {
/* 112 */     jar(out, src, filter, null, null);
/*     */   }
/*     */ 
/*     */   public static void jar(OutputStream out, File[] src, FileFilter filter, String prefix, Manifest man)
/*     */     throws IOException
/*     */   {
/* 138 */     for (int i = 0; i < src.length; i++)
/*     */     {
/* 140 */       if (src[i].exists())
/*     */         continue;
/* 142 */       throw new FileNotFoundException(src.toString());
/*     */     }
/*     */     JarOutputStream jout;
/*     */     JarOutputStream jout;
/* 147 */     if (man == null)
/*     */     {
/* 149 */       jout = new JarOutputStream(out);
/*     */     }
/*     */     else
/*     */     {
/* 153 */       jout = new JarOutputStream(out, man);
/*     */     }
/* 155 */     if ((prefix != null) && (prefix.length() > 0) && (!prefix.equals("/")))
/*     */     {
/* 158 */       if (prefix.charAt(0) == '/')
/*     */       {
/* 160 */         prefix = prefix.substring(1);
/*     */       }
/*     */ 
/* 163 */       if (prefix.charAt(prefix.length() - 1) != '/')
/*     */       {
/* 165 */         prefix = prefix + "/";
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 170 */       prefix = "";
/*     */     }
/* 172 */     JarInfo info = new JarInfo(jout, filter);
/* 173 */     for (int i = 0; i < src.length; i++)
/*     */     {
/* 175 */       jar(src[i], prefix, info);
/*     */     }
/* 177 */     jout.close();
/*     */   }
/*     */ 
/*     */   private static void jar(File src, String prefix, JarInfo info)
/*     */     throws IOException
/*     */   {
/* 207 */     JarOutputStream jout = info.out;
/* 208 */     if (src.isDirectory())
/*     */     {
/* 211 */       prefix = prefix + src.getName() + "/";
/* 212 */       ZipEntry entry = new ZipEntry(prefix);
/* 213 */       entry.setTime(src.lastModified());
/* 214 */       entry.setMethod(0);
/* 215 */       entry.setSize(0L);
/* 216 */       entry.setCrc(0L);
/* 217 */       jout.putNextEntry(entry);
/* 218 */       jout.closeEntry();
/*     */ 
/* 221 */       File[] files = src.listFiles(info.filter);
/* 222 */       for (int i = 0; i < files.length; i++)
/*     */       {
/* 224 */         jar(files[i], prefix, info);
/*     */       }
/*     */     }
/* 227 */     else if (src.isFile())
/*     */     {
/* 230 */       byte[] buffer = info.buffer;
/*     */ 
/* 233 */       ZipEntry entry = new ZipEntry(prefix + src.getName());
/* 234 */       entry.setTime(src.lastModified());
/* 235 */       jout.putNextEntry(entry);
/*     */ 
/* 238 */       FileInputStream in = new FileInputStream(src);
/*     */       int len;
/* 240 */       while ((len = in.read(buffer, 0, buffer.length)) != -1)
/*     */       {
/* 242 */         jout.write(buffer, 0, len);
/*     */       }
/* 244 */       in.close();
/* 245 */       jout.closeEntry();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void unjar(InputStream in, File dest)
/*     */     throws IOException
/*     */   {
/* 254 */     if (!dest.exists())
/*     */     {
/* 256 */       dest.mkdirs();
/*     */     }
/* 258 */     if (!dest.isDirectory())
/*     */     {
/* 260 */       throw new IOException("Destination must be a directory.");
/*     */     }
/* 262 */     JarInputStream jin = new JarInputStream(in);
/* 263 */     byte[] buffer = new byte[1024];
/*     */ 
/* 265 */     ZipEntry entry = jin.getNextEntry();
/* 266 */     while (entry != null)
/*     */     {
/* 268 */       String fileName = entry.getName();
/* 269 */       if (fileName.charAt(fileName.length() - 1) == '/')
/*     */       {
/* 271 */         fileName = fileName.substring(0, fileName.length() - 1);
/*     */       }
/* 273 */       if (fileName.charAt(0) == '/')
/*     */       {
/* 275 */         fileName = fileName.substring(1);
/*     */       }
/* 277 */       if (File.separatorChar != '/')
/*     */       {
/* 279 */         fileName = fileName.replace('/', File.separatorChar);
/*     */       }
/* 281 */       File file = new File(dest, fileName);
/* 282 */       if (entry.isDirectory())
/*     */       {
/* 285 */         file.mkdirs();
/* 286 */         jin.closeEntry();
/*     */       }
/*     */       else
/*     */       {
/* 291 */         File parent = file.getParentFile();
/* 292 */         if ((parent != null) && (!parent.exists()))
/*     */         {
/* 294 */           parent.mkdirs();
/*     */         }
/*     */ 
/* 298 */         OutputStream out = new FileOutputStream(file);
/* 299 */         int len = 0;
/* 300 */         while ((len = jin.read(buffer, 0, buffer.length)) != -1)
/*     */         {
/* 302 */           out.write(buffer, 0, len);
/*     */         }
/* 304 */         out.flush();
/* 305 */         out.close();
/* 306 */         jin.closeEntry();
/* 307 */         file.setLastModified(entry.getTime());
/*     */       }
/* 309 */       entry = jin.getNextEntry();
/*     */     }
/*     */ 
/* 314 */     Manifest mf = jin.getManifest();
/* 315 */     if (mf != null)
/*     */     {
/* 317 */       File file = new File(dest, "META-INF/MANIFEST.MF");
/* 318 */       File parent = file.getParentFile();
/* 319 */       if (!parent.exists())
/*     */       {
/* 321 */         parent.mkdirs();
/*     */       }
/* 323 */       OutputStream out = new FileOutputStream(file);
/* 324 */       mf.write(out);
/* 325 */       out.flush();
/* 326 */       out.close();
/*     */     }
/* 328 */     jin.close();
/*     */   }
/*     */ 
/*     */   public static URL extractNestedJar(URL jarURL, File dest)
/*     */     throws IOException
/*     */   {
/* 345 */     if (!jarURL.getProtocol().equals("jar")) {
/* 346 */       return jarURL;
/*     */     }
/* 348 */     String destPath = dest.getAbsolutePath();
/* 349 */     URLConnection urlConn = jarURL.openConnection();
/* 350 */     JarURLConnection jarConn = (JarURLConnection)urlConn;
/*     */ 
/* 352 */     String parentArchiveName = jarConn.getJarFile().getName();
/*     */ 
/* 354 */     int length = Math.min(destPath.length(), parentArchiveName.length());
/* 355 */     int n = 0;
/* 356 */     while (n < length)
/*     */     {
/* 358 */       char a = destPath.charAt(n);
/* 359 */       char b = parentArchiveName.charAt(n);
/* 360 */       if (a != b)
/*     */         break;
/* 362 */       n++;
/*     */     }
/*     */ 
/* 365 */     parentArchiveName = parentArchiveName.substring(n);
/*     */ 
/* 367 */     File archiveDir = new File(dest, parentArchiveName + "-contents");
/* 368 */     if ((!archiveDir.exists()) && (!archiveDir.mkdirs()))
/* 369 */       throw new IOException("Failed to create contents directory for archive, path=" + archiveDir.getAbsolutePath());
/* 370 */     String archiveName = jarConn.getEntryName();
/* 371 */     File archiveFile = new File(archiveDir, archiveName);
/* 372 */     File archiveParentDir = archiveFile.getParentFile();
/* 373 */     if ((!archiveParentDir.exists()) && (!archiveParentDir.mkdirs()))
/* 374 */       throw new IOException("Failed to create parent directory for archive, path=" + archiveParentDir.getAbsolutePath());
/* 375 */     InputStream archiveIS = jarConn.getInputStream();
/* 376 */     FileOutputStream fos = new FileOutputStream(archiveFile);
/* 377 */     BufferedOutputStream bos = new BufferedOutputStream(fos);
/* 378 */     byte[] buffer = new byte[4096];
/*     */     int read;
/* 380 */     while ((read = archiveIS.read(buffer)) > 0)
/*     */     {
/* 382 */       bos.write(buffer, 0, read);
/*     */     }
/* 384 */     archiveIS.close();
/* 385 */     bos.close();
/*     */ 
/* 388 */     return archiveFile.toURL();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 398 */     if (args.length == 0)
/*     */     {
/* 400 */       System.out.println("usage: <x or c> <jar-archive> <files...>");
/* 401 */       System.exit(0);
/*     */     }
/* 403 */     if (args[0].equals("x"))
/*     */     {
/* 405 */       BufferedInputStream in = new BufferedInputStream(new FileInputStream(args[1]));
/* 406 */       File dest = new File(args[2]);
/* 407 */       unjar(in, dest);
/*     */     }
/* 409 */     else if (args[0].equals("c"))
/*     */     {
/* 411 */       BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(args[1]));
/* 412 */       File[] src = new File[args.length - 2];
/* 413 */       for (int i = 0; i < src.length; i++)
/*     */       {
/* 415 */         src[i] = new File(args[(2 + i)]);
/*     */       }
/* 417 */       jar(out, src);
/*     */     }
/*     */     else
/*     */     {
/* 421 */       System.out.println("Need x or c as first argument");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class JarInfo
/*     */   {
/*     */     public JarOutputStream out;
/*     */     public FileFilter filter;
/*     */     public byte[] buffer;
/*     */ 
/*     */     public JarInfo(JarOutputStream out, FileFilter filter)
/*     */     {
/* 193 */       this.out = out;
/* 194 */       this.filter = filter;
/* 195 */       this.buffer = new byte[1024];
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.JarUtils
 * JD-Core Version:    0.6.0
 */