/*     */ package org.jboss.util.file;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Iterator;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarInputStream;
/*     */ 
/*     */ public class JarStreamBrowser
/*     */   implements Iterator
/*     */ {
/*     */   JarInputStream jar;
/*     */   JarEntry next;
/*     */   ArchiveBrowser.Filter filter;
/*     */ 
/*     */   public JarStreamBrowser(File file, ArchiveBrowser.Filter filter)
/*     */     throws IOException
/*     */   {
/*  49 */     this(new FileInputStream(file), filter);
/*     */   }
/*     */ 
/*     */   public JarStreamBrowser(InputStream is, ArchiveBrowser.Filter filter) throws IOException
/*     */   {
/*  54 */     this.filter = filter;
/*  55 */     this.jar = new JarInputStream(is);
/*  56 */     setNext();
/*     */   }
/*     */ 
/*     */   public boolean hasNext()
/*     */   {
/*  61 */     return this.next != null;
/*     */   }
/*     */ 
/*     */   private void setNext()
/*     */   {
/*     */     try
/*     */     {
/*  68 */       if (this.next != null) this.jar.closeEntry();
/*  69 */       this.next = null;
/*     */       do
/*     */       {
/*  72 */         this.next = this.jar.getNextJarEntry();
/*  73 */       }while ((this.next != null) && ((this.next.isDirectory()) || (!this.filter.accept(this.next.getName()))));
/*  74 */       if (this.next == null) this.jar.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  78 */       throw new RuntimeException("failed to browse jar", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/*  84 */     int size = (int)this.next.getSize();
/*  85 */     byte[] buf = new byte[size];
/*  86 */     int count = 0;
/*  87 */     int current = 0;
/*     */     try
/*     */     {
/*  95 */       while (((current = this.jar.read(buf, count, size - count)) != -1) && (count < size))
/*     */       {
/*  97 */         count += current;
/*     */       }
/*  99 */       ByteArrayInputStream bais = new ByteArrayInputStream(buf);
/* 100 */       setNext();
/* 101 */       return bais;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */       try
/*     */       {
/* 107 */         this.jar.close();
/*     */       }
/*     */       catch (IOException ignored)
/*     */       {
/*     */       }
/*     */     }
/* 113 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */   {
/* 119 */     throw new RuntimeException("Illegal operation on ArchiveBrowser");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.JarStreamBrowser
 * JD-Core Version:    0.6.0
 */