/*     */ package org.jboss.util.file;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.stream.Streams;
/*     */ 
/*     */ public final class Files
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(Files.class);
/*     */ 
/*  52 */   private static final char[] hexDigits = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
/*     */   public static final int DEFAULT_BUFFER_SIZE = 8192;
/*     */ 
/*     */   public static boolean delete(File dir)
/*     */   {
/*  65 */     boolean success = true;
/*     */ 
/*  67 */     File[] files = dir.listFiles();
/*  68 */     if (files != null)
/*     */     {
/*  70 */       for (int i = 0; i < files.length; i++)
/*     */       {
/*  72 */         File f = files[i];
/*  73 */         if (f.isDirectory() == true)
/*     */         {
/*  76 */           if (delete(f))
/*     */             continue;
/*  78 */           success = false;
/*  79 */           log.debug("Failed to delete dir: " + f.getAbsolutePath());
/*     */         }
/*     */         else
/*     */         {
/*  83 */           if (f.delete())
/*     */             continue;
/*  85 */           success = false;
/*  86 */           log.debug("Failed to delete file: " + f.getAbsolutePath());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  92 */     if (!dir.delete())
/*     */     {
/*  94 */       success = false;
/*  95 */       log.debug("Failed to delete dir: " + dir.getAbsolutePath());
/*     */     }
/*     */ 
/*  98 */     return success;
/*     */   }
/*     */ 
/*     */   public static boolean delete(String dirname)
/*     */   {
/* 109 */     return delete(new File(dirname));
/*     */   }
/*     */ 
/*     */   public static boolean deleteContaining(String filename)
/*     */   {
/* 121 */     File file = new File(filename);
/* 122 */     File containingDir = file.getParentFile();
/* 123 */     return delete(containingDir);
/*     */   }
/*     */ 
/*     */   public static void copy(File source, File target, byte[] buff)
/*     */     throws IOException
/*     */   {
/* 140 */     BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
/* 141 */     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
/*     */     try
/*     */     {
/*     */       int read;
/* 147 */       while ((read = in.read(buff)) != -1)
/*     */       {
/* 149 */         out.write(buff, 0, read);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 154 */       Streams.flush(out);
/* 155 */       Streams.close(in);
/* 156 */       Streams.close(out);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void copy(File source, File target, int size)
/*     */     throws IOException
/*     */   {
/* 174 */     copy(source, target, new byte[size]);
/*     */   }
/*     */ 
/*     */   public static void copy(File source, File target)
/*     */     throws IOException
/*     */   {
/* 188 */     copy(source, target, 8192);
/*     */   }
/*     */ 
/*     */   public static void copy(URL src, File dest)
/*     */     throws IOException
/*     */   {
/* 200 */     log.debug("Copying " + src + " -> " + dest);
/*     */ 
/* 203 */     File dir = dest.getParentFile();
/* 204 */     if (!dir.exists())
/*     */     {
/* 206 */       if (!dir.mkdirs())
/*     */       {
/* 208 */         throw new IOException("mkdirs failed for: " + dir.getAbsolutePath());
/*     */       }
/*     */     }
/*     */ 
/* 212 */     if (dest.exists())
/*     */     {
/* 214 */       if (!delete(dest))
/*     */       {
/* 216 */         throw new IOException("delete of previous content failed for: " + dest.getAbsolutePath());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 221 */     InputStream in = new BufferedInputStream(src.openStream());
/* 222 */     OutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
/* 223 */     Streams.copy(in, out);
/* 224 */     out.flush();
/* 225 */     out.close();
/* 226 */     in.close();
/*     */   }
/*     */ 
/*     */   public static String encodeFileName(String name)
/*     */   {
/* 243 */     return encodeFileName(name, '@');
/*     */   }
/*     */ 
/*     */   public static String decodeFileName(String name)
/*     */   {
/* 263 */     return decodeFileName(name, '@');
/*     */   }
/*     */ 
/*     */   public static String encodeFileName(String name, char escape)
/*     */   {
/* 275 */     StringBuffer rc = new StringBuffer();
/* 276 */     for (int i = 0; i < name.length(); i++)
/*     */     {
/* 278 */       switch (name.charAt(i)) { case '-':
/*     */       case '.':
/*     */       case '0':
/*     */       case '1':
/*     */       case '2':
/*     */       case '3':
/*     */       case '4':
/*     */       case '5':
/*     */       case '6':
/*     */       case '7':
/*     */       case '8':
/*     */       case '9':
/*     */       case 'A':
/*     */       case 'B':
/*     */       case 'C':
/*     */       case 'D':
/*     */       case 'E':
/*     */       case 'F':
/*     */       case 'G':
/*     */       case 'H':
/*     */       case 'I':
/*     */       case 'J':
/*     */       case 'K':
/*     */       case 'L':
/*     */       case 'M':
/*     */       case 'N':
/*     */       case 'O':
/*     */       case 'P':
/*     */       case 'Q':
/*     */       case 'R':
/*     */       case 'S':
/*     */       case 'T':
/*     */       case 'U':
/*     */       case 'V':
/*     */       case 'W':
/*     */       case 'X':
/*     */       case 'Y':
/*     */       case 'Z':
/*     */       case '_':
/*     */       case 'a':
/*     */       case 'b':
/*     */       case 'c':
/*     */       case 'd':
/*     */       case 'e':
/*     */       case 'f':
/*     */       case 'g':
/*     */       case 'h':
/*     */       case 'i':
/*     */       case 'j':
/*     */       case 'k':
/*     */       case 'l':
/*     */       case 'm':
/*     */       case 'n':
/*     */       case 'o':
/*     */       case 'p':
/*     */       case 'q':
/*     */       case 'r':
/*     */       case 's':
/*     */       case 't':
/*     */       case 'u':
/*     */       case 'v':
/*     */       case 'w':
/*     */       case 'x':
/*     */       case 'y':
/*     */       case 'z':
/* 293 */         rc.append(name.charAt(i));
/* 294 */         break;
/*     */       case '/':
/*     */       case ':':
/*     */       case ';':
/*     */       case '<':
/*     */       case '=':
/*     */       case '>':
/*     */       case '?':
/*     */       case '@':
/*     */       case '[':
/*     */       case '\\':
/*     */       case ']':
/*     */       case '^':
/*     */       case '`':
/*     */       default:
/*     */         try { byte[] data = ("" + name.charAt(i)).getBytes("UTF8");
/* 307 */           for (int j = 0; j < data.length; j++)
/*     */           {
/* 309 */             rc.append(escape);
/* 310 */             rc.append(hexDigits[(data[j] >> 4 & 0xF)]);
/* 311 */             rc.append(hexDigits[(data[j] & 0xF)]);
/*     */           }
/*     */         }
/*     */         catch (UnsupportedEncodingException wonthappen)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 320 */     return rc.toString();
/*     */   }
/*     */ 
/*     */   public static String decodeFileName(String name, char escape)
/*     */   {
/* 332 */     if (name == null)
/*     */     {
/* 334 */       return null;
/*     */     }
/* 336 */     StringBuffer sbuf = new StringBuffer(name.length());
/*     */ 
/* 338 */     for (int i = 0; i < name.length(); i++)
/*     */     {
/* 340 */       char c = name.charAt(i);
/* 341 */       if (c == escape)
/*     */       {
/* 343 */         i++; char h1 = name.charAt(i);
/* 344 */         i++; char h2 = name.charAt(i);
/*     */ 
/* 347 */         int d1 = h1 >= 'A' ? '\n' + h1 - 65 : h1 >= 'a' ? '\n' + h1 - 97 : h1 - '0';
/*     */ 
/* 351 */         int d2 = h2 >= 'A' ? '\n' + h2 - 65 : h2 >= 'a' ? '\n' + h2 - 97 : h2 - '0';
/*     */ 
/* 358 */         byte[] bytes = { (byte)(d1 * 16 + d2) };
/*     */         try
/*     */         {
/* 362 */           String s = new String(bytes, "UTF8");
/* 363 */           sbuf.append(s);
/*     */         }
/*     */         catch (UnsupportedEncodingException wonthappen)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 372 */         sbuf.append(c);
/*     */       }
/*     */     }
/* 375 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   public static String findRelativePath(String base, String path)
/*     */     throws IOException
/*     */   {
/* 388 */     String a = new File(base).getCanonicalFile().toURI().getPath();
/* 389 */     String b = new File(path).getCanonicalFile().toURI().getPath();
/* 390 */     String[] basePaths = a.split("/");
/* 391 */     String[] otherPaths = b.split("/");
/* 392 */     int n = 0;
/* 393 */     for (; (n < basePaths.length) && (n < otherPaths.length); n++)
/*     */     {
/* 395 */       if (!basePaths[n].equals(otherPaths[n]))
/*     */         break;
/*     */     }
/* 398 */     System.out.println("Common length: " + n);
/* 399 */     StringBuffer tmp = new StringBuffer("../");
/* 400 */     for (int m = n; m < basePaths.length - 1; m++)
/* 401 */       tmp.append("../");
/* 402 */     for (int m = n; m < otherPaths.length; m++)
/*     */     {
/* 404 */       tmp.append(otherPaths[m]);
/* 405 */       tmp.append("/");
/*     */     }
/*     */ 
/* 408 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.Files
 * JD-Core Version:    0.6.0
 */