/*    */ package org.jboss.util.file;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.FilenameFilter;
/*    */ 
/*    */ public class FilenamePrefixFilter
/*    */   implements FilenameFilter
/*    */ {
/*    */   protected final String prefix;
/*    */   protected final boolean ignoreCase;
/*    */ 
/*    */   public FilenamePrefixFilter(String prefix, boolean ignoreCase)
/*    */   {
/* 51 */     this.ignoreCase = ignoreCase;
/* 52 */     this.prefix = (ignoreCase ? prefix.toLowerCase() : prefix);
/*    */   }
/*    */ 
/*    */   public FilenamePrefixFilter(String prefix)
/*    */   {
/* 61 */     this(prefix, false);
/*    */   }
/*    */ 
/*    */   public boolean accept(File dir, String name)
/*    */   {
/* 72 */     if (this.ignoreCase) {
/* 73 */       return name.toLowerCase().startsWith(this.prefix);
/*    */     }
/*    */ 
/* 76 */     return name.startsWith(this.prefix);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.FilenamePrefixFilter
 * JD-Core Version:    0.6.0
 */