/*    */ package org.jboss.util.file;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.FileFilter;
/*    */ 
/*    */ public class FilePrefixFilter
/*    */   implements FileFilter
/*    */ {
/*    */   protected final String prefix;
/*    */   protected final boolean ignoreCase;
/*    */ 
/*    */   public FilePrefixFilter(String prefix, boolean ignoreCase)
/*    */   {
/* 51 */     this.ignoreCase = ignoreCase;
/* 52 */     this.prefix = (ignoreCase ? prefix.toLowerCase() : prefix);
/*    */   }
/*    */ 
/*    */   public FilePrefixFilter(String prefix)
/*    */   {
/* 61 */     this(prefix, false);
/*    */   }
/*    */ 
/*    */   public boolean accept(File file)
/*    */   {
/* 71 */     if (this.ignoreCase) {
/* 72 */       return file.getName().toLowerCase().startsWith(this.prefix);
/*    */     }
/*    */ 
/* 75 */     return file.getName().startsWith(this.prefix);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.FilePrefixFilter
 * JD-Core Version:    0.6.0
 */