/*    */ package org.jboss.util.file;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.FileInputStream;
/*    */ import java.io.FileNotFoundException;
/*    */ import java.util.ArrayList;
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ 
/*    */ public class DirectoryArchiveBrowser
/*    */   implements Iterator
/*    */ {
/*    */   private Iterator files;
/*    */ 
/*    */   public DirectoryArchiveBrowser(File file, ArchiveBrowser.Filter filter)
/*    */   {
/* 43 */     ArrayList list = new ArrayList();
/*    */     try
/*    */     {
/* 46 */       create(list, file, filter);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 50 */       throw new RuntimeException(e);
/*    */     }
/* 52 */     this.files = list.iterator();
/*    */   }
/*    */ 
/*    */   public static void create(List list, File dir, ArchiveBrowser.Filter filter) throws Exception
/*    */   {
/* 57 */     File[] files = dir.listFiles();
/* 58 */     for (int i = 0; i < files.length; i++)
/*    */     {
/* 60 */       if (files[i].isDirectory())
/*    */       {
/* 62 */         create(list, files[i], filter);
/*    */       }
/*    */       else
/*    */       {
/* 66 */         if (!filter.accept(files[i].getAbsolutePath()))
/*    */           continue;
/* 68 */         list.add(files[i]);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean hasNext()
/*    */   {
/* 76 */     return this.files.hasNext();
/*    */   }
/*    */ 
/*    */   public Object next()
/*    */   {
/* 81 */     File fp = (File)this.files.next();
/*    */     try
/*    */     {
/* 84 */       return new FileInputStream(fp);
/*    */     }
/*    */     catch (FileNotFoundException e) {
/*    */     }
/* 88 */     throw new RuntimeException(e);
/*    */   }
/*    */ 
/*    */   public void remove()
/*    */   {
/* 94 */     throw new RuntimeException("Illegal operation call");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.file.DirectoryArchiveBrowser
 * JD-Core Version:    0.6.0
 */