/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.lang.reflect.GenericArrayType;
/*     */ import java.lang.reflect.GenericDeclaration;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.lang.reflect.WildcardType;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ 
/*     */ public abstract class WeakTypeCache<T>
/*     */ {
/*  50 */   private Map<ClassLoader, Map<String, T>> cache = new WeakHashMap();
/*     */ 
/*     */   public T get(Type type)
/*     */   {
/*  61 */     if (type == null) {
/*  62 */       throw new IllegalArgumentException("Null type");
/*     */     }
/*  64 */     if ((type instanceof ParameterizedType))
/*  65 */       return getParameterizedType((ParameterizedType)type);
/*  66 */     if ((type instanceof Class))
/*  67 */       return getClass((Class)type);
/*  68 */     if ((type instanceof TypeVariable))
/*     */     {
/*  70 */       return getTypeVariable((TypeVariable)type);
/*  71 */     }if ((type instanceof GenericArrayType))
/*  72 */       return getGenericArrayType((GenericArrayType)type);
/*  73 */     if ((type instanceof WildcardType)) {
/*  74 */       return getWildcardType((WildcardType)type);
/*     */     }
/*  76 */     throw new UnsupportedOperationException("Unknown type: " + type + " class=" + type.getClass());
/*     */   }
/*     */ 
/*     */   public T get(String name, ClassLoader cl)
/*     */     throws ClassNotFoundException
/*     */   {
/*  89 */     if (name == null)
/*  90 */       throw new IllegalArgumentException("Null name");
/*  91 */     if (cl == null) {
/*  92 */       throw new IllegalArgumentException("Null classloader");
/*     */     }
/*  94 */     Class clazz = cl.loadClass(name);
/*  95 */     return get(clazz);
/*     */   }
/*     */ 
/*     */   protected abstract T instantiate(Class<?> paramClass);
/*     */ 
/*     */   protected abstract void generate(Class<?> paramClass, T paramT);
/*     */ 
/*     */   protected abstract T instantiate(ParameterizedType paramParameterizedType);
/*     */ 
/*     */   protected abstract void generate(ParameterizedType paramParameterizedType, T paramT);
/*     */ 
/*     */   protected T getParameterizedType(ParameterizedType type)
/*     */   {
/* 139 */     Object result = peek(type);
/* 140 */     if (result != null) {
/* 141 */       return result;
/*     */     }
/*     */ 
/* 144 */     result = instantiate(type);
/*     */ 
/* 147 */     put(type, result);
/*     */ 
/* 150 */     generate(type, result);
/*     */ 
/* 152 */     return result;
/*     */   }
/*     */ 
/*     */   protected T getWildcardType(WildcardType type)
/*     */   {
/* 164 */     return get(type.getUpperBounds()[0]);
/*     */   }
/*     */ 
/*     */   protected <D extends GenericDeclaration> T getTypeVariable(TypeVariable<D> type)
/*     */   {
/* 177 */     return get(type.getBounds()[0]);
/*     */   }
/*     */ 
/*     */   protected T getGenericArrayType(GenericArrayType type)
/*     */   {
/* 189 */     return get([Ljava.lang.Object.class);
/*     */   }
/*     */ 
/*     */   protected T peek(ParameterizedType type)
/*     */   {
/* 200 */     Class rawType = (Class)type.getRawType();
/* 201 */     Map classLoaderCache = getClassLoaderCache(rawType.getClassLoader());
/*     */ 
/* 203 */     synchronized (classLoaderCache)
/*     */     {
/* 205 */       return classLoaderCache.get(type.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void put(ParameterizedType type, T result)
/*     */   {
/* 217 */     Class rawType = (Class)type.getRawType();
/* 218 */     Map classLoaderCache = getClassLoaderCache(rawType.getClassLoader());
/*     */ 
/* 220 */     synchronized (classLoaderCache)
/*     */     {
/* 223 */       classLoaderCache.put(type.toString(), result);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected T getClass(Class<?> clazz)
/*     */   {
/* 236 */     Object result = peek(clazz);
/* 237 */     if (result != null) {
/* 238 */       return result;
/*     */     }
/*     */ 
/* 241 */     result = instantiate(clazz);
/*     */ 
/* 244 */     put(clazz, result);
/*     */ 
/* 247 */     generate(clazz, result);
/*     */ 
/* 249 */     return result;
/*     */   }
/*     */ 
/*     */   protected T peek(Class<?> clazz)
/*     */   {
/* 260 */     Map classLoaderCache = getClassLoaderCache(clazz.getClassLoader());
/*     */ 
/* 262 */     synchronized (classLoaderCache)
/*     */     {
/* 264 */       return classLoaderCache.get(clazz.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void put(Class<?> clazz, T result)
/*     */   {
/* 276 */     Map classLoaderCache = getClassLoaderCache(clazz.getClassLoader());
/*     */ 
/* 278 */     synchronized (classLoaderCache)
/*     */     {
/* 280 */       classLoaderCache.put(clazz.getName(), result);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Map<String, T> getClassLoaderCache(ClassLoader cl)
/*     */   {
/* 292 */     synchronized (this.cache)
/*     */     {
/* 294 */       Map result = (Map)this.cache.get(cl);
/* 295 */       if (result == null)
/*     */       {
/* 297 */         result = new WeakValueHashMap();
/* 298 */         this.cache.put(cl, result);
/*     */       }
/* 300 */       return result;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.WeakTypeCache
 * JD-Core Version:    0.6.0
 */