/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.util.AbstractSet;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import java.util.Set;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ import org.jboss.util.WeakObject;
/*     */ 
/*     */ public class WeakSet extends AbstractSet
/*     */   implements Set
/*     */ {
/*  49 */   protected final ReferenceQueue queue = new ReferenceQueue();
/*     */   protected final Set set;
/*     */ 
/*     */   public WeakSet(Set set)
/*     */   {
/*  63 */     if (set == null) {
/*  64 */       throw new NullArgumentException("set");
/*     */     }
/*     */ 
/*  67 */     if (set.size() != 0) {
/*  68 */       Object[] elements = set.toArray();
/*  69 */       set.clear();
/*     */ 
/*  71 */       for (int i = 0; i < elements.length; i++) {
/*  72 */         add(elements[i]);
/*     */       }
/*     */     }
/*     */ 
/*  76 */     this.set = set;
/*     */   }
/*     */ 
/*     */   public WeakSet()
/*     */   {
/*  83 */     this(new HashSet());
/*     */   }
/*     */ 
/*     */   protected final void maintain()
/*     */   {
/*     */     WeakObject weak;
/*  92 */     while ((weak = (WeakObject)this.queue.poll()) != null)
/*  93 */       this.set.remove(weak);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 103 */     maintain();
/*     */ 
/* 105 */     return this.set.size();
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 114 */     return new Iterator()
/*     */     {
/* 117 */       Iterator iter = WeakSet.this.set.iterator();
/*     */ 
/* 120 */       Object UNKNOWN = new Object();
/*     */ 
/* 123 */       Object next = this.UNKNOWN;
/*     */ 
/*     */       public boolean hasNext() {
/* 126 */         if (this.next != this.UNKNOWN) {
/* 127 */           return true;
/*     */         }
/* 129 */         while (this.iter.hasNext()) {
/* 130 */           WeakObject weak = (WeakObject)this.iter.next();
/* 131 */           Object obj = null;
/* 132 */           if ((weak != null) && ((obj = weak.get()) == null))
/*     */           {
/*     */             continue;
/*     */           }
/* 136 */           this.next = obj;
/* 137 */           return true;
/*     */         }
/* 139 */         return false;
/*     */       }
/*     */ 
/*     */       public Object next() {
/* 143 */         if ((this.next == this.UNKNOWN) && (!hasNext())) {
/* 144 */           throw new NoSuchElementException();
/*     */         }
/* 146 */         Object obj = this.next;
/* 147 */         this.next = this.UNKNOWN;
/*     */ 
/* 149 */         return obj;
/*     */       }
/*     */ 
/*     */       public void remove() {
/* 153 */         this.iter.remove();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public boolean add(Object obj)
/*     */   {
/* 165 */     maintain();
/*     */ 
/* 167 */     return this.set.add(WeakObject.create(obj, this.queue));
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 176 */     maintain();
/*     */ 
/* 178 */     return this.set.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object obj)
/*     */   {
/* 188 */     maintain();
/*     */ 
/* 190 */     return this.set.contains(WeakObject.create(obj));
/*     */   }
/*     */ 
/*     */   public boolean remove(Object obj)
/*     */   {
/* 200 */     maintain();
/*     */ 
/* 202 */     return this.set.remove(WeakObject.create(obj));
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 209 */     this.set.clear();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 219 */     maintain();
/*     */     try
/*     */     {
/* 222 */       return super.clone();
/*     */     } catch (CloneNotSupportedException e) {
/*     */     }
/* 225 */     throw new InternalError();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.WeakSet
 * JD-Core Version:    0.6.0
 */