/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.util.AbstractMap;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class SoftValueHashMap extends AbstractMap
/*     */   implements Map
/*     */ {
/*     */   private Map hash;
/*  70 */   private ReferenceQueue queue = new ReferenceQueue();
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/*  62 */     processQueue();
/*  63 */     return this.hash.entrySet();
/*     */   }
/*     */ 
/*     */   private void processQueue()
/*     */   {
/*     */     SoftValueRef ref;
/*  78 */     while ((ref = (SoftValueRef)this.queue.poll()) != null) {
/*  79 */       if (ref != (SoftValueRef)this.hash.get(ref.key)) {
/*     */         continue;
/*     */       }
/*  82 */       this.hash.remove(ref.key);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SoftValueHashMap(int initialCapacity, float loadFactor)
/*     */   {
/* 105 */     this.hash = new HashMap(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public SoftValueHashMap(int initialCapacity)
/*     */   {
/* 121 */     this.hash = new HashMap(initialCapacity);
/*     */   }
/*     */ 
/*     */   public SoftValueHashMap()
/*     */   {
/* 131 */     this.hash = new HashMap();
/*     */   }
/*     */ 
/*     */   public SoftValueHashMap(Map t)
/*     */   {
/* 146 */     this(Math.max(2 * t.size(), 11), 0.75F);
/* 147 */     putAll(t);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 160 */     processQueue();
/* 161 */     return this.hash.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 169 */     processQueue();
/* 170 */     return this.hash.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 181 */     processQueue();
/* 182 */     return this.hash.containsKey(key);
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 196 */     processQueue();
/* 197 */     SoftReference ref = (SoftReference)this.hash.get(key);
/* 198 */     if (ref != null) return ref.get();
/* 199 */     return null;
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/* 218 */     processQueue();
/* 219 */     Object rtn = this.hash.put(key, SoftValueRef.access$000(key, value, this.queue));
/* 220 */     if (rtn != null) rtn = ((SoftReference)rtn).get();
/* 221 */     return rtn;
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 235 */     processQueue();
/* 236 */     return this.hash.remove(key);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 244 */     processQueue();
/* 245 */     this.hash.clear();
/*     */   }
/*     */ 
/*     */   private static class SoftValueRef extends SoftReference
/*     */   {
/*     */     public Object key;
/*     */ 
/*     */     private SoftValueRef(Object key, Object val, ReferenceQueue q)
/*     */     {
/*  49 */       super(q);
/*  50 */       this.key = key;
/*     */     }
/*     */ 
/*     */     private static SoftValueRef create(Object key, Object val, ReferenceQueue q)
/*     */     {
/*  55 */       if (val == null) return null;
/*  56 */       return new SoftValueRef(key, val, q);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.SoftValueHashMap
 * JD-Core Version:    0.6.0
 */