/*     */ package org.jboss.util.collection;
/*     */ 
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.lang.ref.SoftReference;
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class SoftSet
/*     */   implements Set
/*     */ {
/*  43 */   private HashMap map = new HashMap();
/*     */ 
/*  45 */   private ReferenceQueue gcqueue = new ReferenceQueue();
/*     */ 
/*     */   public int size()
/*     */   {
/*  91 */     processQueue();
/*  92 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/*  97 */     processQueue();
/*  98 */     return this.map.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/* 103 */     processQueue();
/* 104 */     Integer key = new Integer(o.hashCode());
/* 105 */     boolean contains = this.map.containsKey(key);
/* 106 */     return contains;
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 111 */     processQueue();
/* 112 */     Iterator theIter = this.map.values().iterator();
/* 113 */     return new ComparableSoftReferenceIterator(theIter);
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 118 */     processQueue();
/* 119 */     return toArray(new Object[0]);
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/* 124 */     processQueue();
/* 125 */     int size = this.map.size();
/* 126 */     Object[] array = new Object[0];
/* 127 */     if (a.length >= size)
/* 128 */       array = a;
/* 129 */     Iterator iter = this.map.values().iterator();
/* 130 */     int index = 0;
/* 131 */     while (iter.hasNext())
/*     */     {
/* 133 */       ComparableSoftReference csr = (ComparableSoftReference)iter.next();
/* 134 */       Object value = csr.get();
/*     */ 
/* 136 */       if (array.length == 0)
/*     */       {
/* 138 */         if (value == null)
/*     */         {
/* 140 */           index++;
/* 141 */           continue;
/*     */         }
/* 143 */         Array.newInstance(value.getClass(), size);
/*     */       }
/* 145 */       array[index] = value;
/* 146 */       index++;
/*     */     }
/* 148 */     return array;
/*     */   }
/*     */ 
/*     */   public boolean add(Object o)
/*     */   {
/* 153 */     processQueue();
/* 154 */     Integer key = new Integer(o.hashCode());
/* 155 */     ComparableSoftReference sr = new ComparableSoftReference(key, o, this.gcqueue);
/* 156 */     return this.map.put(key, sr) == null;
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 161 */     processQueue();
/* 162 */     Integer key = new Integer(o.hashCode());
/* 163 */     return this.map.remove(key) != null;
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection c)
/*     */   {
/* 168 */     processQueue();
/* 169 */     Iterator iter = c.iterator();
/* 170 */     boolean contains = true;
/* 171 */     while (iter.hasNext())
/*     */     {
/* 173 */       Object value = iter.next();
/* 174 */       Integer key = new Integer(value.hashCode());
/* 175 */       contains &= this.map.containsKey(key);
/*     */     }
/* 177 */     return contains;
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection c)
/*     */   {
/* 182 */     processQueue();
/* 183 */     Iterator iter = c.iterator();
/* 184 */     boolean added = false;
/* 185 */     while (iter.hasNext())
/*     */     {
/* 187 */       Object value = iter.next();
/* 188 */       Integer key = new Integer(value.hashCode());
/* 189 */       ComparableSoftReference sr = new ComparableSoftReference(key, value, this.gcqueue);
/* 190 */       added |= this.map.put(key, sr) == null;
/*     */     }
/* 192 */     return added;
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection c)
/*     */   {
/* 197 */     Iterator iter = iterator();
/* 198 */     boolean removed = false;
/* 199 */     while (iter.hasNext())
/*     */     {
/* 201 */       Object value = iter.next();
/* 202 */       if (!c.contains(value))
/*     */       {
/* 204 */         iter.remove();
/* 205 */         removed = true;
/*     */       }
/*     */     }
/* 208 */     return removed;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection c)
/*     */   {
/* 213 */     processQueue();
/* 214 */     Iterator iter = c.iterator();
/* 215 */     boolean removed = false;
/* 216 */     while (iter.hasNext())
/*     */     {
/* 218 */       Object value = iter.next();
/* 219 */       removed |= remove(value);
/*     */     }
/* 221 */     return removed;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 226 */     while (this.gcqueue.poll() != null);
/* 228 */     this.map.clear();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 233 */     return this.map.equals(o);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 238 */     return this.map.hashCode();
/*     */   }
/*     */ 
/*     */   private void processQueue()
/*     */   {
/*     */     ComparableSoftReference cr;
/* 248 */     while ((cr = (ComparableSoftReference)this.gcqueue.poll()) != null)
/*     */     {
/* 250 */       this.map.remove(cr.getKey());
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ComparableSoftReferenceIterator
/*     */     implements Iterator
/*     */   {
/*     */     Iterator theIter;
/*     */ 
/*     */     ComparableSoftReferenceIterator(Iterator theIter)
/*     */     {
/*  65 */       this.theIter = theIter;
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/*  69 */       return this.theIter.hasNext();
/*     */     }
/*     */ 
/*     */     public Object next() {
/*  73 */       SoftSet.ComparableSoftReference csr = (SoftSet.ComparableSoftReference)this.theIter.next();
/*  74 */       return csr.get();
/*     */     }
/*     */ 
/*     */     public void remove() {
/*  78 */       this.theIter.remove();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ComparableSoftReference extends SoftReference
/*     */   {
/*     */     private Integer key;
/*     */ 
/*     */     ComparableSoftReference(Integer key, Object o, ReferenceQueue q)
/*     */     {
/*  52 */       super(q);
/*  53 */       this.key = key;
/*     */     }
/*     */ 
/*     */     Integer getKey() {
/*  57 */       return this.key;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.util.collection.SoftSet
 * JD-Core Version:    0.6.0
 */